/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function HTTPExistsJob(/*[String]*/ inURL, /*[Function]*/ inResultFilter, /*[Function]*/ inErrorFilter)
{
	throwInvalid(inURL);

	var job = new Job(inResultFilter, inErrorFilter);
	var request = null;
	var url = inURL;

	//////////////////////////////////////////////////////////////////////////////
	//
	// Get Job result
	//
	this.getResult = function()
	{
		return job.getResult();
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Get Job error
	//
	this.getError = function()
	{
		return job.getError();
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Wait for Job completed
	//
	this.wait = function(/*[Function]*/ inSuccessFct, /*[Function]*/ inErrorFct)
	{
		job.wait(inSuccessFct, inErrorFct);
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Cancel Job
	//
	this.cancel = function()
	{
		if (isValidProperty(request))
		{
			request.abort();
		}

		request = null;

		job.cancel();
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Get Job status
	//
	this.getStatus = function()
	{
		return job.getStatus();
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Check Job status
	//
	this.isStatus = function(/*[Number]*/ inStatusFlags)
	{
		return job.isStatus(inStatusFlags);
	}

	// initialization /////////////////////////////////////////////////////////

	if (navigator.onLine)
	{
		request = new XMLHttpRequest();
		request.open("HEAD", inURL + "?t=" + Date.now());

		request.addEventListener('load', function(inEvObj)
		{
			if (isValidProperty(request) && request.status != 404)
			{
				job.setResult(true);
			}
			else if (!job.isStatus(IJob.STATUS_CANCELED))
			{
				job.setError("Resource does not exists: " + url);
			}
		});

		request.addEventListener('error', function(inEvObj)
		{
			job.setError('Request to ' + url + ' FAILED: ' + request);
		});

		request.addEventListener('abort', function(inEvObj)
		{
			job.setError('Request to ' + url + ' ABORTED');
		});

		request.send();
	}
	else
	{
		job.setError('Request to ' + url + ' FAILED: offline');
	}
}
