/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

var gWFTriggerComponentMgr = null;

function WorkflowTriggerComponentManager()
{
	var components = {};
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// return component for name
	//
	this.getComponent = function(/*[String]*/ inName)
	{
		var ret = null;
		
		if (isValidProperty(inName) &&
			isValidProperty(components[inName]))
		{
			ret = components[inName];
		}
		
		return ret;
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// initialize Workflow local components
	//
	this.initializeWorkflowJSON = function(/*Workflow*/ inWorkflow, /*Object*/ inJSON)
	{
		throwInvalid(inJSON, 'Array');

		for (var i=0; i<inJSON.length; i++)
		{
			var cmp = null;

			try
			{
				cmp = new WorkflowTriggerComponent();
				cmp.initializeJSON(inJSON[i]);

				if (isValidProperty(cmp.name) && cmp.name.length)
				{
					components[inWorkflow.id + cmp.name] = cmp;
				}
			}
			catch(exc)
			{
				exclog(exc);
				cmp = null;
			}
		}
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// initialize
	//
	function initialize()
	{
		var componentFolder = getComponentFolder();
		
		if (isValidProperty(componentFolder))
		{
			if (componentFolder.lastIndexOf('/') != componentFolder.length-1)
			{
				componentFolder += '/';
			}

			// retrieve component file names from folder
			//
			var cmpFiles = [];
		
			var res = cep.fs.readdir(componentFolder);
		
			if (isValidProperty(res) && res.err == cep.fs.NO_ERROR)
			{
				for( var f=0; f<res.data.length; f++)
				{
					if (res.data[f].lastIndexOf('.wcd') == res.data[f].length - 4)
					{
						cmpFiles.push(componentFolder + res.data[f]);
					}
				}
			}
		
			// create WorkflowTriggerComponent objects
			//
			for (var w=0; w<cmpFiles.length; w++)
			{
				var res = cep.fs.readFile(cmpFiles[w]);
			
				if (isValidProperty(res) && res.err == cep.fs.NO_ERROR)
				{
					var cmp = null;
	
					try
					{
						var obj = JSON.parse(res.data);
						cmp = new WorkflowTriggerComponent();
						cmp.initializeJSON(obj);
						
						if (isValidProperty(cmp.name) && cmp.name.length)
						{
							components[cmp.name] = cmp;
						}
					}
					catch(exc)
					{
						exclog(exc);
						cmp = null;
					}
				}
			}
		}
	}
	
	initialize();
}

WorkflowTriggerComponentManager.get = function()
{
	if (!isValidProperty(gWFTriggerComponentMgr))
	{
		gWFTriggerComponentMgr = new WorkflowTriggerComponentManager();
	}
	
	return gWFTriggerComponentMgr;
}