/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function MessageBroadcaster()
{
    var channels = {};

	function MessageHandler(/*[Function]*/ inHandlerFct, /*[Object]*/ inHandlerObject)
	{
		this.handlerFct = inHandlerFct;
		this.handlerObj = inHandlerObject;
	}

	this.registerHandler = function(/*[String]*/ inChannel, /*[Function]*/ inHandlerFct, /*[Object]*/ inHandlerObject)
    {
		var handlerObject = inHandlerObject;

		if (!isValidProperty(handlerObject))
		{
			handlerObject = null;
		}

		if (!isValidProperty(channels[inChannel]))
        {
            channels[inChannel] = [];
        }

        channels[inChannel].push(new MessageHandler(inHandlerFct, handlerObject));
    }

    this.unregisterHandler = function(/*[String]*/ inChannel, /*[Function]*/ inHandlerFct, /*[Object]*/ inHandlerObject)
    {
        if (isValidProperty(channels[inChannel]))
        {
			var handlerObject = inHandlerObject;

			if (!isValidProperty(handlerObject))
			{
				handlerObject = null;
			}

			for (var h=0; h<channels[inChannel].length; h++)
            {
                if (inHandlerFct == channels[inChannel][h].handlerFct &&
					handlerObject == channels[inChannel][h].handlerObj)
                {
                    channels[inChannel].splice(h, 1);
                    break;
                }
            }
        }
    }

    this.sendMessage = function(/*[String]*/ inChannel, /*[any ...]*/ inData)
    {
        if (isValidProperty(channels[inChannel]))
        {
            var args = arguments;

            forEach(channels[inChannel], function(handler)
            {
                handler.handlerFct.apply(handler.handlerObj, args);
            });
        }
    }

    this.postMessage = function(/*[String]*/ inChannel, /*[any ...]*/ inData)
    {
        if (isValidProperty(channels[inChannel]))
        {
            var args = arguments;

            forEach(channels[inChannel], function(handler)
            {
                var messageHandler = handler;

                setTimeout(function()
                {
					messageHandler.handlerFct.apply(messageHandler.handlerObj, args);
                }, 1);
            });
        }
    }
}
