/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function PanelSurface()
{
	var surfaces = {};
	var contentStorage = new LocalContentStorage(getSurfaceFolder());
	var current = '';
	var surfaceJob = null;
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Display named surface
	//
	this.displaySurface = function(/*[String]*/ inName)
	{
		if (isValidProperty(surfaceJob))
		{
			surfaceJob.cancel();
		}

		current = inName;
		surfaceJob = this.getSurface(inName);
		surfaceJob.wait(function(/*[String]*/ inSurfaceContent)
		{
			var body = document.getElementsByTagName("body");

			if (isValidProperty(body))
			{
				body = body[0];
				body.innerHTML = inSurfaceContent;
			}
		});
	}
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Is given surface name the current surface
	//
	this.isCurrent = function(/*[String]*/ inName)
	{
		return (inName = current);
	}
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Display inContent as the inner content of the element with inID
	//
	this.displayByID = function(/*[String]*/ inID, /*[String]*/ inContent)
	{
		var element = document.getElementById(inID);

		if (isValidProperty(element))
		{
			element.innerHTML = inContent;

			// evaluate any scripts embeded
			//
			var scripts = element.getElementsByTagName('script');

			for (var s=0; s<scripts.length; s++)
			{
				var src = scripts[s].innerHTML;

				if (isValidProperty(src))
				{
					try
					{
						globalEval(src);
					}
					catch(exc)
					{
						exclog(exc);
					}
				}
			}
		}
	}
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Get surface source
	//
	this.getSurface = function(/*[String]*/ inName)
	{
		var job = null;

		if (isValidProperty(surfaces[inName]))
		{
			job = new Job();
			job.setResult(surfaces[inName]);
		}
		else
		{
			var contentJob = getSurfaceContent(inName);
			job = new ProxyJob(contentJob, function(/*[String]*/ inSurfaceContent)
			{
				surfaces[inName] = inSurfaceContent;
				return inSurfaceContent;
			});
		}
		
		return job;
	}
	
	// private ///////////////////////////////////////////////////////////////////
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Read surface file and return surface content
	//
	function getSurfaceContent(/*[String]*/ inName)
	{
		var job = new Job();
		var ret = '';
		var filename = getSurfaceFolder() + inName + '.html';
		var result = cep.fs.readFile(filename);
		
		if (isValidProperty(result) && result.err == cep.fs.NO_ERROR)
		{
			var parser = new DOMParser();
			var doc = parser.parseFromString(result.data, "text/html");
			
			if (isValidProperty(doc))
			{
				var body = doc.getElementsByTagName("body");
		
				if (isValidProperty(body))
				{
					ret = body[0].innerHTML;
				}
			}
		}
		
		if (ret.length)
		{
			job = replaceAllSymbols(ret, contentStorage);
		}
		else
		{
			job.setError("PanelSurface.getSurfaceContent [" + inName + "]: no content");
		}

		return job;
	}
}
