/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function LocalCacheContentStorage(/*[String]*/ inBasePath)
{
	var basePath = inBasePath;
	var storage = new LocalContentStorage(inBasePath);

	// initialize
	(function()
	{
		if (isValidProperty(basePath))
		{
			if (basePath.lastIndexOf('/') != basePath.length-1)
			{
				basePath += '/';
			}
		}
	})();

	//////////////////////////////////////////////////////////////////////////////
	//
	// Return absolute file path of cached content file
	//
	this.getURL = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID)
	{
		return storage.getURL(inWorkflowID, inContentID);
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Return absolute url of content file
	//
	this.setURL = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID, /*[String]*/ inURL)
	{
// TODO: write to file
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Return content as it is (e.g. raw text is returned as raw text, html is returned as html, etc.)
	//
	this.getRaw = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID)
	{
		return storage.getRaw(inWorkflowID, inContentID);
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Return content as it is (e.g. raw text is returned as raw text, html is returned as html, etc.)
	//
	this.setRaw = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID, /*[String]*/ inRaw)
	{
// TODO: write to file
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Return content as localized string
	//
	this.getString = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID)
	{
		return storage.getString(inWorkflowID, inContentID);
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Set a stringtable
	//
	this.setStringtable = function(/*[String]*/ inWorkflowID, /*[Stringtable]*/ inStringtable)
	{
// TODO: write to file
		stringTables[inWorkflowID] = inStringtable;
	}
}
