/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function ProxyJob(/*[IJob]*/ inJob, /*[Function]*/ inResultFilter, /*[Function]*/ inErrorFilter)
{
	throwInvalid(inJob);
	
	var waiting = false;
	var job = inJob;
    var resultFilter = inResultFilter;
    var errorFilter = inErrorFilter;
	var successHandler = null;
	var errorHandler = null;

	//////////////////////////////////////////////////////////////////////////////
	//
	// Get Job result
	//
	this.getResult = function()
	{
		return job.getResult();
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Get Job error
	//
	this.getError = function()
	{
		return job.getError();
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Wait for Job completed
	//
	function onSuccess(/*[any]*/ inResult)
	{
		var result = inResult;
		
		if (isValidProperty(resultFilter))
		{
			result = resultFilter(inResult);
		}

		if (isValidProperty(successHandler))
		{
			successHandler(result);
		}
	}
	
	function onError(/*[any]*/ inError)
	{
		var error = inError;
		
		if (isValidProperty(errorFilter))
		{
			error = errorFilter(inError);
		}

		if (isValidProperty(errorHandler))
		{
			errorHandler(error);
		}
	}
	
	this.wait = function(/*[Function]*/ inSuccessFct, /*[Function]*/ inErrorFct)
	{
        if (!waiting && !this.isStatus(IJob.STATUS_CANCELED))
        {
            waiting = true;
            successHandler = inSuccessFct;
            errorHandler = inErrorFct;
            
            job.wait(onSuccess, onError);
        }
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Cancel Job
	//
	this.cancel = function()
	{
        if (this.isStatus(IJob.STATUS_PENDING))
        {
            successHandler = null;
            errorHandler = null;
        }

        job.cancel();
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Get Job status
	//
	this.getStatus = function()
	{
		return job.getStatus();
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Check Job status
	//
	this.isStatus = function(/*[Number]*/ inStatusFlags)
	{
		return job.isStatus(inStatusFlags);
	}
}
