/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function MemoryContentStorage()
{
    var memURL = {};
    var memRaw = {};
    var stringTables = {};

    //////////////////////////////////////////////////////////////////////////////
    //
    // Return absolute url of content file
    //
    this.getURL = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID)
    {
        var job = new Job();

        if (isValidProperty(memURL[inWorkflowID]) && isValidProperty(memURL[inWorkflowID][inContentID]))
        {
        	var url = memURL[inWorkflowID][inContentID];
            job.setResult(url);
			dbgLogContent("MemoryContentStorage.getURL", inWorkflowID, inContentID, url);
        }
        else
        {
            job.setError("MemoryContentStorage.getURL '" + inWorkflowID + "' / '" + inContentID + "' NOT exist");
			dbglogError(job.getError());
        }

        return job;
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Return absolute url of content file
    //
    this.setURL = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID, /*[String]*/ inURL)
    {
        if (!isValidProperty(memURL[inWorkflowID]))
        {
            memURL[inWorkflowID] = {};
        }

        memURL[inWorkflowID][inContentID] = inURL;
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Return content as it is (e.g. raw text is returned as raw text, html is returned as html, etc.)
    //
    this.getRaw = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID)
    {
        var job = new Job();

		if (isValidProperty(memRaw[inWorkflowID]) && isValidProperty(memRaw[inWorkflowID][inContentID]))
        {
        	var raw = memRaw[inWorkflowID][inContentID];
            job.setResult(raw);
			dbgLogContent("MemoryContentStorage.getRaw", inWorkflowID, inContentID, raw);
        }
        else
		{
			job.setError("MemoryContentStorage.getRaw '" + inWorkflowID + "' / '" + inContentID + "' NOT exist");
			dbglogError(job.getError());
		}

        return job;
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Return content as it is (e.g. raw text is returned as raw text, html is returned as html, etc.)
    //
    this.setRaw = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID, /*[String]*/ inRaw)
    {
        if (!isValidProperty(memRaw[inWorkflowID]))
        {
            memRaw[inWorkflowID] = {};
        }

        memRaw[inWorkflowID][inContentID] = inRaw;
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Return content from string table
    //
    this.getString = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID)
    {
        var job = new Job();
        var ret = null;

        if (isValidProperty(stringTables[inWorkflowID]))
        {
            ret = stringTables[inWorkflowID].getString(inContentID);
        }

        if (isValidProperty(ret))
        {
			job.setResult(ret);
			dbgLogContent("MemoryContentStorage.getString", inWorkflowID, inContentID, ret);
        }
        else
		{
			job.setError("MemoryContentStorage.getString '" + inWorkflowID + "' / '" + inContentID + "' NOT exist");
			dbglogError(job.getError());
		}

		return job;
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Set a stringtable
    //
    this.setStringtable = function(/*[String]*/ inWorkflowID, /*[Stringtable]*/ inStringtable)
    {
        stringTables[inWorkflowID] = inStringtable;
    }
}
