/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function Job(/*[Function]*/ inResultFilter, /*[Function]*/ inErrorFilter)
{
    var status = IJob.STATUS_PENDING;
    var waiting = false;
    var result = null;
    var error = null;
    var successHandler = null;
    var errorHandler = null;
    var resultFilter = inResultFilter;
    var errorFilter = inErrorFilter;

    //////////////////////////////////////////////////////////////////////////////
    //
    // Set Job result
    //
    this.setResult = function(/*[any]*/ inResult)
    {
        if (!this.isStatus(IJob.STATUS_FINISHED))
        {
            status = IJob.STATUS_FINISHED | IJob.STATUS_SUCCESS;
            result = (isValidProperty(resultFilter) ? resultFilter(inResult) : inResult);
            error = null;

            if (isValidProperty(successHandler))
            {
                successHandler(this.getResult());
            }

            return true;
        }

        return false;
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Get Job result
    //
    this.getResult = function()
    {
        if (this.isStatus(IJob.STATUS_FINISHED | IJob.STATUS_SUCCESS) && 
        	!this.isStatus(IJob.STATUS_CANCELED))
        {
            return result;
        }

        return null;
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Set Job error
    //
    this.setError = function(/*[any]*/ inError)
    {
        if (!this.isStatus(IJob.STATUS_FINISHED))
        {
            status = IJob.STATUS_FINISHED | IJob.STATUS_ERROR;
            error = (isValidProperty(errorFilter) ? errorFilter(inError) : inError);
            result = null;

            if (isValidProperty(errorHandler))
            {
                errorHandler(this.getError());
            }

            return true;
        }

        return false;
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Get Job error
    //
    this.getError = function()
    {
        if (this.isStatus(IJob.STATUS_FINISHED | IJob.STATUS_ERROR) && 
        	!this.isStatus(IJob.STATUS_CANCELED))
        {
            return error;
        }

        return null;
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Wait for Job completed
    //
    this.wait = function(/*[Function]*/ inSuccessFct, /*[Function]*/ inErrorFct)
    {
        if (!waiting && !this.isStatus(IJob.STATUS_CANCELED))
        {
            waiting = true;
            successHandler = inSuccessFct;
            errorHandler = inErrorFct;

            if (this.isStatus(IJob.STATUS_FINISHED | IJob.STATUS_SUCCESS) &&
            	isValidProperty(successHandler))
            {
                successHandler(this.getResult());
            }
            
            if (this.isStatus(IJob.STATUS_FINISHED | IJob.STATUS_ERROR) &&
            	isValidProperty(errorHandler))
            {
                errorHandler(this.getError());
            }
        }
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Cancel Job
    //
    this.cancel = function()
    {
        if (this.isStatus(IJob.STATUS_PENDING))
        {
            status = IJob.STATUS_CANCELED | IJob.STATUS_FINISHED;
            result = null;
            error = null;
            successHandler = null;
            errorHandler = null;
        }
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Get Job status
    //
    this.getStatus = function()
    {
        return status;
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Check Job status
    //
    this.isStatus = function(/*[Number]*/ inStatusFlags)
    {
        return ((status & inStatusFlags) == inStatusFlags);
    }
}
