/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function ScriptJob(/*[String]*/ inScript, /*[Function]*/ inResultFilter, /*[Function]*/ inErrorFilter)
{
    throwInvalid(inScript);

    var job = new Job(inResultFilter, inErrorFilter);

    //////////////////////////////////////////////////////////////////////////////
    //
    // Get Job result
    //
    this.getResult = function()
    {
        return job.getResult();
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Get Job error
    //
    this.getError = function()
    {
        return job.getError();
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Wait for Job completed
    //
    this.wait = function(/*[Function]*/ inSuccessFct, /*[Function]*/ inErrorFct)
    {
        job.wait(inSuccessFct, inErrorFct);
    }

	//////////////////////////////////////////////////////////////////////////////
    //
    // Cancel Job
    //
    this.cancel = function()
    {
        job.cancel();
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Get Job status
    //
    this.getStatus = function()
    {
        return job.getStatus();
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Check Job status
    //
    this.isStatus = function(/*[Number]*/ inStatusFlags)
    {
        return job.isStatus(inStatusFlags);
    }

    // initialization /////////////////////////////////////////////////////////
    
    function onScriptResult(/*[String]*/ inResult)
    {
		// Expected result string
		// a) "EvalScript error."
		// b) "{
		//			error : true/false,
		//			data : 'Result or error string'
		//     }"

		var _script = inScript;
		var result = null;
		var error = !isValidProperty(inResult);

		if (!error)
		{
			error = (inResult.indexOf(EvalScript_ErrMessage) == 0);
		}

		if (!error)
		{
			error = (inResult.length == 0);
		}

		var resultObj = null;

		if (!error)
		{
			try
			{
				resultObj = JSON.parse(inResult);

				if (isValidProperty(resultObj) && isValidProperty(resultObj.error))
				{
					error = resultObj.error;
				}
			}
			catch(e)
			{
				exclog(e);
				error = true;
				result = e.toString();
			}
		}

		if (!isValidProperty(result))
		{
			if (isValidProperty(resultObj) && isValidProperty(resultObj.data))
			{
				result = resultObj.data;
			}
			else
			{
				result = '';
			}
		}

		if (!error)
		{
			job.setResult(result);
		}
		else
		{
			job.setError(result);
		}
    }

	try
	{    
		var cs = new CSInterface();
		cs.evalScript(inScript, onScriptResult);
	}
	catch(exc)
	{
		job.setError(exc.toString());
	}
}
