:start
    set call=%~1
    shift
    goto %call%
    exit /b

:: Countdowns with custom message
:: call utils.bat "countdown" "Automatically exiting in" "5"
:countdown
    set "countdownmessage=%~1"
    set /a "countdown=%~2"
    call :stringchars "%countdownmessage%%countdown%"
    for /L %%a IN (1,1,%chars%) do call :countdownaddblank
:countdownloop
    if "%countdown%" equ "0" (
        powershell %string:~1%;Write-Host "`r%blank%`b`b Done! $null" -NoNewline -b DarkGreen -f White;Write-Host ""
        exit /b
    )
    set string=%string%;Write-Host "`r%countdownmessage% `0" -NoNewline -b White -f Black;Write-Host "$null %countdown%s $null" -NoNewline -b DarkRed -f White;sleep 1
    set /a countdown=%countdown%-1
    goto :countdownloop
:countdownaddblank
    set blank=%blank%-
    exit /b

:: Styled Echo Call

:stylecho
    call :macros
    set "text=%~1"
    set "colors=%~2"
    %<%:%colors% " %text% "%>>%
    exit /b

:stylechotest
    @echo off
    cls
    call :stylecho "00" "00"
    call :stylecho "01" "01"
    call :stylecho "02" "02"
    call :stylecho "03" "03"
    call :stylecho "04" "04"
    call :stylecho "05" "05"
    call :stylecho "06" "06"
    call :stylecho "07" "07"
    call :stylecho "08" "08"
    call :stylecho "09" "09"
    call :stylecho "0a" "0a"
    call :stylecho "0b" "0b"
    call :stylecho "0c" "0c"
    call :stylecho "0d" "0d"
    call :stylecho "0e" "0e"
    call :stylecho "0f" "0f"
    echo.
    call :stylecho "00" "00"
    call :stylecho "10" "10"
    call :stylecho "20" "20"
    call :stylecho "30" "30"
    call :stylecho "40" "40"
    call :stylecho "50" "50"
    call :stylecho "60" "60"
    call :stylecho "70" "70"
    call :stylecho "80" "80"
    call :stylecho "90" "90"
    call :stylecho "a0" "a0"
    call :stylecho "b0" "b0"
    call :stylecho "c0" "c0"
    call :stylecho "d0" "d0"
    call :stylecho "e0" "e0"
    call :stylecho "f0" "f0"
    exit /b

:: Logs using style B)
:log
    (call :logstart %1 %2 %3 %4)
    (call :logstart %1 %2 %3 %4)>> %logfile%
    exit /b
:logns
    @echo off
    echo %~1
    @echo %verbose%
    exit /b
:logstart
    @echo off
    if ["%~3"] equ [""] (set msg=%~2) else (set msg= %~3 )
    call :stringchars "%msg%"
    set /a dashloops=%~1-(chars/2)
    if not "%dashloops:-=%" equ "%dashloops%" (
            set dashloops=%dashloops:-=%
            echo "The below log call is too long! The dashloop result is negative. We circumvented it, please increase the radius"
            echo "%msg%"
            exit /b
        )
    set dashsymbol=%~2
    set dashloop=0
    set dashes=
    call :dashloop
    set finalmsg=%dashes%%msg%%dashes%
    set dash=
    for /f "delims=" %%a in ('cmd /Q /U /C echo %finalmsg%^| find /V ""') do call :adddash
    (
        echo %finalmsg%
        if not "%~4" equ "" (
            for %%a in ("%~4") do echo %%a
            echo %dash%
        )
    )
    @echo %verbose%
    exit /b

:: Adds dashes to %dashes% for :log
:dashloop
    if not %dashloop% equ %dashloops% (set dashes=%dashes%%dashsymbol%) && set /a dashloop=dashloop+1 && goto :dashloop
    exit /b

:: Adds dashes to %dash% for :log
:adddash
    set dash=%dash%%dashsymbol%
    exit /b

:popup
    :: call :popup "Title" "Message" "Type" "Icon"
    :: More info at https://learn.microsoft.com/en-us/dotnet/api/system.windows.forms.messagebox.show?view=windowsdesktop-8.0#system-windows-forms-messagebox-show(system-string-system-string-system-windows-forms-messageboxbuttons-system-windows-forms-messageboxicon)

    :: Button Types: AbortRetryIgnore, CancelTryContinue, OK, OKCancel, RetryCancel, YesNo, YesNoCancel
    :: Icon Types: Asterisk, Error, Exclamation, Hand, Information, None, Question, Stop, Warning
    :: Return Type: Abort, Cancel, Continue, Ignore, No, None, OK, Retry, TryAgain, Yes

    set title=%~1
    set message=%~2
    set type=%~3
    set icon=%~4

    if "%title%" equ "" set title="Title"
    if "%message%" equ "" set message="Message"
    if "%type%" equ "" set type=0
    if "%icon%" equ "" set icon=64

    for /f "usebackq" %%a in (`powershell -Command "Add-Type -AssemblyName System.Windows.Forms; [System.Windows.Forms.MessageBox]::Show( '%message%', '%title%', '%type%', '%icon%' )"`) do set answer=%%a
    exit /b

:: Calc how many chars in a string
:stringchars
    set /a chars=0
    for /f "delims=" %%a in ('cmd /Q /U /C echo %~1^| find /V ""') do set /a chars=chars+1
    exit /b

::# lean xp+ color macros by AveYo:  %<%:af " hello "%>>%  &&  %<%:cf " w\"or\"ld "%>%   for single \ / " use .%|%\  .%|%/  \"%|%\"
:macros
    for /f "delims=:" %%s in ('echo;prompt $h$s$h:^|cmd /d') do set "|=%%s"&set ">>=\..\c nul&set /p s=%%s%%s%%s%%s%%s%%s%%s<nul&popd"
    set "<=pushd "%appdata%"&2>nul findstr /c:\ /a" &set ">=%>>%&echo;" &set "|=%|:~0,1%" &set /p s=\<nul>"%appdata%\c"
    exit /b

::# elevate with native shell by AveYo
:elevate
    >nul reg add hkcu\software\classes\.Admin\shell\runas\command /f /ve /d "cmd /x /d /r set \"f0=%%2\"& call \"%%2\" %%3"& set _= %*
    >nul fltmc|| if "%f0%" neq "%~f0" (cd.>"%temp%\runas.Admin" && start "%~n0" /high "%temp%\runas.Admin" "%~f0" "%_:"=""%" && exit /b)

::# Steam location setup
:steampath
    for /f "tokens=2*" %%R in ('reg query HKCU\SOFTWARE\Valve\Steam /v SteamPath 2^>nul') do for %%A in ("%%~S") do set "STEAM=%%~fA"
    exit /b