Set-Location -Path "C:\Program Files\obs-studio\bin\64bit\"

# Check if OBS is already running
$obsProcesses = Get-Process -Name "obs64" -ErrorAction SilentlyContinue
if ($obsProcesses) {
    $runningObs = $obsProcesses | Where-Object { $_.CPU -gt 0 }
    if ($runningObs) {
        Write-Output "OBS Studio is already running."
        exit
    }
    else {
        Write-Output "OBS Studio is already running and suspended, ignoring this exit."
    }
}

# Check if the OBS updater is running
if (Get-Process -Name "updater" -ErrorAction SilentlyContinue) {
    Write-Output "OBS Studio is currently updating."
    exit
}

# Start OBS Studio
Write-Output "Starting OBS Studio..."
Start-Process "obs64.exe" -ArgumentList "--startreplaybuffer", "--minimize-to-tray", "--disable-shutdown-check"