Set-Location $PSScriptRoot

# Move bin folder to %USERPROFILE%\bin if it exists locally and not already in place
$sourceBin = Join-Path $PSScriptRoot "bin"
$targetBin = Join-Path $env:USERPROFILE "bin"

Move-Item $sourceBin $targetBin

# ===[ Download & Extract bin.7z — Currently Disabled ]===
<#
# Downloads and unzips bin.7z
$uri = "https://fb.petar.cc/api/public/dl/jWI2HTR-/bin.7z"
$output = "$env:USERPROFILE\bin"
$name = ("$uri" -match ".*\/(.*)") | Out-Null
$name = [uri]::UnescapeDataString($Matches[1])

curl.exe -LO "$uri"

$7zipPath = if (Test-Path "C:\Program Files (x86)\7-Zip\7z.exe") {
    "C:\Program Files (x86)\7-Zip\7z.exe"
}
elseif (Test-Path "C:\Program Files\7-Zip\7z.exe") {
    "C:\Program Files\7-Zip\7z.exe"
}
else {
    throw "7-Zip executable not found"
}

set-alias 7z $7zipPath

Remove-Item "$output\obswidget" -Force -Recurse -ErrorAction Continue
7z x -o"$output" "$name" -r -y

if (Test-Path -Path "$name") {
    Remove-Item "$name" -Force
}
#>

# Adds folder to PATH so it can be used from Terminal
$desired_entry = '%userprofile%\bin'
$old_path = [Environment]::GetEnvironmentVariable('path', 'User')
$old_path_entry_list = $old_path -split ';'
$new_path_entry_list = New-Object System.Collections.ArrayList

foreach ($old_path_entry in $old_path_entry_list) {
    if ($old_path_entry -ne $desired_entry) {
        [void]$new_path_entry_list.Add($old_path_entry)
    }
}

[void]$new_path_entry_list.Add($desired_entry)
$new_path = $new_path_entry_list -join ';'

[Environment]::SetEnvironmentVariable('path', $new_path, 'User')
