param (
    [Alias("u")]
    [Parameter(Mandatory)]
    [String[]] $uri
)
download -a -u "$uri" -o "$env:appdata\Playnite\ExtensionsData\a237961d-d688-4be9-9576-fb635547f854\GreenLuma" -d "$env:appdata\Playnite\ExtensionsData\a237961d-d688-4be9-9576-fb635547f854\GreenLuma"
Set-Location "$env:appdata\Playnite\ExtensionsData\a237961d-d688-4be9-9576-fb635547f854\GreenLuma"
$file = (Get-Content GreenLuma*.txt)[1]
$version = $file -replace "^.* ([^\s]+) .*$", '$1'
$year = $file -replace "^.* (\d+) .*$", '$1'
$jsonData = @{
    Version = $version
    Year    = $year
}
$jsonString = ConvertTo-Json $jsonData -Compress
Set-Content -Path "Version.json" -Value $jsonString -Encoding UTF8

"NormalMode", "StealthMode" | ForEach-Object {
    Get-ChildItem -Path ".\$_\" -Recurse -File | Move-Item -Destination ".\"
    Remove-Item -Path ".\$_" -Recurse -Force
}