param (
    [Alias("u")]
    [Parameter(Mandatory)]
    [String[]] $uri,
    [Alias("o")]
    [Parameter(Mandatory)]
    [String[]] $output,
    [Alias("d", "del")]
    [Parameter()]
    [String[]] $deletions,
    [Alias("a")]
    [Parameter()]
    [Switch] $archive
)
Set-Location "$env:userprofile\Desktop"
$name = ("$uri" -match ".*\/(.*)")
$name = $Matches[1]
#$name = [uri]::UnescapeDataString($Matches[1])
if ($PSBoundParameters.ContainsKey('deletions')) {
    foreach ($item in $deletions) {
        if (Test-Path -Path "$item") {
            Remove-Item "$item" -Recurse -Force
        }
    }
}
curl.exe -LO "$uri"
if ($archive) {
    set-alias 7z "$env:ProgramFiles\7-Zip\7z.exe"
    7z x -o"$output" "$name" -r -y
    if (Test-Path -Path "$name") {
        Remove-Item "$name" -Force
    }
}