@echo off
set verbose=off
set logfile=AutoInstaller.log
@echo %verbose%
setlocal EnableExtensions DisableDelayedExpansion
cd %~dp0
:: echo.> %logfile%
echo.>> %logfile%

:: Intro Echo
set "run=%~0 %*"
if "%run:~-1,1%" equ " " set "run=%run:~0,-1%"
call :log "50" "X" "Script started with %run:"=%"
call :log "50" "!" "Remember to run Installer.ps1 before continuing" "Go into the bin_installer folder"
pause

:: Kill OBS
:killobs
    taskkill /F /IM obs64.exe /T >nul 2>nul
    call :log "50" "-" "Killed OBS if it was running"
    if exist files\ (
        cd files
        call :copyfiles
        call :copyprofiles
        call :obsstartup
    ) else (
        call :log "50" "!" "files folder does not exist. Skipping all steps."
    )
    if exist installers\ (
        call :installers
    ) else (
        call :log "50" "!" "installers folder does not exist. Skipping all installs."
    )
    call :log "50" "!" "Finished and Starting OBS Press CTRL-C to quit"
    set /a countdown=9
    call :countdown
    cd /D "C:\Program Files\obs-studio\bin\64bit\"
    start "" "obs64.exe" --startreplaybuffer --minimize-to-tray --disable-shutdown-check
    exit

:: OBS Files
:copyfiles
    if exist data\ (
        xcopy /E /Y "data" "C:\Program Files\obs-studio\data\" >nul
    ) else (
        call :log "50" "!" "data folder missing in files"
    )
    call :log "50" "-" "Copied OBS Files"
    exit /b

:: OBS Profiles/Scenes
:copyprofiles
    if exist Petar\ (
        xcopy /E /Y "Petar" "%appdata%\obs-studio\basic\profiles\Petar\" >nul
    ) else (
        call :log "50" "!" "Petar folder missing in files"
    )
    if exist plugin_config\ (
        xcopy /E /Y "plugin_config" "%appdata%\obs-studio\plugin_config\" >nul
    ) else (
        call :log "50" "!" "plugin_config folder missing in files"
    )
    if exist Petar.json (
        xcopy /Y "Petar.json" "%appdata%\obs-studio\basic\scenes\Petar.json*" >nul
    ) else (
        call :log "50" "!" "Petar.json missing in files"
    )
    if exist global.ini (
        xcopy /Y "global.ini" "%appdata%\obs-studio\global.ini*" >nul
    ) else (
        call :log "50" "!" "global.ini missing in files"
    )
    call :log "50" "-" "Copied OBS Profiles and Scenes"
    exit /b

:: OBS Startup Task
:obsstartup
    if exist StartOBS.xml (
        for /F "tokens=*" %%f in ('whoami') do (set user=%%f)
        schtasks /create /xml "StartOBS.xml" /tn "\StartOBS" /ru "%user%"
        call :log "50" "-" "Imported OBS Startup Task, If this failed, try doing it manually"
    ) else (
        call :log "50" "!" "StartOBS.xml missing in files"
    )
    exit /b

:: Run Installers
:installers
    call :log "50" "-" "Starting Installers"
    cd /D ../installers
    for /f %%f in ('dir /b') do %%f /silent /verysilent -silent -verysilent
    exit /b

:countdown
    if "%countdown%" equ "0" (
        powershell %string:~1%
        exit /b
    )
    set string=%string%;Write-Host "`rAutomatically exiting in `0" -NoNewline -b White -f Black;Write-Host "%countdown%s" -nonewline -b DarkRed -f White;sleep 1
    set /a countdown=%countdown%-1
    call :countdown

:: Logs using style B)
:log
    (call :logstart %1 %2 %3 %4)
    (call :logstart %1 %2 %3 %4)>> %logfile%
    exit /b
:logns
    @echo off
    echo %~1
    @echo %verbose%
    exit /b
:logstart
    @echo off
    if ["%~3"] equ [""] (set msg=%~2) else (set msg= %~3 )
    set chars=0
    call :stringchars "%msg%"
    set /a dashloops=%~1-(chars/2)
    if not "%dashloops:-=%" equ "%dashloops%" (
            set dashloops=%dashloops:-=%
            echo "The below log call is too long! The dashloop result is negative. We circumvented it, please increase the radius"
            echo "%msg%"
            exit /b
        )
    set dashsymbol=%~2
    set dashloop=0
    set dashes=
    call :dashloop
    set finalmsg=%dashes%%msg%%dashes%
    set dash=
    for /f "delims=" %%a in ('cmd /Q /U /C echo %finalmsg%^| find /V ""') do call :adddash
    (
        echo %finalmsg%
        if not "%~4" equ "" (
            for %%a in ("%~4") do echo %%a
            echo %dash%
        )
    )
    @echo %verbose%
    exit /b

:: Adds dashes to %dashes% for :log
:dashloop
    if not %dashloop% equ %dashloops% (set dashes=%dashes%%dashsymbol%) && set /a dashloop=dashloop+1 && goto :dashloop
    exit /b

:: Adds dashes to %dash% for :log
:adddash
    set dash=%dash%%dashsymbol%
    exit /b

:: Calc how many chars in a string
:stringchars
    for /f "delims=" %%a in ('cmd /Q /U /C echo %~1^| find /V ""') do set /a chars=chars+1
    exit /b
