$DeviceNameWireless = "Wireless Controller"
$DeviceNameUSB = "Wireless Controller"

$WirelessLastConnection = (Get-PnpDevice | Where-Object { $_.InstanceId -match '^BTHENUM' -and $_.Name -match "$DeviceNameWireless" } | Get-PnpDeviceProperty -KeyName 'DEVPKEY_Bluetooth_LastConnectedTime')
# sometimes we might have multiple connections here so lets go thru each one and check connection, just in case
foreach ($result in $WirelessLastConnection) {
  $WirelessConnected = $null -eq $result.Data
}

$UsbDevice = Get-PnpDevice -PresentOnly | Where-Object { $_.InstanceId -match '^USB' -and $_.Name -match "$DeviceNameUSB" }

$UsbConnected = $null -ne $UsbDevice
$Connected = $WirelessConnected -or $UsbConnected
$Connected | Out-File -FilePath $PSScriptRoot\checkcontroller.txt

Write-Host "-------------------------------------------------------------------"
Write-Host "Wireless Connected: $WirelessConnected"
Write-Host "Usb Connected: $UsbConnected"
Write-Host "-------------------------------------------------------------------"

# old check
<#
$WirelessDevice = $(Get-PnpDevice | Where-Object Name -Like "$DeviceNameWireless")[0]
$WirelessInstanceID = $WirelessDevice.InstanceID
$WirelessDeviceProperties = Get-PnpDeviceProperty -InstanceId "$WirelessInstanceID"
$WirelessIsPresent = $WirelessDeviceProperties | Where-Object { $_.KeyName -eq 'DEVPKEY_Device_IsPresent' } | Select-Object -ExpandProperty Data
$WirelessLastConnection = $WirelessDeviceProperties | Where-Object { $_.KeyName -eq 'DEVPKEY_Bluetooth_LastConnectedTime' } | Select-Object -ExpandProperty Data
#>