param(
    [Alias("t")]
    [String] $UserInput
)

Clear-Host

#Locate R6 with steam
$GameLoc = $(steamlocator -id "359550")

# Prompt user for input
if ($null -eq $UserInput) {
    $UserInput = Read-Host -Prompt "Enter time duration (e.g., 10h2m3s or 10h 2m 3s)"
}

# If input is empty, exit
if ([string]::IsNullOrEmpty($UserInput)) {
    $UserInput = "5m"
}

# Extract and calculate total seconds
$TotalSeconds = 0
([regex]::Matches($UserInput, '\d+[dD]|\d+[hH]|\d+[mM]|\d+[sS]') | ForEach-Object {
    $value = [int]($_.Value -replace '[^\d]')       # Extract numerical value
    $unit = "$($_.Value[-1])".ToLower()             # Extract unit and convert to lowercase
    switch ($unit) {
        "d" { $TotalSeconds += $value * 86400 }     # Convert days to seconds
        "h" { $TotalSeconds += $value * 3600 }      # Convert hours to seconds
        "m" { $TotalSeconds += $value * 60 }        # Convert minutes to seconds
        "s" { $TotalSeconds += $value }             # Seconds remain as they are
    }
})

function FormatSeconds {
    param($Seconds)
    Return '{0:dd\d\:hh\h\:mm\m\:ss\s}' -f ([timespan]::fromseconds($Seconds)) -replace ':?00[dhms]:?' -replace '0(\d)', '$1'
}

while ($True) {
    Copy-Item "$GameLoc\MatchReplay\*" "$env:userprofile\Videos\OBS\Replay\RainbowSix\MatchReplays\" -Recurse -Force
    for ($i = 1; $i -le $TotalSeconds; $i++ ) {
        if ([Console]::KeyAvailable) {
            $key = [Console]::ReadKey($true).Key
            if ($key -in 'S', 'E') {
                break
            }
        }
        Write-Progress -Activity "Waiting $(FormatSeconds($TotalSeconds)) | Press S to SAVE | Press E to EXIT" -Status "Elapsed: $(FormatSeconds($i)) | Remaining: $(FormatSeconds($TotalSeconds - $i))" -PercentComplete $(($i / $TotalSeconds) * 100)
        Start-Sleep -Seconds 1
    }
    switch ($key) {
        S {
            $Seconds = 5
            while ($Seconds -ne 0) {
                if ([Console]::KeyAvailable) {
                    $key = [Console]::ReadKey($true).Key
                    if ($key -in 'E') {
                        Exit
                    }
                }
                Write-Progress -Activity "Saved!" -Status "Press E to EXIT" -SecondsRemaining $Seconds
                Start-Sleep -Seconds 1
                $Seconds -= 1
            }
        }
        E {
            'Exiting'
            Exit
        }
    }
}