#!/usr/bin/env bash
cd "$(dirname "$(realpath "$0")")"

DEST_DIR="dist/linux_src"

# Colors for output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

set +eu
# Check if notify-send exists globally
command -v notify-send &> /dev/null
NOTIFY_SEND_AVAILABLE=$?
set -eu

# Logging functions
log_info() {
    echo -e "${GREEN}[INFO]${NC} $1"
    set +eu
    if [ "$NOTIFY_SEND_AVAILABLE" -eq 0 ]; then
        notify-send -t 5000 "INFO" "$1" 2>/dev/null
    fi
    set -eu
}

log_warn() {
    echo -e "${YELLOW}[WARN]${NC} $1"
    set +eu
    if [ "$NOTIFY_SEND_AVAILABLE" -eq 0 ]; then
        notify-send -t 5000 -u normal "WARNING" "$1" 2>/dev/null
    fi
    set -eu
}

log_error() {
    echo -e "${RED}[ERROR]${NC} $1"
    set +eu
    if [ "$NOTIFY_SEND_AVAILABLE" -eq 0 ]; then
        notify-send -t 5000 -u critical "ERROR" "$1" 2>/dev/null
    fi
    set -eu
}

log_info "Packaging source distribution..."

# Remove destination directory if it exists
if [ -d "$DEST_DIR" ]; then
    log_warn "Removing existing destination directory: $DEST_DIR"
    rm -rf "$DEST_DIR"
fi

mkdir -p "$DEST_DIR/bin/src"

log_info "Copying source files"
cp -rp src/* "$DEST_DIR/bin/src"
rm -f $DEST_DIR/bin/src/deps/SLScheevo/SLScheevo.exe \
      $DEST_DIR/bin/src/deps/SLScheevo/SLScheevo
rm -rf $DEST_DIR/bin/src/tools

cp -fp run.sh "$DEST_DIR/bin/run.sh"
cp -fp requirements.txt "$DEST_DIR/bin/"
cp -fp ACCELAINSTALL "$DEST_DIR/ACCELAINSTALL"
cp -fp ACCELAUNINSTALL "$DEST_DIR/ACCELAUNINSTALL"
cp -fp src/res/logo/accela.png "$DEST_DIR/bin/"

log_info "Source packaging complete! Files are in $DEST_DIR"
