import sys
from typing import Any, Optional, Union

from pygame.rect import Rect
from pygame.surface import Surface
from pygame.typing import ColorLike, Point, RectLike
from typing_extensions import deprecated  # added in 3.13

def from_surface(surface: Surface, threshold: int = 127) -> Mask: ...
def from_threshold(
    surface: Surface,
    color: ColorLike,
    threshold: ColorLike = (0, 0, 0, 255),
    othersurface: Optional[Surface] = None,
    palette_colors: int = 1,
) -> Mask: ...

class Mask:
    def __init__(self, size: Point, fill: bool = False) -> None: ...
    def __copy__(self) -> Mask: ...
    def copy(self) -> Mask: ...
    def get_size(self) -> tuple[int, int]: ...
    def get_rect(self, **kwargs: Any) -> Rect: ...  # Dict type needs to be completed
    def get_at(self, pos: Point) -> int: ...
    def set_at(self, pos: Point, value: int = 1) -> None: ...
    def overlap(self, other: Mask, offset: Point) -> Optional[tuple[int, int]]: ...
    def overlap_area(self, other: Mask, offset: Point) -> int: ...
    def overlap_mask(self, other: Mask, offset: Point) -> Mask: ...
    def fill(self) -> None: ...
    def clear(self) -> None: ...
    def invert(self) -> None: ...
    def scale(self, scale: Point) -> Mask: ...
    def draw(self, other: Mask, offset: Point) -> None: ...
    def erase(self, other: Mask, offset: Point) -> None: ...
    def count(self) -> int: ...
    def centroid(self) -> tuple[int, int]: ...
    def angle(self) -> float: ...
    def outline(self, every: int = 1) -> list[tuple[int, int]]: ...
    def convolve(
        self,
        other: Mask,
        output: Optional[Mask] = None,
        offset: Point = (0, 0),
    ) -> Mask: ...
    def connected_component(self, pos: Point = ...) -> Mask: ...
    def connected_components(self, minimum: int = 0) -> list[Mask]: ...
    def get_bounding_rects(self) -> list[Rect]: ...
    def to_surface(
        self,
        surface: Optional[Surface] = None,
        setsurface: Optional[Surface] = None,
        unsetsurface: Optional[Surface] = None,
        setcolor: Optional[ColorLike] = (255, 255, 255, 255),
        unsetcolor: Optional[ColorLike] = (0, 0, 0, 255),
        dest: Union[RectLike, Point] = (0, 0),
        area: Optional[RectLike] = None,
    ) -> Surface: ...
    if sys.version_info >= (3, 12):
        def __buffer__(self, flags: int, /) -> memoryview[int]: ...
        def __release_buffer__(self, view: memoryview[int], /) -> None: ...

@deprecated("Use `Mask` instead (MaskType is an old alias)")
class MaskType(Mask): ...
