from collections.abc import Callable, Hashable, Iterable
from typing import Literal, Optional, Union

from pygame.surface import Surface
from pygame.typing import ColorLike, FileLike
from typing_extensions import deprecated  # added in 3.13

# TODO: Figure out a way to type this attribute such that mypy knows it's not
# always defined at runtime
UCS4: Literal[1]

def init() -> None: ...
def quit() -> None: ...
def get_init() -> bool: ...
def get_sdl_ttf_version(linked: bool = True) -> tuple[int, int, int]: ...
def get_default_font() -> str: ...
def get_fonts() -> list[str]: ...
def match_font(
    name: Union[str, bytes, Iterable[Union[str, bytes]]],
    bold: Hashable = False,
    italic: Hashable = False,
) -> str: ...
def SysFont(
    name: Union[str, bytes, Iterable[Union[str, bytes]], None],
    size: int,
    bold: Hashable = False,
    italic: Hashable = False,
    constructor: Optional[Callable[[Optional[str], int, bool, bool], Font]] = None,
) -> Font: ...

class Font:
    @property
    def name(self) -> str: ...
    @property
    def style_name(self) -> str: ...
    @property
    def bold(self) -> bool: ...
    @bold.setter
    def bold(self, value: bool) -> None: ...
    @property
    def italic(self) -> bool: ...
    @italic.setter
    def italic(self, value: bool) -> None: ...
    @property
    def underline(self) -> bool: ...
    @underline.setter
    def underline(self, value: bool) -> None: ...
    @property
    def strikethrough(self) -> bool: ...
    @strikethrough.setter
    def strikethrough(self, value: bool) -> None: ...
    @property
    def align(self) -> int: ...
    @align.setter
    def align(self, value: int) -> None: ...
    @property
    def point_size(self) -> int: ...
    @point_size.setter
    def point_size(self, value: int) -> None: ...
    def __init__(self, filename: Optional[FileLike] = None, size: int = 20) -> None: ...
    def render(
        self,
        text: Union[str, bytes, None],
        antialias: bool,
        color: ColorLike,
        bgcolor: Optional[ColorLike] = None,
        wraplength: int = 0,
    ) -> Surface: ...
    def size(self, text: Union[str, bytes], /) -> tuple[int, int]: ...
    def set_underline(self, value: bool, /) -> None: ...
    def get_underline(self) -> bool: ...
    def set_strikethrough(self, value: bool, /) -> None: ...
    def get_strikethrough(self) -> bool: ...
    def set_bold(self, value: bool, /) -> None: ...
    def get_bold(self) -> bool: ...
    def set_italic(self, value: bool, /) -> None: ...
    def metrics(
        self, text: Union[str, bytes], /
    ) -> list[tuple[int, int, int, int, int]]: ...
    def get_italic(self) -> bool: ...
    def get_linesize(self) -> int: ...
    def set_linesize(self, linesize: int, /) -> None: ...
    def get_height(self) -> int: ...
    def get_ascent(self) -> int: ...
    def get_descent(self) -> int: ...
    def set_script(self, script_code: str, /) -> None: ...
    def set_direction(self, direction: int) -> None: ...
    def get_point_size(self) -> int: ...
    def set_point_size(self, val: int, /) -> None: ...

@deprecated("Use `Font` instead (FontType is an old alias)")
class FontType(Font): ...
