from typing import Any, ClassVar, Optional, Union, final

from pygame.typing import SequenceLike
from typing_extensions import deprecated  # added in 3.13

class _GenericEvent:
    # Just exists to avoid duplication of data for Event
    # and (deprecated) EventType

    @property
    def type(self) -> int: ...
    __dict__: dict[str, Any]
    __hash__: ClassVar[None]  # type: ignore[assignment]
    def __init__(
        self, type: int, dict: dict[str, Any] = ..., **kwargs: Any
    ) -> None: ...
    def __getattr__(self, name: str) -> Any: ...
    def __setattr__(self, name: str, value: Any) -> None: ...
    def __delattr__(self, name: str) -> None: ...
    def __bool__(self) -> bool: ...

    # this is at the bottom because mypy complains if this declaration comes
    # before any uses of the dict[] typehinting because of the same naming
    @property
    def dict(self) -> dict[str, Any]: ...

@final
class Event(_GenericEvent):
    pass

@final
@deprecated("Use `Event` instead (EventType is an old alias)")
class EventType(_GenericEvent):
    pass

_EventTypes = Union[int, SequenceLike[int]]

def pump() -> None: ...
def get(
    eventtype: Optional[_EventTypes] = None,
    pump: bool = True,
    exclude: Optional[_EventTypes] = None,
) -> list[Event]: ...
def poll() -> Event: ...
def wait(timeout: int = 0) -> Event: ...
def peek(eventtype: Optional[_EventTypes] = None, pump: bool = True) -> bool: ...
def clear(eventtype: Optional[_EventTypes] = None, pump: bool = True) -> None: ...
def event_name(type: int, /) -> str: ...
def set_blocked(type: Optional[_EventTypes], /) -> None: ...
def set_allowed(type: Optional[_EventTypes], /) -> None: ...
def get_blocked(type: _EventTypes, /) -> bool: ...
def set_grab(grab: bool, /) -> None: ...
def get_grab() -> bool: ...
def post(event: Event, /) -> bool: ...
def custom_type() -> int: ...
