import sys
from collections.abc import Collection, Iterator
from typing import Any, ClassVar, SupportsIndex, Union, overload

from pygame.typing import ColorLike
from typing_extensions import deprecated  # added in 3.13

THECOLORS: dict[str, tuple[int, int, int, int]]

# Color confirms to the Collection ABC, since it also confirms to
# Sized, Iterable and Container ABCs
class Color(Collection[int]):
    r: int
    g: int
    b: int
    a: int
    cmy: tuple[float, float, float]
    hsva: tuple[float, float, float, float]
    hsla: tuple[float, float, float, float]
    i1i2i3: tuple[float, float, float]
    normalized: tuple[float, float, float, float]
    hex: str
    __hash__: ClassVar[None]  # type: ignore[assignment]
    @property
    def __array_struct__(self) -> Any: ...
    if sys.version_info >= (3, 12):
        def __buffer__(self, flags: int, /) -> memoryview[int]: ...
    @overload
    def __init__(self, r: int, g: int, b: int, a: int = 255) -> None: ...
    @overload
    def __init__(self, rgbvalue: ColorLike) -> None: ...
    @overload
    def __getitem__(self, i: SupportsIndex) -> int: ...
    @overload
    def __getitem__(self, s: slice) -> tuple[int, ...]: ...
    def __setitem__(self, key: int, value: int) -> None: ...
    def __iter__(self) -> Iterator[int]: ...
    def __add__(self, other: Color) -> Color: ...
    def __sub__(self, other: Color) -> Color: ...
    def __mul__(self, other: Color) -> Color: ...
    def __floordiv__(self, other: Color) -> Color: ...
    def __mod__(self, other: Color) -> Color: ...
    def __int__(self) -> int: ...
    def __float__(self) -> float: ...
    def __bytes__(self) -> bytes: ...
    def __len__(self) -> int: ...
    def __index__(self) -> int: ...
    def __invert__(self) -> Color: ...
    def __contains__(self, other: int) -> bool: ...  # type: ignore[override]
    def __getattribute__(self, name: str) -> Union[Color, tuple[int, ...]]: ...
    def __setattr__(self, name: str, value: Union[Color, tuple[int, ...]]) -> None: ...
    @overload
    @classmethod
    def from_cmy(cls, object: tuple[float, float, float], /) -> Color: ...
    @overload
    @classmethod
    def from_cmy(cls, c: float, m: float, y: float, /) -> Color: ...
    @overload
    @classmethod
    def from_hsva(cls, object: tuple[float, float, float, float], /) -> Color: ...
    @overload
    @classmethod
    def from_hsva(cls, h: float, s: float, v: float, a: float, /) -> Color: ...
    @overload
    @classmethod
    def from_hsla(cls, object: tuple[float, float, float, float], /) -> Color: ...
    @overload
    @classmethod
    def from_hsla(cls, h: float, s: float, l: float, a: float, /) -> Color: ...
    @overload
    @classmethod
    def from_i1i2i3(cls, object: tuple[float, float, float], /) -> Color: ...
    @overload
    @classmethod
    def from_i1i2i3(cls, i1: float, i2: float, i3: float, /) -> Color: ...
    @overload
    @classmethod
    def from_normalized(cls, object: tuple[float, float, float, float], /) -> Color: ...
    @overload
    @classmethod
    def from_normalized(cls, r: float, g: float, b: float, a: float, /) -> Color: ...
    @classmethod
    def from_hex(cls, hex: str, /) -> Color: ...
    def normalize(self) -> tuple[float, float, float, float]: ...
    def correct_gamma(self, gamma: float, /) -> Color: ...
    @deprecated("since 2.1.3. Use unpacking instead")
    def set_length(self, length: int, /) -> None: ...
    def lerp(self, color: ColorLike, amount: float) -> Color: ...
    def premul_alpha(self) -> Color: ...
    def grayscale(self) -> Color: ...
    @overload
    def update(self, r: int, g: int, b: int, a: int = 255, /) -> None: ...
    @overload
    def update(self, rgbvalue: ColorLike, /) -> None: ...
