#!/usr/bin/env bash
cd "$(dirname "$(realpath "$0")")"

# Colors for output
RED="\033[0;31m"
GREEN="\033[0;32m"
YELLOW="\033[1;33m"
NC="\033[0m" # No Color

set +eu
# Check if notify-send exists globally
command -v notify-send &> /dev/null
NOTIFY_SEND_AVAILABLE=$?
set -eu

# Logging functions
log_info() {
    echo -e "${GREEN}[INFO]${NC} $1"
    set +eu
    if [ "$NOTIFY_SEND_AVAILABLE" -eq 0 ]; then
        notify-send -t 5000 "INFO" "$1" 2>/dev/null
    fi
    set -eu
}

log_warn() {
    echo -e "${YELLOW}[WARN]${NC} $1"
    set +eu
    if [ "$NOTIFY_SEND_AVAILABLE" -eq 0 ]; then
        notify-send -t 5000 -u normal "WARNING" "$1" 2>/dev/null
    fi
    set -eu
}

log_error() {
    echo -e "${RED}[ERROR]${NC} $1"
    set +eu
    if [ "$NOTIFY_SEND_AVAILABLE" -eq 0 ]; then
        notify-send -t 5000 -u critical "ERROR" "$1" 2>/dev/null
    fi
    set -eu
}

setup_venv() {
	python3 -m venv .venv
	source .venv/bin/activate
	pip install -r requirements.txt
	deactivate
}

run_builds() {
	./build.sh &
	BIN=$!

	./winebuild.sh &
	WIN=$!

	wait $WIN $BIN
}

run_packaging() {
	./package_source.sh &
	SRC=$!

	./appimage.sh &
	APP=$!

	wait $APP $SRC
}

setup_venv
log_info ""
log_info "REQS FINISHED"
log_info ""

run_builds
log_info ""
log_info "WIN, BIN FINISHED"
log_info ""

run_packaging
log_info ""
log_info "SRC, APP FINISHED"
log_info ""

./zip_packages.sh
log_info ""
log_info "FINISHED"
log_info ""
