; Inno Setup Script for Accela
; This script creates an installer for the Accela application,
; handles necessary prerequisites, and provides user guidance.

[Setup]
; Unique AppId to manage installations and upgrades.
AppId={{C1214436-B68C-4759-865F-5205A2A3A431}}
AppName=Accela
AppVersion=2.0
AppPublisher=gOd_iS_In_tHe_wIrEd
DefaultDirName={autopf}\Accela
DefaultGroupName=Tachibana Labs
OutputBaseFilename=Accelav2.0Setup
WizardStyle=modern
PrivilegesRequired=admin
Compression=lzma
SolidCompression=yes

SetupIconFile=MyIcon.ico


[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Files]
Source: "dist\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs

; {-- CHANGED --} Replaced 'dontcopy' with 'deleteafterinstall' to change the extraction logic.
Source: "G:\MistWalker Lite\Accela Installer\prereqs\windowsdesktop-runtime-9.0.8-win-x64.exe"; DestDir: "{app}"; Flags: deleteafterinstall
Source: "G:\MistWalker Lite\Accela Installer\prereqs\windowsdesktop-runtime-9.0.8-win-x86.exe"; DestDir: "{app}"; Flags: deleteafterinstall
Source: "G:\MistWalker Lite\Accela Installer\prereqs\VC_redist.x64.exe"; DestDir: "{app}"; Flags: deleteafterinstall
Source: "G:\MistWalker Lite\Accela Installer\prereqs\VC_redist.x86.exe"; DestDir: "{app}"; Flags: deleteafterinstall

[Icons]
Name: "{group}\Accela"; Filename: "{app}\accela.exe"
Name: "{autodesktop}\Accela"; Filename: "{app}\accela.exe"; Tasks: desktopicon

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}";

[Run]
; {-- CHANGED --} Updated Filename from {tmp} to {app} to run from the new location.
; Install .NET 9.0 Desktop Runtime (64-bit)
Filename: "{app}\windowsdesktop-runtime-9.0.8-win-x64.exe"; Parameters: "/q /norestart"; StatusMsg: "Installing Microsoft .NET 9.0 Desktop Runtime..."; Check: IsWin64 and not IsDotNet9Installed

; Install .NET 9.0 Desktop Runtime (32-bit)
Filename: "{app}\windowsdesktop-runtime-9.0.8-win-x86.exe"; Parameters: "/q /norestart"; StatusMsg: "Installing Microsoft .NET 9.0 Desktop Runtime..."; Check: not IsWin64 and not IsDotNet9Installed

; Install Visual C++ 2015-2022 Redistributable (64-bit)
Filename: "{app}\VC_redist.x64.exe"; Parameters: "/install /quiet /norestart"; StatusMsg: "Installing Microsoft Visual C++ 2015-2022 Redistributable..."; Check: IsWin64 and not IsVCRedistInstalled

; Install Visual C++ 2015-2022 Redistributable (32-bit)
Filename: "{app}\VC_redist.x86.exe"; Parameters: "/install /quiet /norestart"; StatusMsg: "Installing Microsoft Visual C++ 2015-2022 Redistributable..."; Check: not IsWin64 and not IsVCRedistInstalled

[Code]
var
  StorageWarningPage: TOutputMsgWizardPage;

procedure InitializeWizard();
begin
  StorageWarningPage := CreateOutputMsgPage(wpWelcome,
    'Important Installation Warning', 'Installation Path Recommendation',
    'Accela requires write access to its installation directory to function correctly. ' +
    'Installing to protected system folders like ''Program Files'' or ''Program Files (x86)'' can cause permission errors.' + #13#10#13#10);
end;

function IsDotNet9Installed(): Boolean;
var
  Version: Cardinal;
begin
  Result := RegQueryDWordValue(HKLM, 'SOFTWARE\dotnet\Setup\InstalledVersions\x64\sharedhost', 'Version', Version) and (Version >= $00090000);
  if not Result then
    Result := RegQueryDWordValue(HKLM, 'SOFTWARE\dotnet\Setup\InstalledVersions\x86\sharedhost', 'Version', Version) and (Version >= $00090000);
end;

function IsVCRedistInstalled(): Boolean;
var
  InstallValue: DWord;
begin
  if IsWin64 then
    Result := RegQueryDWordValue(HKLM64, 'SOFTWARE\Microsoft\VisualStudio\14.0\VC\Runtimes\x64', 'Installed', InstallValue) and (InstallValue = 1)
  else
    Result := RegQueryDWordValue(HKLM32, 'SOFTWARE\Microsoft\VisualStudio\14.0\VC\Runtimes\x86', 'Installed', InstallValue) and (InstallValue = 1);
end;