from typing import final

from pygame.joystick import JoystickType
from pygame.typing import ColorLike

def init() -> None: ...
def get_init() -> bool: ...
def quit() -> None: ...
def is_controller(device_index: int) -> bool: ...
def get_count() -> int: ...
@final
class Controller:
    def __new__(cls, device_index: int) -> Controller: ...
    def __init__(self, device_index: int) -> None: ...
    @classmethod
    def from_joystick(cls, joystick: JoystickType) -> Controller: ...
    def get_init(self) -> bool: ...
    def init(self) -> None: ...
    def quit(self) -> None: ...
    @property
    def id(self) -> int: ...
    @property
    def name(self) -> str: ...
    def attached(self) -> bool: ...
    def as_joystick(self) -> JoystickType: ...
    def get_axis(self, axis: int) -> int: ...
    def get_button(self, button: int) -> bool: ...
    def get_mapping(self) -> dict[str, str]: ...
    def set_mapping(self, mapping: dict[str, str]) -> int: ...
    def rumble(
        self, low_frequency: float, high_frequency: float, duration: int
    ) -> bool: ...
    def stop_rumble(self) -> None: ...
    def set_led(self, color: ColorLike, /) -> bool: ...
