# SLSsteam Setup Guide (Linux)

## 🔧 What is SLSsteam?
SLSsteam is a shared object (.so) preload that adds various enhancements to your Steam client, providing advanced functionality for games not officially owned.

## Features
- **Disable Family Sharing license lock** (works for your account and others')
- **Unlock DLCs** (supports blacklist/whitelist modes)
- **Force-enable DLCs** not in the Steam store
- **Play games you don't own** (via manifest or manual method)

## Extra Features for Non-Owned Games
SLSsteam makes pirated/manual games behave more like real Steam purchases:

- **Dev-Made Controller Layouts** - Use official controller configurations even for games you don't own — great for Steam Deck and Big Picture mode
- **Steam Workshop Support** - Access Steam Workshop mods for supported games without needing to own them
- **Bypass Mod Launcher Ownership Checks** - Use tools like Vortex, r2modman, 7th Heaven and Thunderstore even if the game isn't in your library
- **Proper Save File Location** - Save files are stored in the correct Steam directory, so if you buy the game later, your saves carry over seamlessly

## Prerequisites (Steam Deck / Immutable Systems)

If you are on Steam Deck or have an immutable file system (like Bazzite), follow these steps before installing:

### 1. Set a sudo password:
```bash
sudo passwd
```
If you've never done this, you won't be able to run sudo commands.

### 2. Make the filesystem writable:
**Steam Deck:**
```bash
sudo steamos-readonly disable
```

### 3. Install necessary tools:
- Have a text editor installed (nano, vim, kate, etc.)
- Set your file browser to show hidden files

## Installation

### Step 1: Download & Extract
Grab the latest release from the GitHub repo:
[https://github.com/AceSLS/SLSsteam](https://github.com/AceSLS/SLSsteam)

### Step 2: Run Setup Script
Wherever you extracted the files, open a terminal in that directory and run:
```bash
./setup.sh install
```

### Step 3: Configure SLSsteam
Navigate to `~/.config/SLSsteam/` (or `/home/deck/.config/SLSsteam/` for Steam Deck) and open the config file using your text editor.

**Key configuration to enable:**
```ini
playNotOwnedGames = Yes
```

This setting allows you to play games downloaded by ACCELA as if you owned them.

### Step 4: Enable in ACCELA
1. Open ACCELA Settings (Gear Icon)
2. Enable **SLSsteam Mode**
3. Click **OK** to save

### Step 5: Restart Steam
When prompted by ACCELA, choose to restart Steam. Your games should now appear in your Steam library as if you owned them.

### Step 6: Set Proton Compatibility
For each game in Steam:
1. Right-click the game
2. Go to **Properties → Compatibility**
3. Check "Force the use of a specific Steam Play compatibility tool"
4. Select your preferred Proton version
5. Enjoy!

## Steam Deck Game Mode Instructions

**WARNING: This can potentially softbrick your steamdeck and will require a Deck recovery image to fix!**

### Method 1: Permanent Modification
1. Navigate to: `/usr/bin`
2. Find the `steam-jupiter` script and **make a backup** of this file somewhere safe!
3. Edit the `steam-jupiter` script found in `/usr/bin`
4. Change:
   ```bash
   exec /usr/lib/steam/steam -steamdeck "$@"
   ```
   To:
   ```bash
   exec env LD_AUDIT="~/.local/share/SLSsteam.so" /usr/lib/steam/steam -steamdeck "$@"
   ```
5. Save changes

Games will be unlocked now regardless of desktop or gamemode.

### Method 2: Temporary (Safer)
Run this command before starting Steam in Game Mode:
```bash
env LD_AUDIT="~/.local/share/SLSsteam.so" steam
```

## Troubleshooting

### "Application load error 6:0000065432"
This error indicates SteamStub DRM is still present. You need to:

1. **Enable DRM removal in ACCELA Settings**
2. Make sure **Steam DRM Removal** is checked in ACCELA before downloading games
3. ACCELA will automatically run Steamless on the game executables

### Games not appearing in Steam library
- Verify `playNotOwnedGames = Yes` is set in SLSsteam config
- Restart Steam completely after enabling SLSsteam mode
- Check that SLSsteam is properly loaded (check system logs)
- Ensure you enabled SLSsteam Mode in ACCELA settings

### SLSsteam not loading
- Verify the installation completed successfully
- Check that `~/.local/share/SLSsteam.so` exists
- Make sure your system meets the prerequisites
- On immutable systems, ensure you made the filesystem writable

### Permission errors
- Run setup scripts with `sudo` if necessary
- Ensure you have write permissions to the Steam directory
- Check that SLSsteam files have correct ownership and permissions

## Updating SLSsteam
To update SLSsteam:

1. Download the latest release from GitHub
2. Extract to a new directory
3. Run: `./setup.sh install`
4. Restart Steam

## Uninstallation
To remove SLSsteam:

1. Run: `./setup.sh uninstall` (from the SLSsteam directory)
2. Remove the SLSsteam config directory: `rm -rf ~/.config/SLSsteam/`
3. Restore original `steam-jupiter` script if modified
4. Restart Steam

## Additional Notes
- SLSsteam works with both native Linux games and Windows games via Proton
- Some online features may still require legitimate ownership
- Always backup your system before making significant modifications
- Regular Steam updates may require SLSsteam updates for compatibility

[Return to ACCELA Guide](./ACCELA_GUIDE.md?v) | [Settings Guide](./SETTINGS_GUIDE.md?v)
