# Settings Guide

## Accessing Settings
Click the **Settings Button** (Gear Icon) in the bottom title bar.

## Main Settings

### Morrenus API Key (Required for Search)
**How to get your API key:**
1. Visit https://manifest.morrenus.xyz/
2. Log in with Discord (must be in Morrenus Discord server)
3. Go to https://manifest.morrenus.xyz/api-keys/user
4. Create a new API Key and copy it
5. Paste it in the API Key field in Settings (Gear Icon)
6. Click OK to save

**Why you need it:**
- Required for searching and downloading games from the Morrenus database
- Without it, you can only use drag & drop with your own manifest ZIP files

### SLSsteam Mode
- **What it does**: Installs games directly into your Steam library
- **Windows**: Uses GreenLuma for compatibility
- **Linux**: Uses SLSsteam for compatibility
- **When to use**: Enable this if you want games to appear in your Steam library

### Steam Achievement Generation
- **What it does**: Automatically generates Steam achievement data after downloads
- **Requires**: You must click "Run SLScheevo" first to log in with your Steam account
- **How it works**: Uses SLScheevo behind the scenes to create achievement stats

### Steam DRM Removal
- **What it does**: Removes Steam DRM protection from downloaded games
- **Fixes errors**: Prevents launch errors like "6:0000065432" when playing games you don't own
- **Tool used**: Steamless (automatically runs after download)

## Steam Integration Setup

For detailed installation instructions for Steam integration tools:

- [Linux: SLSsteam](./SLSsteam.md) - Complete setup guide for Linux systems
- [Windows: GreenLuma](./Greenluma.md) - Complete setup guide for Windows systems

## SLScheevo Setup (Required for Achievements)

### First-Time Setup:
1. Click the **"Run SLScheevo"** button in Settings
2. Follow the instructions in the terminal to log in with your Steam account
3. Once logged in, SLScheevo will save your credentials
4. Close SLScheevo when done

### After Setup:
- Achievement generation will work automatically after downloads
- No need to run SLScheevo again unless you change Steam accounts or change account login details

## Saving Settings
- Click **OK** to save your changes
- Click **Cancel** to keep your old settings
- Some settings only affect new downloads (not existing ones)

[Return to start](./ACCELA_GUIDE.md?v)
