# ACCELA - Quick Start Guide

## What is ACCELA?
ACCELA is a game downloader and manager that works with the Morrenus API. It lets you search for games, download them, and manage your game library with a stylish interface inspired by Serial Experiments Lain.

## First Steps

### Steam Integration (Skip if you don't want this)
**Add games directly to your Steam library** using [SLSsteam (Linux)](./SLSsteam.md) or [GreenLuma (Windows)](./Greenluma.md) integration for full Steam functionality with downloaded games

### Getting Your API Key (Required for Search)
Before you can search for games, you need to get an API key:

1. Go to https://manifest.morrenus.xyz/
2. Log in with Discord (you must be in the Morrenus Discord server)
3. After logging in, go to https://manifest.morrenus.xyz/api-keys/user
4. Create a new API Key
5. Copy your API key
6. Open ACCELA Settings (Gear icon) and paste your key in the "Morrenus API Key" field
7. Click OK to save

### 1. Getting Games
**Method 1: Search & Download** (requires API key)
- Click the **Search button** (Magnifying Glass)
- Type a game name and press Enter
- Double-click a result to download it

**Method 2: Drag & Drop** (no API key needed)
- Download manifest ZIP files on your computer
- Drag them directly onto the main window

### 2. Managing Your Games
- Click the **Game Library button** (Book Icon) to see all your installed games
- Click any game to see details or uninstall it
- Use "Scan Steam Libraries" if games are missing

### 3. Customizing Your Experience

**Change Colors:**
- Click the **Palette button** to change accent and background colors

**Adjust Audio:**
- Click the **Audio button** to control sounds and volume

**Configure Settings:**
- Click the **Gear button** for advanced options like:
  - **SLSsteam mode** - Installs directly into Steam library (GreenLuma on Windows, SLSsteam on Linux)
  - **Achievement generation** - Creates Steam achievements (requires running SLScheevo first to log in)
  - **DRM removal** - Prevents launch errors like "6:0000065432" for games you don't own

## Need Help?
- Check the detailed guides below for specific features
- Look at the FAQ for common issues

## Detailed Guides
- [Audio Settings Guide](./AUDIO_GUIDE.md?v) - Control sounds and volume
- [Style Customization Guide](./STYLE_GUIDE.md?v) - Change colors and appearance  
- [Game Library Guide](./GAME_LIBRARY_GUIDE.md?v) - Manage your installed games
- [Settings Guide](./SETTINGS_GUIDE.md?v) - Configure advanced options
- [FAQ & Troubleshooting](./FAQ.md?v) - Solutions to common problems
