# GreenLuma Setup Guide (Windows)

## What is GreenLuma?
GreenLuma is a DLL injection tool for Steam that unlocks advanced features, allowing you to play games not in your library and access DLC content.

## Important Disclaimer
This guide involves modifying system settings and using third-party software. While efforts have been made to provide clear instructions, proceed at your own risk.
Incorrect modifications to the Windows Registry can cause system instability. 

**It is highly recommended to:**
- Backup your system or create a restore point before proceeding
- Be cautious with Registry Editor modifications
- Only download GreenLuma from trusted sources

## Part 1: Initial GreenLuma Setup

### Step 1: Download GreenLuma
1. [Navigate to the official GreenLuma thread](https://cs.rin.ru/forum/viewtopic.php?f=29&t=103709)
2. Download the latest version of GreenLuma
3. **Note:** Your browser or antivirus software might flag the download. This is common for tools that interact with other applications. Proceed only if you trust the source.

### Step 2: Extract Files to Your Steam Folder
1. Locate your main Steam installation folder (typically):
   - `C:\Program Files (x86)\Steam`
   - `C:\Program Files\Steam`

2. From the downloaded GreenLuma archive, extract these files **directly into your main Steam folder**:
   - `GreenLuma2025_Files` (folder)
   - `GreenLuma_2025_x86.dll`
   - `GreenLuma_2025_x64.dll`
   - `GreenLumaSettings_2025.exe`
   - `DLLInjector.exe`
   - `DLLInjector.ini`

3. Extract `x64launcher.exe` into the `bin` folder inside your Steam directory:
   - `C:\Program Files (x86)\Steam\bin\`

### Step 3: Create the "AppList" Folder
- In your main Steam directory, create a new folder named `AppList`
- This folder will be used by GreenLuma to manage game manifests

### Step 4: Configure GreenLuma Settings
1. Run `GreenLumaSettings_2025.exe` as an administrator (Right-click → Run as administrator) 🧑
2. Inside the GreenLuma settings application, enable the following options:
   - **No Question Mode**
   - **Stealth Mode**
3. Save your settings and close the application

## Part 2: Running Games with GreenLuma (Manual Start)

**Important:** Whenever you wish to run games under GreenLuma's influence, you must start Steam by launching `DLLInjector.exe` from your main Steam folder.

**Do NOT** launch Steam directly from its usual shortcut or `Steam.exe`.

## Part 3: Persistent GreenLuma Activation

You can choose **ONE** of the following methods to ensure GreenLuma activates automatically every time your PC starts.

### Method A: Using Task Scheduler (Recommended for most users)

This method is generally safer and easier to manage than modifying the Registry.

#### Step 1: Disable Steam's Auto-Start
1. Open Steam
2. Go to **Steam → Settings** 
3. Navigate to the **Interface** tab
4. Uncheck the option **"Run Steam when my computer starts"**
5. Click **OK** to save changes

#### Step 2: Open Task Scheduler
- Press `Windows Key + R` to open the Run dialog
- Type `taskschd.msc` and press Enter
- Or search for "Task Scheduler" in the Windows Start Menu

#### Step 3: Create a Basic Task
1. In the Task Scheduler window, in the right-hand "Actions" pane, click on **"Create Basic Task..."**
2. **Task Name and Description:**
   - Name: `GreenLuma Startup` (or any descriptive name)
   - Description: `Starts Steam with GreenLuma via DLLInjector.exe at system startup`
   - Click **Next**

3. **Trigger:**
   - Select **When the computer starts**
   - Click **Next**

4. **Action:**
   - Select **Start a program**
   - Click **Next**

5. **Program/script:**
   - Click **Browse...** and navigate to your Steam folder
   - Select `DLLInjector.exe`
   - Click **Open**
   - Click **Next**

6. **Finish:**
   - Review your settings
   - Check the box **"Open the Properties dialog for this task when I click Finish"**
   - Click **Finish**

#### Step 4: Configure Task Properties (Important)
1. In the Properties window that opens, on the **General** tab:
2. Under **"Security options"**, click the **Change User or Group...** button
3. Type `SYSTEM` in the "Enter the object name to select" field and click **Check Names**
4. Click **OK**
5. Ensure **Run with highest privileges** is checked
6. Under **"Configure for:"**, select your Windows version (e.g., Windows 10)
7. Under **"Security options"**, select **Run whether user is logged on or not**
8. Click **OK** (You might be prompted for your administrator password)

### Method B: Using a .bat file and Registry Editor (Advanced - Use with Extreme Caution)

This method involves modifying a critical system registry key. Incorrect changes can prevent Windows from starting. **Backup your registry before proceeding.**

#### Step 1: Backup Your Registry (Crucial Step)
1. Press `Windows Key + R`, type `regedit`, and press Enter to open Registry Editor
2. Navigate to `Computer\HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon`
3. Right-click on the `Winlogon` folder in the left pane
4. Select **Export...**
5. Save the `.reg` file to a safe location (e.g., a USB drive or cloud storage)

#### Step 2: Create the Batch (.bat) File
1. Open Notepad
2. Paste the following lines into Notepad:
```batch
@echo off
:: This line ensures the Windows desktop environment loads correctly.
start "" "C:\Windows\explorer.exe"
:: Replace [Your Steam Folder] with the actual path to your Steam installation.
start "" "[Your Steam Folder]\DLLInjector.exe"
exit
```

3. **IMPORTANT:** Replace `[Your Steam Folder]` with the actual, full path to your Steam installation (e.g., `C:\Program Files (x86)\Steam`)
4. Save the file in your main Steam directory with a descriptive name like `GLstartup.bat`
5. Make sure "Save as type" is set to "All Files" and add the `.bat` extension

#### Step 3: Open Registry Editor
- Press `Windows Key + R`, type `regedit`, and press Enter

#### Step 4: Navigate to the Target Key
- In the Registry Editor, navigate to:
  `Computer\HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon`

#### Step 5: Create a New String Value
1. In the right-hand pane of the `Winlogon` key, right-click on an empty space
2. Select **New > String Value**
3. Name the new string value `Shell`

#### Step 6: Edit the "Shell" Value Data
1. Right-click on the newly created `Shell` string value
2. Select **Modify...**
3. In the "Value data" field, enter the full path to your `.bat` file, enclosed in double quotes
   - Example: `"C:\Program Files (x86)\Steam\GLstartup.bat"`
4. Click **OK**

#### Step 7: Restart Your PC
- Close Registry Editor and restart your computer to apply the changes

#### To Revert Method B:
If you encounter issues or wish to disable this persistent activation:
1. Open Registry Editor and navigate to the same `Winlogon` key
2. Delete the `Shell` string value you created
3. Or double-click your exported `.reg` backup file to restore the previous state

## Important Considerations and Troubleshooting

### Antivirus Software
Your antivirus program might interfere with GreenLuma. To prevent this:
- Add an exception for your entire Steam installation folder in your antivirus settings
- This ensures that `DLLInjector.exe`, `GreenLuma_2025_x64.dll`, and other related files are not quarantined or blocked

### Administrator Privileges
- Ensure you run `GreenLumaSettings_2025.exe` and `DLLInjector.exe` with administrator privileges
- The Task Scheduler method should run with highest privileges

### Verify Paths
- Double-check all file paths entered in the Task Scheduler or the .bat file and Registry Editor
- A single typo can prevent the setup from working

### System Restore Point
Before making significant system changes, consider creating a Windows System Restore Point. This allows you to revert your system to a previous state if something goes wrong.

### Games Not Appearing in Library
- Make sure GreenLuma Mode is enabled in ACCELA Settings
- Verify you're launching Steam via `DLLInjector.exe`, not the normal shortcut
- Check that the `AppList` folder exists in your Steam directory
- Restart Steam completely after enabling GreenLuma mode

### "Application load error 6:0000065432"
- Enable DRM removal in ACCELA Settings before downloading games
- This error occurs when SteamStub DRM is present on games you don't own
- ACCELA will automatically run Steamless on game executables when DRM removal is enabled

## Integration with ACCELA

### Setup in ACCELA:
1. Open ACCELA Settings (Gear Icon)
2. Enable **GreenLuma Mode** (Windows)
3. Click **OK** to save

### Downloading Games:
1. After enabling GreenLuma Mode, download games through ACCELA as normal
2. Games will automatically appear in your Steam library
3. Launch games through Steam (using GreenLuma-injected Steam client)

## Uninstallation
To remove GreenLuma:

1. Delete all GreenLuma files from your Steam folder
2. Remove the Task Scheduler task (if using Method A)
3. Remove the Registry entry (if using Method B)
4. Restart your computer
5. Launch Steam normally

[Return to ACCELA Guide](./ACCELA_GUIDE.md?v) | [Settings Guide](./SETTINGS_GUIDE.md?v)
