#version 120


/*
		@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
		@##############################################################@	
		@#															  #@
		@#		[][][][][] [][][][][] [][][][][] [][][][][] []   	  #@
		@#		[]	  	       []     []      [] []	     [] []        #@
		@#		[]	 	       []     []      [] []	     [] []  	  #@
		@#		[]		       []     []      [] []	     [] []     	  #@
		@#		[][][][][]     []     []      [] [][][][][] []   	  #@
		@#				[]     []     []      [] []	        []        #@
		@#				[]     []     []      [] []	        []        #@
		@#				[]     []     []      [] []	           		  #@
		@#		[][][][][]     []     [][][][][] []	        []        #@
		@#															  #@
		@##############################################################@
		@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
		
		
		BEFORE DO ANYTHING, READ THIS AGREEMENT FIRST :
		
		
		YOU ARE ALLOWED TO :
		
		- Make videos or pictures with my shaderpack
		- Modify it only for yourself
		- Earn money with it from your YouTube Videos
		- Share my shaderpack link
		
		YOU ARE NOT ALLOWED TO :
		
		- Rename it and claim my shaderpack as your own
		- Publish your modifications
*/

#define MAX_COLOR_RANGE 48.0

/*
Werrus HFPS shaders, derived from Chocapic13 V4
Place two leading Slashes in front of the following '#define' lines in order to disable an option.
*/

//disabling is done by adding "//" to the beginning of a line.

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES

//#define VIGNETTE
#define VIGNETTE_STRENGTH 1.3

#define RAIN_DROPS

#define BLOOM_STRENGTH 0.02

//#define TIME_INDICATOR					//enable indicator that tell the time of the day (green=sunrise,white=noon,red=sunset,gray=night).

//#define DOF
	#define WEAK_DOF					//only enable one!
	//#define DEFAULT_DOF
	//#define TILT_SHIFT_DOF
	//#define CAMERA_DOF

#define TONEMAP
#define TONEMAP_CURVE 2.0
#define CONTRAST 0.3
#define GAMMA 1.0							//1.0 = default Gamma. Higher values mean darker.

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES

varying vec4 texcoord;
varying vec3 sunlight;

varying float eyeAdapt;

uniform sampler2D depthtex0;
uniform sampler2D depthtex2;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gaux4;
uniform sampler2D composite;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
vec3 sunPos = sunPosition;
uniform int fogMode;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float timefract = worldTime;

//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

float matflag = texture2D(gaux1,texcoord.xy).g;

// Standard depth function.
float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

#ifdef BLOOM
	#ifdef B_LQ
		const vec2 offsets[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);
	#endif
	
	#ifdef B_HQ
		const vec2 offsets[60] = vec2[60](vec2( 0.0000, 0.2500 ),
									vec2( -0.2165, 0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2( 0.2165, -0.1250 ),
									vec2( 0.2165, 0.1250 ),
									vec2( 0.0000, 0.5000 ),
									vec2( -0.2500, 0.4330 ),
									vec2( -0.4330, 0.2500 ),
									vec2( -0.5000, 0.0000 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.2500, -0.4330 ),
									vec2( -0.0000, -0.5000 ),
									vec2( 0.2500, -0.4330 ),
									vec2( 0.4330, -0.2500 ),
									vec2( 0.5000, -0.0000 ),
									vec2( 0.4330, 0.2500 ),
									vec2( 0.2500, 0.4330 ),
									vec2( 0.0000, 0.7500 ),
									vec2( -0.2565, 0.7048 ),
									vec2( -0.4821, 0.5745 ),
									vec2( -0.6495, 0.3750 ),
									vec2( -0.7386, 0.1302 ),
									vec2( -0.7386, -0.1302 ),
									vec2( -0.6495, -0.3750 ),
									vec2( -0.4821, -0.5745 ),
									vec2( -0.2565, -0.7048 ),
									vec2( -0.0000, -0.7500 ),
									vec2( 0.2565, -0.7048 ),
									vec2( 0.4821, -0.5745 ),
									vec2( 0.6495, -0.3750 ),
									vec2( 0.7386, -0.1302 ),
									vec2( 0.7386, 0.1302 ),
									vec2( 0.6495, 0.3750 ),
									vec2( 0.4821, 0.5745 ),
									vec2( 0.2565, 0.7048 ),
									vec2( 0.0000, 1.0000 ),
									vec2( -0.2588, 0.9659 ),
									vec2( -0.5000, 0.8660 ),
									vec2( -0.7071, 0.7071 ),
									vec2( -0.8660, 0.5000 ),
									vec2( -0.9659, 0.2588 ),
									vec2( -1.0000, 0.0000 ),
									vec2( -0.9659, -0.2588 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.7071, -0.7071 ),
									vec2( -0.5000, -0.8660 ),
									vec2( -0.2588, -0.9659 ),
									vec2( -0.0000, -1.0000 ),
									vec2( 0.2588, -0.9659 ),
									vec2( 0.5000, -0.8660 ),
									vec2( 0.7071, -0.7071 ),
									vec2( 0.8660, -0.5000 ),
									vec2( 0.9659, -0.2588 ),
									vec2( 1.0000, -0.0000 ),
									vec2( 0.9659, 0.2588 ),
									vec2( 0.8660, 0.5000 ),
									vec2( 0.7071, 0.7071 ),
									vec2( 0.5000, 0.8660 ),
									vec2( 0.2588, 0.9659 ));
	#endif
	
#endif

#ifdef DOF

//hexagon pattern
const vec2 hex_offsets[60] = vec2[60] (	vec2(  0.2165,  0.1250 ),
									vec2(  0.0000,  0.2500 ),
									vec2( -0.2165,  0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2(  0.2165, -0.1250 ),
									vec2(  0.4330,  0.2500 ),
									vec2(  0.0000,  0.5000 ),
									vec2( -0.4330,  0.2500 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.0000, -0.5000 ),
									vec2(  0.4330, -0.2500 ),
									vec2(  0.6495,  0.3750 ),
									vec2(  0.0000,  0.7500 ),
									vec2( -0.6495,  0.3750 ),
									vec2( -0.6495, -0.3750 ),
									vec2( -0.0000, -0.7500 ),
									vec2(  0.6495, -0.3750 ),
									vec2(  0.8660,  0.5000 ),
									vec2(  0.0000,  1.0000 ),
									vec2( -0.8660,  0.5000 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.0000, -1.0000 ),
									vec2(  0.8660, -0.5000 ),
									vec2(  0.2163,  0.3754 ),
									vec2( -0.2170,  0.3750 ),
									vec2( -0.4333, -0.0004 ),
									vec2( -0.2163, -0.3754 ),
									vec2(  0.2170, -0.3750 ),
									vec2(  0.4333,  0.0004 ),
									vec2(  0.4328,  0.5004 ),
									vec2( -0.2170,  0.6250 ),
									vec2( -0.6498,  0.1246 ),
									vec2( -0.4328, -0.5004 ),
									vec2(  0.2170, -0.6250 ),
									vec2(  0.6498, -0.1246 ),
									vec2(  0.6493,  0.6254 ),
									vec2( -0.2170,  0.8750 ),
									vec2( -0.8663,  0.2496 ),
									vec2( -0.6493, -0.6254 ),
									vec2(  0.2170, -0.8750 ),
									vec2(  0.8663, -0.2496 ),
									vec2(  0.2160,  0.6259 ),
									vec2( -0.4340,  0.5000 ),
									vec2( -0.6500, -0.1259 ),
									vec2( -0.2160, -0.6259 ),
									vec2(  0.4340, -0.5000 ),
									vec2(  0.6500,  0.1259 ),
									vec2(  0.4325,  0.7509 ),
									vec2( -0.4340,  0.7500 ),
									vec2( -0.8665, -0.0009 ),
									vec2( -0.4325, -0.7509 ),
									vec2(  0.4340, -0.7500 ),
									vec2(  0.8665,  0.0009 ),
									vec2(  0.2158,  0.8763 ),
									vec2( -0.6510,  0.6250 ),
									vec2( -0.8668, -0.2513 ),
									vec2( -0.2158, -0.8763 ),
									vec2(  0.6510, -0.6250 ),
									vec2(  0.8668,  0.2513 ));

#endif

#ifdef DOF

#ifdef WEAK_DOF
	//lens properties
const float focal = 0.014;
float aperture = 0.009;	
const float sizemult = 100.0;

#endif

#ifdef DEFAULT_DOF
	//lens properties
const float focal = 0.024;
float aperture = 0.009;	
const float sizemult = 100.0;

#endif

#ifdef TILT_SHIFT_DOF
	//lens properties
const float focal = 0.3;
float aperture = 0.3;	
const float sizemult = 1.0;

#endif

#ifdef CAMERA_DOF
	//lens properties
const float focal = 0.05;
float aperture = focal/7.0;	
const float sizemult = 100.0;

#endif

#endif
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////

float distratio(vec2 pos, vec2 pos2, float ratio) {
float xvect = pos.x*ratio-pos2.x*ratio;
float yvect = pos.y-pos2.y;
return sqrt(xvect*xvect + yvect*yvect);
}

//circle position pattern (vec2 coordinate, size)
const vec3 pattern[16] = vec3[16](	vec3(0.1,0.1,0.02),
								vec3(-0.12,0.07,0.02),
								vec3(-0.11,-0.13,0.02),
								vec3(0.1,-0.1,0.02),
								
								vec3(0.07,0.15,0.02),
								vec3(-0.08,0.17,0.02),
								vec3(-0.14,-0.07,0.02),
								vec3(0.15,-0.19,0.02),
								
								vec3(0.012,0.15,0.02),
								vec3(-0.08,0.17,0.02),
								vec3(-0.14,-0.07,0.02),
								vec3(0.02,-0.17,0.021),
								
								vec3(0.10,0.05,0.02),
								vec3(-0.13,0.09,0.02),
								vec3(-0.05,-0.1,0.02),
								vec3(0.1,0.01,0.02)
								);
								
float gen_circular_lens(vec2 center, float size) {
return 1.0-pow(min(distratio(texcoord.xy,center,aspectRatio),size)/size,10.0);
}

vec2 noisepattern(vec2 pos) {
return vec2(abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f)),abs(fract(sin(dot(pos.yx ,vec2(18.9898f,28.633f))) * 4378.5453f)));
} 
void main() {

int hand  = int(matflag > 0.75 && matflag < 0.85);
float rainlens = 0.0;

#ifdef RAIN_DROPS

//rain drops on screen
if (rainStrength > 0.1 && isEyeInWater < 0.9) {
const float pi = 3.14159265359;
const float lifetime = 60.0;		//water drop lifetime in seconds
float ftime = frameTimeCounter*50.0/lifetime;  
vec2 drop = vec2(0.0,fract(frameTimeCounter/30.0));
float time = frameTimeCounter;
float gen = 1.0-fract((ftime+0.5)*0.5);
vec2 pos = (noisepattern(vec2(-0.94386347*floor(ftime*0.5+0.25),floor(ftime*0.5+0.25))))*0.8+0.1 - drop;
rainlens += gen_circular_lens(fract(pos),0.04)*gen*rainStrength;

gen = 1.0-fract((ftime+1.0)*0.5);
pos = (noisepattern(vec2(0.9347*floor(ftime*0.5+0.5),-0.2533282*floor(ftime*0.5+0.5))))*0.8+0.1- drop;
rainlens += gen_circular_lens(fract(pos),0.023)*gen*rainStrength;

gen = 1.0-fract((ftime+1.5)*0.5);
pos = (noisepattern(vec2(0.785282*floor(ftime*0.5+0.75),-0.285282*floor(ftime*0.5+0.75))))*0.8+0.1- drop;
rainlens += gen_circular_lens(fract(pos),0.03)*gen*rainStrength;

gen =  1.0-fract(ftime*0.5);
pos = (noisepattern(vec2(-0.347*floor(ftime*0.5),0.6847*floor(ftime*0.5))))*0.8+0.1- drop;
rainlens += gen_circular_lens(fract(pos),0.05)*gen*rainStrength;

rainlens *= clamp((eyeBrightness.y-220)/15.0,0.0,1.0);

}

#endif

	vec2 fake_refract = vec2(sin(frameTimeCounter/5.0 + texcoord.x*100.0 + texcoord.y*50.0),cos(frameTimeCounter/15.0 + texcoord.y*100.0 + texcoord.x*50.0));
	vec3 color = texture2D(gaux2, texcoord.st + fake_refract * 0.005*((rainlens*8-isEyeInWater)+isEyeInWater*2)).rgb;
	color += texture2D(gaux4, texcoord.st).rgb*vec3(0.1,0.1,0.1);
	
#ifdef TIME_INDICATOR
	
    float outer_time_indicator = 0.0;
    float inner_time_indicator = 0.0;

    vec2 lens_pos = noisepattern(vec2(0.1,0.1));
    outer_time_indicator += gen_circular_lens(lens_pos,0.031);
    inner_time_indicator += gen_circular_lens(lens_pos,0.03);
	
	vec3 icolor_sunrise = vec3(0.0,1.0,1.0)*TimeSunrise;
	vec3 icolor_noon = vec3(1.0,1.0,1.0)*TimeNoon;
	vec3 icolor_sunset = vec3(1.0,0.0,0.0)*TimeSunset;
	vec3 icolor_midnight = vec3(0.6,0.6,0.6)*TimeMidnight;
	
	vec3 icolor = icolor_sunrise + icolor_noon + icolor_sunset + icolor_midnight;
	
	color += outer_time_indicator*-vec3(0.5,0.5,0.5);
	color += inner_time_indicator*icolor;

#endif

#ifdef DOF
	
	//Calculate pixel Circle of Confusion that will be used for bokeh depth of field
	float z = ld(texture2D(depthtex2, texcoord.st).r)*far;
	float focus = ld(texture2D(depthtex2, vec2(0.5)).r)*far;
	float pcoc = min(abs(aperture * (focal * (z - focus)) / (z * (focus - focal)))*sizemult,pw*10.0);		
	
	vec4 sample = vec4(0.0);
	vec3 bcolor = vec3(0.0);
	float nb = 0.0;
	vec2 bcoord = vec2(0.0);

	for ( int i = 0; i < 60; i++) {
		sample = texture2D(gaux2, texcoord.xy + hex_offsets[i]*pcoc*vec2(1.0,aspectRatio));
		bcolor += sample.rgb;
	}
	
	if (hand < 0.9) color.rgb = bcolor/60.0;
		
#endif
	
	float plum = luma(color.rgb);

#ifdef BLOOM
const int GL_LINEAR = 9729;
const int GL_EXP = 2048;
	//color.rgb = color.rgb*(1.0+(luma(color.rgb)-texture2D(gaux2,vec2(1.0)).a));
	vec3 blur = vec3(0.0);
	float depth_diff = clamp(pow(ld(texture2D(depthtex2, texcoord.st).r)*4.0,0.8),0.0,1.0)+0.1;
	float fog = 0.0;
	if (fogMode == 0) fog = 1.0-clamp(exp(-ld(texture2D(depthtex2, texcoord.st).r)),0.0,1.0);
	#ifdef B_LQ
			float scale = length(vec2(pw,ph));
			vec3 csample = vec3(0.0);
				for (int i=0; i < 25; i++) {
				vec2 coords = offsets[i];
				vec3 sample = texture2D(gaux2,texcoord.xy + coords*B_RAD*scale).rgb;
				csample += max(texture2D(gaux2,texcoord.xy + coords*B_RAD*scale).rgb-plum*0.75-B_TRESH,0.0) * (length(coords)+0.6)/2.0;
				blur += sample;
			}
			color += csample/25.0*B_INTENSITY;
		
		//fog blurring with the distance
		color.rgb = mix(color,blur/25.0,depth_diff*isEyeInWater*0.4+fog*(1.0-isEyeInWater)*rainStrength);
	#endif

	#ifdef B_HQ
			float scale = length(vec2(pw,ph));
			vec3 csample = vec3(0.0);
				for (int i=0; i < 60; i++) {
				vec2 coords = offsets[i];
				vec3 sample = texture2D(gaux2,texcoord.xy + coords*B_RAD*scale).rgb;
				csample += max(texture2D(gaux2,texcoord.xy + coords*B_RAD*scale).rgb-plum*0.75-B_TRESH,0.0) * (length(coords)+0.6)/2.0;
				blur += sample;
			}
			color += csample/60.0*B_INTENSITY;
		
		//fog blurring with the distance
		color.rgb = mix(color,blur/60.0,depth_diff*isEyeInWater*0.4+fog*(1.0-isEyeInWater)*rainStrength);
	#endif
	
#endif
	
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z;
		lightPos = (lightPos + 1.0f)/2.0f;
		
#ifdef RAIN_DROPS

//rain drops on screen
if (rainStrength > 0.1 && isEyeInWater < 0.9) {

vec3 fogclr = mix(gl_Fog.color.rgb,vec3(0.5,0.5,0.5),rainStrength)*vec3(0.9,0.9,1.0);

color += (0.2-TimeMidnight*0.2)*fogclr*rainlens*(eyeBrightness.y/255.0);

}

#endif

#ifdef VIGNETTE

float dv = distance(texcoord.st, vec2(0.5, 0.5));

dv *= VIGNETTE_STRENGTH;

dv = 1.0 - dv;

dv = pow(dv, 0.2);

dv *= 1.9;
dv -= 0.9;

color *= dv;
#endif

color = clamp(color,0.0,1.0);

float white = luma(color);
color = color*(1.0+pow(white,CONTRAST))/(2.0-CONTRAST);

color = pow(color,vec3(2.2));
#ifdef TONEMAP

color = color / (color + TONEMAP_CURVE) * (1.0+TONEMAP_CURVE);


#endif

float fog = 1-(exp(-pow(ld(texture2D(depthtex0, texcoord.st).r)/256.0*far,4.0-(1.7*rainStrength))*4.0));

//Bloom
const float rMult = 0.0016;
const int nSteps = 15;


int center = (nSteps-1)/2;
float radius = center*rMult;

vec3 blur = vec3(0.0);
float tw = 0.0;

float sigma = 0.3;
float A = 1.0/sqrt(2.0*3.14159265359*sigma);


for (int i = 0; i < nSteps; i++) {

float dist = (i-float(center))/center;

float weight = A*exp(-(dist*dist)/(2.0*sigma));

blur += pow(texture2DLod(composite,texcoord.xy + (rMult*eyeAdapt)*vec2(1.0,aspectRatio)*vec2(0.0,i-center),1.5).rgb,vec3(2.2))*weight;

tw += weight;
}
blur /= tw;


color.rgb = mix(color,blur*MAX_COLOR_RANGE,(fog)*min(rainStrength+isEyeInWater,1.));

blur *= (BLOOM_STRENGTH*eyeAdapt) * (sqrt(luma(blur)));
color.xyz = ((1-(1-color.xyz/48.0)*(1-blur.xyz))*48.0);

/*

color = ((blur + color/MAX_COLOR_RANGE) - (blur * color/MAX_COLOR_RANGE))*MAX_COLOR_RANGE;*/

color = pow(color,vec3(1.0/2.2));

	gl_FragColor = vec4(color,1.0);
	
}
