#version 120


/*
		@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
		@##############################################################@	
		@#															  #@
		@#		[][][][][] [][][][][] [][][][][] [][][][][] []   	  #@
		@#		[]	  	       []     []      [] []	     [] []        #@
		@#		[]	 	       []     []      [] []	     [] []  	  #@
		@#		[]		       []     []      [] []	     [] []     	  #@
		@#		[][][][][]     []     []      [] [][][][][] []   	  #@
		@#				[]     []     []      [] []	        []        #@
		@#				[]     []     []      [] []	        []        #@
		@#				[]     []     []      [] []	           		  #@
		@#		[][][][][]     []     [][][][][] []	        []        #@
		@#															  #@
		@##############################################################@
		@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
		
		
		BEFORE DO ANYTHING, READ THIS AGREEMENT FIRST :
		
		
		YOU ARE ALLOWED TO :
		
		- Make videos or pictures with my shaderpack
		- Modify it only for yourself
		- Earn money with it from your YouTube Videos
		- Share my shaderpack link
		
		YOU ARE NOT ALLOWED TO :
		
		- Rename it and claim my shaderpack as your own
		- Publish your modifications
*/

	const float	ambientOcclusionLevel = 0.6f;		//level of Minecraft smooth lighting, 1.0f is default
	
/*
Werrus HFPS shaders, derived from Chocapic13 V4
Place two leading Slashes in front of the following '#define' lines in order to disable an option.
*/

//to increase shadow draw distance, edit shadowDistance and SHADOWHPL below. Both should be equal. Needs decimal point.
//disabling is done by adding "//" to the beginning of a line.

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES

//----------Shadows----------//
const int 		shadowMapResolution 	= 512;			//shadowmap resolution
const float 	shadowDistance 			= 100.0f;		//draw distance of shadows

#define SHADOW_darkness 0.25	//shadow darkness levels, lower values mean darker shadows, see .vsh for colors /0.25 is default
//#define SHADOW_FILTER						//smooth shadows
	//#define SHADOW_ILLUMINATION
//----------End of Shadows----------//

//----------Lighting----------//
	#define DYNAMIC_HANDLIGHT		
	#define SUNLIGHTAMOUNT 2.3		//change sunlight_color strength , see .vsh for colors. /1.7 is default
	
	//Torch Color//
	vec3 torchcolor = vec3(1.0,0.25,0.0);		//RGB - Red, Green, Blue / vec3(0.6,0.32,0.1) is default
	vec3 torchcolor2 = vec3(1.0,0.45,0.0);		//RGB - Red, Green, Blue / vec3(0.6,0.32,0.1) is default
	#define TORCH_ATTEN 10.0						//how much the torch light will be attenuated (decrease if you want that the torches cover a bigger area))/3.0 is default
	#define TORCH_INTENSITY 1.0					//torch light intensity /2.6 is default
	#define TORCH_ATTEN2 7.0						//how much the torch light will be attenuated (decrease if you want that the torches cover a bigger area))/3.0 is default
	#define TORCH_INTENSITY2 0.6					//torch light intensity /2.6 is default
	
	//Minecraft lightmap (used for sky)
	#define ATTENUATION 7.0
	#define MIN_LIGHT 0.001
//----------End of Lighting----------//

//----------Visual----------//
	#define GODRAYS
	const float density = 0.55;			
	const int NUM_SAMPLES = 16;			//increase this for better quality at the cost of performance /5 is default
	const float grnoise = 0.012;		//amount of noise /0.012 is default
	
	//#define SSAO					//works but is turned off by default due to performance cost
	//SSAO constants
	const int nbdir = 6;			//the two numbers here affect the number of sample used. Increase for better quality at the cost of performance /6 and 6 is default
	const float sampledir = 6;	
	const float ssaorad = 1.0;		//radius of ssao shadows /1.0 is default
	
	//#define CELSHADING
		#define BORDER 1.0

	#define CLOUDS						//enable 2D clouds
		//#define VOLUMETRIC_CLOUDS		//change 2D clouds into volumetric clouds
		
	#define FOG							//enable fog
	
	#define DESATURATE_NIGHT
	
	#define NIGHT_STAR
	
	#define WATER_REFRACT				//make under water wavy
		#define REFRACT_MULT 0.75			//bigger mean more bumpy

	#define WATER_CAUSTIC				//enable water caustic
	
	#define WATER_FOG					//enable under water fog

//----------End of Visual----------//

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES

const int 		R8						= 0;
const int 		gdepthFormat 			= R8;
const bool 		generateShadowMipmap 	= false;
const float 	shadowIntervalSize 		= 4.0f;
const int 		noiseTextureResolution  = 64;
const float		sunPathRotation			= -20.0f;		//determines sun/moon inclination /-35.0 is default - 0.0 is normal rotation
#define SHADOW_MAP_BIAS 0.85



varying vec4 texcoord;
varying vec3 lightVector;
varying vec3 sunlight_color;
varying vec3 ambient_color;
varying float handItemLight;
varying float eyeAdapt;

uniform sampler2D gcolor;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D gnormal;
uniform sampler2D shadow;
uniform sampler2D gaux1;
uniform sampler2D noisetex;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform vec3 sunPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;
uniform float near;
uniform float far;
uniform vec3 skyColor;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;
uniform int fogMode;

float timefract = worldTime;

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);
float TimeDark = ((clamp(timefract, 13000.0, 13750.0) - 13000.0) / 750.0) - ((clamp(timefract, 22000.0, 23000.0) - 22000.0) / 1000.0);
float TimeChanging = (((clamp(timefract, 12000.0, 13000.0) - 12000.0) / 1000.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0))-TimeDark;
float TimeDay = TimeSunrise + TimeNoon + TimeSunset;

float cdist(vec2 coord){
    return distance(coord,vec2(0.5))*2.0;
}

vec3 convertScreenSpaceToWorldSpace(vec2 co, float depth) {
    vec4 fragposition = gbufferProjectionInverse * vec4(vec3(co, depth) * 2.0 - 1.0, 1.0);
    fragposition /= fragposition.w;
    return fragposition.xyz;
}

vec3 convertCameraSpaceToScreenSpace(vec3 cameraSpace) {
    vec4 clipSpace = gbufferProjection * vec4(cameraSpace, 1.0);
    vec3 NDCSpace = clipSpace.xyz / clipSpace.w;
    vec3 screenSpace = 0.5 * NDCSpace + 0.5;
    return screenSpace;
}

float edepth(vec2 coord) {
	return texture2D(depthtex0,coord).z;
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}
vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

vec2 texel = vec2(1.0/viewWidth,1.0/viewHeight);
vec3 aux = texture2D(gaux1, texcoord.st).rgb;
vec3 fogclr = mix(gl_Fog.color.rgb,vec3(0.5,0.5,0.5),rainStrength)*ambient_color;
vec3 sunPos = sunPosition;
vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0f - 1.0f;

vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);

vec3 sunVec = normalize(sunPosition);
vec3 moonVec = normalize(-sunPosition);
vec3 upVec = normalize(upPosition);
	
float SdotU = dot(sunVec,upVec);
float MdotU = dot(moonVec,upVec);
float sunVisibility = pow(clamp(SdotU+0.1,0.0,0.1)/0.1,2.0);
float moonVisibility = pow(clamp(MdotU+0.1,0.0,0.1)/0.1,2.0);
	
vec3 moonlight = ivec3(1,1,1)/255.0/2.2;

float pixeldepth = texture2D(depthtex0,texcoord.xy).x;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float shadowexit = 0.0;

float handlight = handItemLight;
const float speed = 1.5;
float light_jitter = 1.0-sin(frameTimeCounter*1.4*speed+cos(frameTimeCounter*1.9*speed))*0.0;			//little light variations
float torch_lightmap = pow(aux.b*light_jitter,TORCH_ATTEN)*TORCH_INTENSITY;
float torch_lightmap2 = pow(aux.b*light_jitter,TORCH_ATTEN2)*TORCH_INTENSITY2;

float sky_lightmap = pow(aux.r,ATTENUATION-eyeAdapt*2);

//poisson distribution for shadow sampling		
const vec2 circle_offsets[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);

float ctorspec(vec3 ppos, vec3 lvector, vec3 normal) {
    //half vector
	vec3 pos = -normalize(ppos);
    vec3 cHalf = normalize(lvector + pos);
	
    // beckman's distribution function D
    float normalDotHalf = dot(normal, cHalf);
    float normalDotHalf2 = normalDotHalf * normalDotHalf;

    float roughness2 = 0.05;
    float exponent = -(1.0 - normalDotHalf2) / (normalDotHalf2 * roughness2);
    float e = 2.71828182846;
    float D = pow(e, exponent) / (roughness2 * normalDotHalf2 * normalDotHalf2);
	
    // fresnel term F
	float normalDotEye = dot(normal, pos);
    float F = pow(1.0 - normalDotEye, 5.0);

    // self shadowing term G
    float normalDotLight = dot(normal, lvector);
    float X = 2.0 * normalDotHalf / dot(pos, cHalf);
    float G = min(1.0, min(X * normalDotLight, X * normalDotEye));
    float pi = 3.1415927;
    float CookTorrance = (D*F*G)/(pi*normalDotEye);
	
    return max(CookTorrance/pi,0.0);
}

float Blinn_Phong(vec3 ppos, vec3 lvector, vec3 normal,float fpow, float gloss, float visibility)  {
	vec3 lightDir = vec3(lvector);
	
	vec3 surfaceNormal = normal;
	float cosAngIncidence = dot(surfaceNormal, lightDir);
	cosAngIncidence = clamp(cosAngIncidence, 0.0, 1.0);
	
	vec3 viewDirection = normalize(-ppos);
	
	vec3 halfAngle = normalize(lightDir + viewDirection);
	float blinnTerm = dot(surfaceNormal, halfAngle);
	
	float normalDotEye = dot(normal, normalize(ppos));
	float fresnel = clamp(pow(1.0 + normalDotEye, 5.0),0.0,1.0);
	fresnel = fresnel*0.85 + 0.15 * (1.0-fresnel);
	float pi = 3.1415927;
	float n =  pow(2.0,gloss*10.0);
	return (pow(blinnTerm, n )*((n+8.0)/(8*pi)))*visibility;
}

float diffuseorennayar(vec3 pos, vec3 lvector, vec3 normal, float spec, float roughness) {
	
    vec3 v=normalize(pos);
	vec3 l=normalize(lvector);
	vec3 n=normalize(normal);

	float vdotn=dot(v,n);
	float ldotn=dot(l,n);
	float cos_theta_r=vdotn; 
	float cos_theta_i=ldotn; 
	float cos_phi_diff=dot(normalize(v-n*vdotn),normalize(l-n*ldotn));
	float cos_alpha=min(cos_theta_i,cos_theta_r); // alpha=max(theta_i,theta_r);
	float cos_beta=max(cos_theta_i,cos_theta_r); // beta=min(theta_i,theta_r)

	float r2=roughness*roughness;
	float a=1.0-0.5*r2/(r2+0.33);
	float b_term;
	
	if(cos_phi_diff>=0.0) {
		float b=0.45*r2/(r2+0.09);
		//b_term=b*sqrt((1.0-cos_alpha*cos_alpha)*(1.0-cos_beta*cos_beta))/cos_beta*cos_phi_diff;
		b_term = b*sin(cos_alpha)*tan(cos_beta)*cos_phi_diff;
	}
	else b_term=0.0;

	return clamp(cos_theta_i*(a+b_term*spec),0.0,1.0);
}

#ifdef CELSHADING
vec3 celshade(vec3 clrr) {
	//edge detect
	float d = edepth(texcoord.xy);
	float dtresh = 1/(far-near)/5000.0;	
	vec4 dc = vec4(d,d,d,d);
	vec4 sa;
	vec4 sb;
	sa.x = edepth(texcoord.xy + vec2(-pw,-ph)*BORDER);
	sa.y = edepth(texcoord.xy + vec2(pw,-ph)*BORDER);
	sa.z = edepth(texcoord.xy + vec2(-pw,0.0)*BORDER);
	sa.w = edepth(texcoord.xy + vec2(0.0,ph)*BORDER);
	
	//opposite side samples
	sb.x = edepth(texcoord.xy + vec2(pw,ph)*BORDER);
	sb.y = edepth(texcoord.xy + vec2(-pw,ph)*BORDER);
	sb.z = edepth(texcoord.xy + vec2(pw,0.0)*BORDER);
	sb.w = edepth(texcoord.xy + vec2(0.0,-ph)*BORDER);
	
	vec4 dd = abs(2.0* dc - sa - sb) - dtresh;
	dd = vec4(step(dd.x,0.0),step(dd.y,0.0),step(dd.z,0.0),step(dd.w,0.0));
	
	float e = clamp(dot(dd,vec4(0.5f,0.5f,0.5f,0.5f)),0.0,1.0);
	return clrr*e;
}
#endif

float getnoise(vec2 pos) {
return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));

}

float interpolate(vec3 truepos,float center,vec3 poscenter,float value2,vec3 pos2,float value3,vec3 pos3,float value4,vec3 pos4,float value5,vec3 pos5) {
/*
float mix1 = mix(center,value2,1.0-length(truepos-pos2));
float mix2 = mix(mix1,value3,1.0-length(truepos-pos3));
float mix3 = mix(mix2,value4,1.0-length(truepos-pos4));
return mix(mix3,value5,1.0-length(truepos-pos5));
*/
return center*(1.0-distance(truepos,poscenter))+value2*(1.0-distance(truepos,pos2))+value3*(1.0-distance(truepos,pos3))+value4*(1.0-distance(truepos,pos4))+value5*(1.0-distance(truepos,pos5));
}

const float PI = 3.1415927;

#ifdef WATER_REFRACT

float waterH(vec2 posxz) {

vec2 movement = vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
vec2 movement2 = vec2(-abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
vec2 movement3 = vec2(-abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5));
vec2 movement4 = vec2(abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5));

vec2 coord = (posxz/30)+(movement*20);
vec2 coord1 = (posxz/29.9)+(movement2*20);
vec2 coord2 = (posxz/29.8)+(movement3*20);
vec2 coord3 = (posxz/29.7)+(movement4*20);
float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;
noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
noise += texture2D(noisetex,fract(coord.xy*8.0)).x/16.0;
noise += texture2D(noisetex,fract(coord.xy*16.0)).x/32.0;
noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord1.xy*2.0)).x/4.0;
noise += texture2D(noisetex,fract(coord1.xy*4.0)).x/8.0;
noise += texture2D(noisetex,fract(coord1.xy*8.0)).x/16.0;
noise += texture2D(noisetex,fract(coord1.xy*16.0)).x/32.0;
noise += texture2D(noisetex,fract(coord2.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord2.xy*2.0)).x/4.0;
noise += texture2D(noisetex,fract(coord2.xy*4.0)).x/8.0;
noise += texture2D(noisetex,fract(coord2.xy*8.0)).x/16.0;
noise += texture2D(noisetex,fract(coord2.xy*16.0)).x/32.0;
noise += texture2D(noisetex,fract(coord3.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord3.xy*2.0)).x/4.0;
noise += texture2D(noisetex,fract(coord3.xy*4.0)).x/8.0;
noise += texture2D(noisetex,fract(coord3.xy*8.0)).x/16.0;
noise += texture2D(noisetex,fract(coord3.xy*16.0)).x/32.0;

return noise*0.2;
}

#endif

vec3 getSkyColor(vec3 fposition) {
//sky gradient
/*----------*/
vec3 sky_color = pow(ambient_color,vec3(2.2))*2.0;
vec3 sVector = normalize(fposition);
vec3 upVector = normalize(upPosition);

sky_color = mix(sky_color,vec3(0.25,0.3,0.4)*length(ambient_color),rainStrength);

float Lz = (0.15+(eyeAdapt*0.1));
float cosT = dot(sVector,upVector);
float cosS = dot(lightVector,upVector);
float S = acos(cosS);
float cosY = dot(lightVector,sVector);
float Y = acos(cosY);
float cosT2 = abs(cosT);

float L =   pow(((0.91+10*exp(-3*Y)+0.45*cosY*cosY)*(1.0-exp(-0.32/cosT2)))/((0.91+10*exp(-3*S)+0.45*cosS*cosS)*(1.0-exp(-0.32))),1.0-rainStrength*0.8);

sky_color = mix(sky_color,pow(vec3(0.5,0.5,0.5)-TimeMidnight*0.45,vec3(2.2)),1-exp(-0.3*L*(1-rainStrength*0.8)));


sky_color = vec3(L*Lz)*sky_color;

return sky_color;  //mix up sky color and clouds
}

float subSurfaceScattering(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos)),0.0),N)*(N+1)/6.28;

}

float subSurfaceScattering2(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos))*0.5+0.5,0.0),N)*(N+1)/6.28;

}

#ifdef CLOUDS

vec3 drawCloud(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float McosY = MdotU;
float cosY = SdotU;
//cloud generation
/*----------*/
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(26.0/(wVector.y));

	vec2 wind = vec2(frameTimeCounter*(cos(frameTimeCounter/3000.0)+0.5),frameTimeCounter*(sin(frameTimeCounter/3000.0)+0.5));
	
	vec3 wpos = tpos.xyz+cameraPosition;
	vec2 coord = (intersection.xz+(wind/2))/512.0;
	vec2 coord1 = (intersection.xz+(wind/10))/512.0;
	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;

	  float N = 8.0;
vec3 cloud_color = (ambient_color + mix(vec3(1.0,1.0,1.0),length(vec3(1.0,1.0,1.0))*-vec3(0.5,0.5,0.5),rainStrength)*sunVisibility + mix(moonlight,length(moonlight)*-vec3(0.5,0.5,0.5),rainStrength) * moonVisibility) * 0.12 *density + (24.*subSurfaceScattering(sunVec,fragpos,10.0)*pow(density,1.) + 10.*subSurfaceScattering2(sunVec,fragpos,0.1)*pow(density,1.))*mix(vec3(1.0,1.0,1.0),length(vec3(1.0,1.0,1.0))*vec3(0.0,0.0,0.0),rainStrength)*sunVisibility +  (24.*subSurfaceScattering(moonVec,fragpos,10.0)*pow(density,1.) + 10.*subSurfaceScattering2(moonVec,fragpos,0.1)*pow(density,1.))*mix(moonlight,length(moonlight)*vec3(0.0,0.0,0.0),rainStrength)*moonVisibility;	//coloring clouds

#ifdef VOLUMETRIC_CLOUDS

cloud_color = (ambient_color + mix(vec3(1.0,1.0,1.0),length(vec3(1.0,1.0,1.0))*-vec3(0.5,0.5,0.5),rainStrength)*sunVisibility + mix(moonlight,length(moonlight)*-vec3(0.5,0.5,0.5),rainStrength) * moonVisibility) * 0.12 *density + (24.*subSurfaceScattering(sunVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(sunVec,fragpos,0.1)*pow(density,2.))*mix(vec3(1.0,1.0,1.0),length(vec3(1.0,1.0,1.0))*vec3(0.0,0.0,0.0),rainStrength)*sunVisibility +  (24.*subSurfaceScattering(moonVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(moonVec,fragpos,0.1)*pow(density,2.))*mix(moonlight,length(moonlight)*vec3(0.0,0.0,0.0),rainStrength)*moonVisibility;	//coloring clouds

#endif

	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord.xy*128.0)).x/256.0;
	noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord1.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord1.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord1.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord1.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord1.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord1.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord1.xy*128.0)).x/256.0;

	float cl = max(noise-(1.5-rainStrength*0.2),0.0);
	
#ifdef VOLUMETRIC_CLOUDS
	
	cl = max(noise-(1.7-rainStrength*0.2),0.0);

#endif	
	
	float ef = 0.15+TimeChanging*0.85;
	float density = max(1-cl*1.0,0.)*max(1-cl*1.0,0.);
	float cloud2 = (1.0 - (pow(ef,cl)))*max(cosT,0.0);
	
#ifdef VOLUMETRIC_CLOUDS
	
cloud2 = (1.0 - (pow(ef,cl)))*max(cosT,0.0)*density;
	  
#endif
	  
vec3 c = mix(color,cloud_color,cloud2);

return c;
}

#ifdef VOLUMETRIC_CLOUDS

vec3 drawCloud2(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float McosY = MdotU;
float cosY = SdotU;
//cloud generation
/*----------*/
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(26.5/(wVector.y));

	vec2 wind = vec2(frameTimeCounter*(cos(frameTimeCounter/3000.0)+0.5),frameTimeCounter*(sin(frameTimeCounter/3000.0)+0.5));
	
	vec3 wpos = tpos.xyz+cameraPosition;
	vec2 coord = (intersection.xz+(wind/2))/512.0;
	vec2 coord1 = (intersection.xz+(wind/10))/512.0;
	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;

	  float N = 8.0;
vec3 cloud_color = (ambient_color + mix(vec3(1.0,1.0,1.0),length(vec3(1.0,1.0,1.0))*-vec3(0.5,0.5,0.5),rainStrength)*sunVisibility + mix(moonlight,length(moonlight)*-vec3(0.5,0.5,0.5),rainStrength) * moonVisibility) * 0.12 *density + (24.*subSurfaceScattering(sunVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(sunVec,fragpos,0.1)*pow(density,2.))*mix(vec3(1.0,1.0,1.0),length(vec3(1.0,1.0,1.0))*vec3(0.0,0.0,0.0),rainStrength)*sunVisibility +  (24.*subSurfaceScattering(moonVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(moonVec,fragpos,0.1)*pow(density,2.))*mix(moonlight,length(moonlight)*vec3(0.0,0.0,0.0),rainStrength)*moonVisibility;	//coloring clouds

	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord.xy*128.0)).x/256.0;
	noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord1.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord1.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord1.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord1.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord1.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord1.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord1.xy*128.0)).x/256.0;


	float cl = max(noise-(1.65-rainStrength*0.2),0.0);

	float ef = 0.15+TimeChanging*0.85;
	float density = max(1-cl*1.0,0.)*max(1-cl*1.0,0.);
    float cloud2 = (1.0 - (pow(ef,cl)))*max(cosT,0.0)*density;
	  
vec3 c = mix(color,cloud_color,cloud2);

return c;
}

vec3 drawCloud3(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float McosY = MdotU;
float cosY = SdotU;
//cloud generation
/*----------*/
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(27.0/(wVector.y));

	vec2 wind = vec2(frameTimeCounter*(cos(frameTimeCounter/3000.0)+0.5),frameTimeCounter*(sin(frameTimeCounter/3000.0)+0.5));
	
	vec3 wpos = tpos.xyz+cameraPosition;
	vec2 coord = (intersection.xz+(wind/2))/512.0;
	vec2 coord1 = (intersection.xz+(wind/10))/512.0;
	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;

	  float N = 8.0;
vec3 cloud_color = (ambient_color + mix(vec3(1.0,1.0,1.0),length(vec3(1.0,1.0,1.0))*-vec3(0.5,0.5,0.5),rainStrength)*sunVisibility + mix(moonlight,length(moonlight)*-vec3(0.5,0.5,0.5),rainStrength) * moonVisibility) * 0.12 *density + (24.*subSurfaceScattering(sunVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(sunVec,fragpos,0.1)*pow(density,2.))*mix(vec3(1.0,1.0,1.0),length(vec3(1.0,1.0,1.0))*vec3(0.0,0.0,0.0),rainStrength)*sunVisibility +  (24.*subSurfaceScattering(moonVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(moonVec,fragpos,0.1)*pow(density,2.))*mix(moonlight,length(moonlight)*vec3(0.0,0.0,0.0),rainStrength)*moonVisibility;	//coloring clouds

	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord.xy*128.0)).x/256.0;
	noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord1.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord1.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord1.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord1.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord1.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord1.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord1.xy*128.0)).x/256.0;


	float cl = max(noise-(1.5-rainStrength*0.2),0.0);

	float ef = 0.15+TimeChanging*0.85;
	float density = max(1-cl*1.0,0.)*max(1-cl*1.0,0.);
    float cloud2 = (1.0 - (pow(ef,cl)))*max(cosT,0.0)*density;
	  
vec3 c = mix(color,cloud_color,cloud2);

return c;
}

vec3 drawCloud4(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float McosY = MdotU;
float cosY = SdotU;
//cloud generation
/*----------*/
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(27.5/(wVector.y));

	vec2 wind = vec2(frameTimeCounter*(cos(frameTimeCounter/3000.0)+0.5),frameTimeCounter*(sin(frameTimeCounter/3000.0)+0.5));
	
	vec3 wpos = tpos.xyz+cameraPosition;
	vec2 coord = (intersection.xz+(wind/2))/512.0;
	vec2 coord1 = (intersection.xz+(wind/10))/512.0;
	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;

	  float N = 8.0;
vec3 cloud_color = (ambient_color + mix(vec3(1.0,1.0,1.0),length(vec3(1.0,1.0,1.0))*-vec3(0.5,0.5,0.5),rainStrength)*sunVisibility + mix(moonlight,length(moonlight)*-vec3(0.5,0.5,0.5),rainStrength) * moonVisibility) * 0.12 *density + (24.*subSurfaceScattering(sunVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(sunVec,fragpos,0.1)*pow(density,2.))*mix(vec3(1.0,1.0,1.0),length(vec3(1.0,1.0,1.0))*vec3(0.0,0.0,0.0),rainStrength)*sunVisibility +  (24.*subSurfaceScattering(moonVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(moonVec,fragpos,0.1)*pow(density,2.))*mix(moonlight,length(moonlight)*vec3(0.0,0.0,0.0),rainStrength)*moonVisibility;	//coloring clouds

	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord.xy*128.0)).x/256.0;
	noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord1.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord1.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord1.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord1.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord1.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord1.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord1.xy*128.0)).x/256.0;


	float cl = max(noise-(1.45-rainStrength*0.2),0.0);

	float ef = 0.15+TimeChanging*0.85;
	float density = max(1-cl*1.0,0.)*max(1-cl*1.0,0.);
    float cloud2 = (1.0 - (pow(ef,cl)))*max(cosT,0.0)*density;
	  
vec3 c = mix(color,cloud_color,cloud2);

return c;
}

vec3 drawCloud5(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float McosY = MdotU;
float cosY = SdotU;
//cloud generation
/*----------*/
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(28.0/(wVector.y));

	vec2 wind = vec2(frameTimeCounter*(cos(frameTimeCounter/3000.0)+0.5),frameTimeCounter*(sin(frameTimeCounter/3000.0)+0.5));
	
	vec3 wpos = tpos.xyz+cameraPosition;
	vec2 coord = (intersection.xz+(wind/2))/512.0;
	vec2 coord1 = (intersection.xz+(wind/10))/512.0;
	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;

	  float N = 8.0;
vec3 cloud_color = (ambient_color + mix(vec3(1.0,1.0,1.0),length(vec3(1.0,1.0,1.0))*-vec3(0.5,0.5,0.5),rainStrength)*sunVisibility + mix(moonlight,length(moonlight)*-vec3(0.5,0.5,0.5),rainStrength) * moonVisibility) * 0.12 *density + (24.*subSurfaceScattering(sunVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(sunVec,fragpos,0.1)*pow(density,2.))*mix(vec3(1.0,1.0,1.0),length(vec3(1.0,1.0,1.0))*vec3(0.0,0.0,0.0),rainStrength)*sunVisibility +  (24.*subSurfaceScattering(moonVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(moonVec,fragpos,0.1)*pow(density,2.))*mix(moonlight,length(moonlight)*vec3(0.0,0.0,0.0),rainStrength)*moonVisibility;	//coloring clouds

	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord.xy*128.0)).x/256.0;
	noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord1.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord1.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord1.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord1.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord1.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord1.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord1.xy*128.0)).x/256.0;


	float cl = max(noise-(1.4-rainStrength*0.2),0.0);

	float ef = 0.15+TimeChanging*0.85;
	float density = max(1-cl*1.0,0.)*max(1-cl*1.0,0.);
    float cloud2 = (1.0 - (pow(ef,cl)))*max(cosT,0.0)*density;
	  
vec3 c = mix(color,cloud_color,cloud2);

return c;
}

#endif

#endif

#ifdef NIGHT_STAR

vec3 fakeStar(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float McosY = MdotU;
float cosY = SdotU;
//star generation
/*----------*/
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(300.0/(wVector.y));

	vec3 wpos = tpos.xyz+cameraPosition;
	intersection.xz = intersection.xz + 2.0*cosT*intersection.xz;		//curve the star pattern, because sky is not 100% plane in reality
	vec2 coord = intersection.xz/512.0;
	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;

	  float N = 8.0;
vec3 star_color = vec3(1.0,1.0,1.0)*(1.0-rainStrength)*moonVisibility;	//coloring stars

	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;

	float cl = max(noise-(1.45+rainStrength),0.0);
	float ef = 0.55;
 
      float star2 = (1.0 - (pow(ef,cl)))*max(cosT,0.0);
	  
vec3 s = mix(color,star_color,star2);

return s;
}

#endif

#ifdef WATER_CAUSTIC

vec3 waterCaustic(vec3 fposition,vec3 color) {

vec2 movement = vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
vec2 movement2 = vec2(-abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
vec2 movement3 = vec2(-abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5));
vec2 movement4 = vec2(abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5));
	
vec3 underwaterpos = vec3(texcoord.st, texture2D(depthtex1, texcoord.st).r);
underwaterpos = nvec3(gbufferProjectionInverse * nvec4(underwaterpos * 2.0 - 1.0));
vec4 worldpositionuw = gbufferModelViewInverse * vec4(underwaterpos,1.0);	
vec3 wpos = (worldpositionuw.xyz + cameraPosition.xyz);

vec2 coord = (wpos.xz/20)+(movement*40);
vec2 coord1 = (wpos.xz/19.9)+(movement2*40);
vec2 coord2 = (wpos.xz/19.8)+(movement3*40);
vec2 coord3 = (wpos.xz/19.7)+(movement4*40);

float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;
noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord2.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord3.xy)).x/2.0;


float causticstrength = max((noise-1.2),0.0);
float wca = 0.7;
float caustic = (1.0 - (pow(wca,causticstrength)));
vec3 caustic_color = ivec3(0,0,0)/255.0/2.2;	//coloring caustics
vec3 wc = mix(color,caustic_color,caustic);

return wc;
}

#endif

//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////

void main() {
	
	fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));
	
	#ifndef DYNAMIC_HANDLIGHT
	handlight = 0.0;
	#endif

	float shadowexit = float(aux.g > 0.1 && aux.g < 0.3);
	float land = float(aux.g > 0.03);
	float iswater = float(aux.g > 0.04 && aux.g < 0.07);
	float translucent = float(aux.g > 0.3 && aux.g < 0.5);
	float hand = float(aux.g > 0.75 && aux.g < 0.85);
	
	vec3 color = texture2D(gcolor, texcoord.st).rgb;
	color = pow(color,vec3(2.2));
	vec4 fragposition = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f * pixeldepth - 1.0f, 1.0f);
	fragposition /= fragposition.w;
	float shading = 1.0f;
	float second_shading = 1.0f;
	float spec = 0.0;
	float time = float(worldTime);
	float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13000.0)/300.0,0.0,1.0) + clamp((time-22800.0)/200.0,0.0,1.0)-clamp((time-23400.0)/200.0,0.0,1.0));	//fading between sun/moon shadows
	float night = clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-22800.0)/200.0,0.0,1.0);
	if (land > 0.9 && isEyeInWater < 0.1) {

	float dist = length(fragposition.xyz);

	float shadingsharp = 0.0f;

	
	vec4 worldposition = vec4(0.0);
	vec4 worldpositionraw = vec4(0.0);
	
	worldposition = gbufferModelViewInverse * fragposition;	
	
	float xzDistanceSquared = worldposition.x * worldposition.x + worldposition.z * worldposition.z;
	float yDistanceSquared  = worldposition.y * worldposition.y;
	
	worldpositionraw = worldposition;

#ifdef WATER_REFRACT
	
	if (iswater > 0.9) {
	vec3 posxz = worldposition.xyz + cameraPosition.xyz;
	
	float deltaPos = 0.1;
	float h0 = waterH(posxz.xz);
	float h1 = waterH(posxz.xz + vec2(deltaPos,0.0));
	float h2 = waterH(posxz.xz + vec2(-deltaPos,0.0));
	float h3 = waterH(posxz.xz + vec2(0.0,deltaPos));
	float h4 = waterH(posxz.xz + vec2(0.0,-deltaPos));
	
	float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	float yDelta = ((h3-h0)+(h0-h4))/deltaPos;

	
	float refMult = (REFRACT_MULT/100)-dot(normal,normalize(fragposition).xyz)*0.0015;
	
	vec3 refract = normalize(vec3(xDelta,yDelta,1.0-pow(abs(xDelta+yDelta),2.0)));
	vec4 rA = texture2D(gcolor, texcoord.st + refract.xy*refMult);
	rA.rgb = pow(rA.rgb,vec3(2.2));
	vec4 rB = texture2D(gcolor, texcoord.st);
	rB.rgb = pow(rB.rgb,vec3(2.2));
	float mask = texture2D(gaux1, texcoord.st + refract.xy*refMult).g;
	mask =  float(mask > 0.04 && mask < 0.07);
	color.rgb = rA.rgb*mask + rB.rgb*(1-mask);
}

#endif

	worldposition = shadowModelView * worldposition;
	float comparedepth = -worldposition.z;
	worldposition = shadowProjection * worldposition;
	worldposition /= worldposition.w;
	
	float distb = sqrt(worldposition.x * worldposition.x + worldposition.y * worldposition.y);
	float distortFactor = (1.0f - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
	worldposition.xy *= 1.0f / distortFactor;
	worldposition = worldposition * 0.5f + 0.5f;
	int vpsize = 0;
	float diffthresh = 0.5*distortFactor+iswater+translucent;
	float isshadow = 0.0;
	float ssample;

	float distof = clamp(1.0-dist/shadowDistance,0.0,1.0);
	float distof2 = clamp(1.0-dist/(shadowDistance*0.75),0.0,1.0);
	float shadow_fade = clamp(distof*12.0,0.0,1.0);
	float sss_fade = pow(distof2,0.2);
	float step = 1.0/shadowMapResolution;
	float step2 = 40.0/shadowMapResolution;
	
		if (dist < shadowDistance) {
			
			
			if (shadowexit > 0.1) {
				shading = 1.0;
				second_shading = 1.0;
			}
			
			else {
			#ifdef SHADOW_FILTER
				for(int i = 0; i < 25; i++){
					shadingsharp += (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + circle_offsets[i]*step).z) * (256.0 - 0.05)), 0.0, diffthresh)/(diffthresh));
				}
			#endif
			
			float second_shadow = 0.0;
			
			#ifdef SHADOW_ILLUMINATION
				for(int i = 0; i < 25; i++){
					second_shading += (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + circle_offsets[i]*step2).z) * (256.0 - 0.05)), 0.0, diffthresh)/(diffthresh));
				}
				
				second_shading /= 25.0;
				second_shadow = 1.0-second_shading;
				second_shadow *= 0.15;
			#endif
			
			shadingsharp /= 25.0;
			shading = 1.0-shadingsharp+second_shadow;
			isshadow = 1.0;
			
			#ifndef SHADOW_FILTER
				shading = (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st).z) * (256.0 - 0.05)), 0.0, diffthresh)/(diffthresh));
				shading = 1.0-shading;
			#endif
			}
			
		}
	
	float ao = 1.0;
	
#ifdef SSAO
	
	if (land > 0.9 && iswater < 0.9 && hand < 0.9) {
	
	
		vec3 norm = texture2D(gnormal,texcoord.xy).rgb*2.0-1.0;
		vec3 projpos = convertScreenSpaceToWorldSpace(texcoord.xy,pixeldepth); 
		
		float progress = 0.0;
		ao = 0.0;
		
		float projrad = clamp(distance(convertCameraSpaceToScreenSpace(projpos + vec3(ssaorad,ssaorad,ssaorad)).xy,texcoord.xy),7.5*pw,60.0*pw);
		
		for (int i = 1; i < nbdir; i++) {
			for (int j = 1; j < sampledir; j++) {
				vec2 samplecoord = vec2(cos(progress),sin(progress))*(j/sampledir)*projrad + texcoord.xy;
				float sample = texture2D(depthtex0,samplecoord).x;
				vec3 sprojpos = convertScreenSpaceToWorldSpace(samplecoord,sample);
				float angle = pow(min(1.0-dot(norm,normalize(sprojpos-projpos)),1.0),2.0);
				float dist = pow(min(abs(ld(sample)-ld(pixeldepth)),0.015)/0.015,2.0);
				float temp = min(dist+angle,1.0);
				ao += pow(temp,3.0);
				//progress += (1.0-temp)/nbdir*3.14;
			}
			progress = i*1.256;
		}
		
		ao /= (nbdir-1)*(sampledir-1);
		

	
	}
		
#endif
		
	
	float sss_transparency = mix(0.0,0.75,translucent);		//subsurface scattering amount
	float sunlight_direct = 1.0;
	float direct = 1.0;
	float sss = 0.0;
	vec3 npos = normalize(fragposition.xyz);
	float NdotL = 1.0;
	
		NdotL = dot(normal, lightVector);
		direct = NdotL;
		
		sunlight_direct = max(direct,0.0);
		sunlight_direct = mix(sunlight_direct,0.75,translucent*min(sss_fade+0.4,1.0));
	
		sss += pow(max(dot(npos, lightVector),0.0),20.0)*sss_transparency*clamp(-NdotL,0.0,1.0)*translucent*4.0;

	
	
	sss = mix(0.0,sss,sss_fade);
	shading = clamp(shading,0.0,1.0);
 
		
	//Apply different lightmaps to image


		vec3 Sunlight_lightmap = sunlight_color*mix(max(sky_lightmap-rainStrength*1.0,0.0),shading*(1.0-rainStrength*1.0),shadow_fade)*((SUNLIGHTAMOUNT*eyeAdapt*((1.0-rainStrength)-(TimeMidnight-rainStrength))*2))*sunlight_direct*transition_fading ;
		
		
			/*
		float half_lambert = 1.0-sqrt(NdotL*0.5+0.5);
		float NdotUp = (dot(normal,normalize(upPosition))*0.5+0.5);
		vec3 amb = ambient_color;	
		vec3 reflected = sunlight_color*(half_lambert+(1.0-NdotUp))*0.25;
		*/
		
		float sky_inc = sqrt(direct*0.5+0.51);
		vec3 amb = (sky_inc*ambient_color+(1.0-sky_inc)*(sunlight_color+ambient_color*2.0)*vec3(0.2,0.24,0.27))*vec3(0.8,0.8,1.0);

		
		
		vec3 Torchlight_lightmap = (torch_lightmap+handlight*pow(max(3.5-length(fragposition.xyz),0.0)/7.0,2.0)*max(dot(-fragposition.xyz,normal),0.0)) *  (torchcolor*eyeAdapt);
		vec3 Torchlight_lightmap2 = (torch_lightmap2+handlight*pow(max(6.0-length(fragposition.xyz),0.0)/7.0,2.0)*max(dot(-fragposition.xyz,normal),0.0)) *  (torchcolor2*eyeAdapt);
		
		vec3 color_sunlight = Sunlight_lightmap;
		vec3 color_torchlight = Torchlight_lightmap+Torchlight_lightmap2;

		vec3 desaturate = color.rgb;
		
	#ifdef DESATURATE_NIGHT
		
		vec3 white = vec3(1.0, 1.0, 1.0);
		float dcolor = 1.0-TimeDark*0.9;
		vec3 darkness = color.rgb;
		darkness = (darkness * white);
		float l = dot(darkness, white);
		vec3 c = darkness - l;
		darkness = (c * dcolor) + l;
		desaturate = darkness;

	#endif
		
		//Add all light elements together
		color = (amb*SHADOW_darkness*sky_lightmap*ao + MIN_LIGHT*ao + color_sunlight +  sss * sunlight_color * shading *(1.0-rainStrength*0.9)*transition_fading)*desaturate + color_torchlight*ao*color;
		//color = vec3(ao);
		

#ifdef WATER_CAUSTIC

	color += waterCaustic(fragpos.xyz,color.rgb)*iswater;

#endif

#ifdef WATER_FOG

	vec3 Ufogcolor= normalize(vec3(0.0,0.0,0.0));
	vec3 Ufogcolor2= normalize(vec3(0.0,0.2,0.4));
	vec3 uPos  = nvec3(gbufferProjectionInverse * nvec4(vec3(texcoord.xy,texture2D(depthtex1,texcoord.xy).x) * 2.0 - 1.0));  //underwater position
	vec3 uVec = fragposition.xyz-uPos;
	float UNdotUP = abs(dot(normalize(uVec),normal));
	float depth = length(uVec)*UNdotUP+0.5;
	if (iswater > 0.9) color = mix(Ufogcolor*length(ambient_color)*0.04*sky_lightmap,color,exp(-depth/1.0));
	if (iswater > 0.9) color = mix(Ufogcolor2*length(ambient_color)*0.04*sky_lightmap,color,exp(-depth/10.0));
	
#endif
		
#ifdef FOG
		float fog = clamp(exp(-length(fragpos)/75)+((0.3+TimeMidnight*1)-rainStrength*(0.3-TimeMidnight)),0.0,1.0);
	    float fogfactor =  clamp(fog + hand,0.0,1.0);
	    color.rgb += mix(fogclr*(0.1-TimeMidnight)+pow(fog,1500.0)*0.2*vec3(1.0,1.0,1.0),color.rgb,fogfactor);
#endif
	}
	
	else if (isEyeInWater < 0.1){
		color = getSkyColor(fragposition.xyz);
		
	#ifdef NIGHT_STAR
		
		color = fakeStar(fragpos.xyz,color.rgb);
		
	#endif
		
	#ifdef CLOUDS
	
		color = drawCloud(fragpos.xyz,color.rgb);
		
	#ifdef VOLUMETRIC_CLOUDS
	
		color = drawCloud2(fragpos.xyz,color.rgb);
		color = drawCloud3(fragpos.xyz,color.rgb);
		color = drawCloud4(fragpos.xyz,color.rgb);
		color = drawCloud5(fragpos.xyz,color.rgb);
		
	#endif
		
	#endif
		
	#ifdef DESATURATE_NIGHT
		
		vec3 white = vec3(1.0, 1.0, 1.0);
		float dcolor = 1.0-TimeDark*0.5;
		vec3 darkness = color.rgb;
		darkness = (darkness * white);
		float l = dot(darkness, white);
		vec3 c = darkness - l;
		darkness = (c * dcolor) + l;
		color = darkness;
		
	#endif
		
		float fake_sun = max(dot(normalize(fragpos),lightVector),0.0);
		if (rainStrength < 0.99) color.rgb += pow(fake_sun,200.0+rainStrength*2800)*3.0*((vec3(1.0,1.0,1.0)-rainStrength*0.3)-TimeMidnight)*transition_fading;
		
		float fake_moon = max(dot(normalize(fragpos),lightVector),0.0);
		if (rainStrength < 0.99) color.rgb += pow(fake_moon,600.0+rainStrength*2400)*3.0*((vec3(1.0,1.0,1.0)-rainStrength*0.3)*TimeMidnight);
	}
	
/* DRAWBUFFERS:31 */

	float diffuse = max(dot(lightVector,normal),0.0);
	diffuse = mix(diffuse,1.0,translucent*0.3);
	float fresnel_pow = 5.0;
	float gfactor = 1.0;
	spec = Blinn_Phong(fragposition.xyz,lightVector,normal,fresnel_pow,gfactor,shading*diffuse) *land * (1.0-isEyeInWater)*TimeDay*transition_fading;
	//spec =  ctorspec(fragposition.xyz,lightVector,normalize(normal)) * iswater * (1.0-isEyeInWater) * shading * 0.0;
#ifdef CELSHADING
	if (land > 0.9 && iswater < 0.9) color = celshade(color);
#endif


	
	
	#ifdef GODRAYS
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos1 = tpos.xy/tpos.z;
	vec2 lightPos = pos1*0.5+0.5;
	
	float gr = 0.0;
	
	float truepos = pow(clamp(dot(-lightVector,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.5);		//temporary fix that check if the sun/moon position is correct
	
	if (truepos > 0.05) {	
		vec2 deltaTextCoord = vec2( texcoord.st - lightPos.xy );
		vec2 textCoord = texcoord.st;
		deltaTextCoord *= 1.0 /  float(NUM_SAMPLES) * density;
	
			float avgdecay = 0.0;
			float distx = abs(texcoord.x*aspectRatio-lightPos.x*aspectRatio);
			float disty = abs(texcoord.y-lightPos.y);
			vec2 noise = vec2(getnoise(textCoord),getnoise(-textCoord.yx+0.05));
			
			for(int i=0; i < NUM_SAMPLES ; i++) {			
				textCoord -= deltaTextCoord;
				float sample = step(texture2D(gaux1, textCoord+ textCoord*noise*grnoise).g,0.01);
				gr += sample;
		}
	}
	#endif

		
	color = pow(color,vec3(1.0/2.2));
	color = clamp(color,0.0,1.0);
	gl_FragData[0] = vec4(color, spec);
	gl_FragData[1] = vec4(vec3((gr/NUM_SAMPLES)),1.0);
}
