const mat3 sRGB_2_XYZ_MAT = mat3( // Linear sRGB to XYZ color space
	0.4124564, 0.3575761, 0.1804375,
	0.2126729, 0.7151522, 0.0721750,
	0.0193339, 0.1191920, 0.9503041
);

const mat3 XYZ_2_sRGB_MAT = mat3( //XYZ to linear sRGB Color Space
	3.2409699419, -1.5373831776, -0.4986107603,
	-0.9692436363,  1.8759675015,  0.0415550574,
	0.0556300797, -0.2039769589,  1.0569715142
);

const mat3 D65_2_D60_CAT = mat3( // D65 to D60 White Point
	1.01303, 0.00610531, -0.014971,
	0.00769823, 0.998165, -0.00503203,
	-0.00284131, 0.00468516, 0.924507
);

const mat3 D60_2_D65_CAT = mat3( //D60 to D65 White Point
	0.987224,   -0.00611327, 0.0159533,
	-0.00759836,  1.00186,    0.00533002,
	0.00307257, -0.00509595, 1.08168
);

const mat3 XYZ_2_AP0_MAT = mat3( // XYZ to ACEScg Color Space
	1.0498110175, 0.0000000000,-0.0000974845,
	-0.4959030231, 1.3733130458, 0.0982400361,
	0.0000000000, 0.0000000000, 0.9912520182
);

const mat3 AP0_2_XYZ_MAT = mat3( // ACEScg to XYZ Color Space
	0.9525523959, 0.0000000000, 0.0000936786,
	0.3439664498, 0.7281660966,-0.0721325464,
	0.0000000000, 0.0000000000, 1.0088251844
);

const mat3 XYZ_2_AP1_MAT = mat3( // XYZ to ACEStoning Color Space
	1.6410233797, -0.3248032942, -0.2364246952,
	-0.6636628587,  1.6153315917,  0.0167563477,
	0.0117218943, -0.0082844420,  0.9883948585
);

const mat3 AP1_2_XYZ_MAT = mat3( // ACEStoning to XYZ Color Space
	0.6624541811, 0.1340042065, 0.1561876870,
	0.2722287168, 0.6740817658, 0.0536895174,
	-0.0055746495, 0.0040607335, 1.0103391003
);

const mat3 AP0_2_AP1_MAT = mat3( // ACEScg to ACEStoneing Color Space
	1.4514393161, -0.2365107469, -0.2149285693,
	-0.0765537734,  1.1762296998, -0.0996759264,
	0.0083161484, -0.0060324498,  0.9977163014
);

const mat3 AP1_2_AP0_MAT = mat3( // ACEStoning to ACEScg Color Space
	0.6954522414,  0.1406786965,  0.1638690622,
	0.0447945634,  0.8596711185,  0.0955343182,
	-0.0055258826,  0.0040252103,  1.0015006723
);

const mat3 Wide_2_XYZ_MAT = mat3(
	0.5441691,  0.2395926,  0.1666943,
	0.2394656,  0.7021530,  0.0583814,
	-0.0023439,  0.0361834,  1.0552183
);

const mat3 XYZ_2_REC709_MAT = mat3(
     3.2409699419, -1.5373831776, -0.4986107603,
   	 -0.9692436363,  1.8759675015,  0.0415550574,
     0.0556300797, -0.2039769589,  1.0569715142
);

const mat3 XYZ_2_REC709_PRI_MAT = mat3(
     3.2409699419, -1.5373831776, -0.4986107603,
    -0.9692436363,  1.8759675015,  0.0415550574,
     0.0556300797, -0.2039769589,  1.0569715142
);

const mat3 P3D60_PRI_MAT = mat3(
	 0.68000,  0.32000, 0.26500,  
	 0.69000,  0.15000, 0.06000,
	 0.32168,  0.33767, 0.12200
);

const vec3 AP1_RGB2Y = vec3(0.2722287168, 0.6740817658, 0.0536895174); // Desaturation Coeff

const mat3 AP0_2_sRGB = (AP0_2_XYZ_MAT * D60_2_D65_CAT) * XYZ_2_sRGB_MAT;
const mat3 AP1_2_sRGB = (AP1_2_XYZ_MAT * D60_2_D65_CAT) * XYZ_2_sRGB_MAT;
	
const mat3 AP0_2_AP1 = AP0_2_XYZ_MAT * XYZ_2_AP1_MAT;
const mat3 AP1_2_AP0 = AP1_2_XYZ_MAT * XYZ_2_AP0_MAT;

const mat3 Wide_2_AP1 = Wide_2_XYZ_MAT * XYZ_2_AP1_MAT;
const mat3 ExpandMat = AP1_2_sRGB * Wide_2_AP1;

const mat3 M = mat3(0.5, -1,  0.5,
    			    -1,  1,  0.5,
           			0.5,  0,  0);

struct SplineMapPoint{
  float x;
  float y;
};

struct SegmentedSplineParams_c5{
  float coefsLow[6];    // coefs for B-spline between minPoint and midPoint (units of log luminance)
  float coefsHigh[6];   // coefs for B-spline between midPoint and maxPoint (units of log luminance)
  SplineMapPoint minPoint; // {luminance, luminance} linear extension below this
  SplineMapPoint midPoint; // {luminance, luminance} 
  SplineMapPoint maxPoint; // {luminance, luminance} linear extension above this
  float slopeLow;       // log-log slope of low linear extension
  float slopeHigh;      // log-log slope of high linear extension
};

struct SegmentedSplineParams_c9{
  float coefsLow[10];    // coefs for B-spline between minPoint and midPoint (units of log luminance)
  float coefsHigh[10];   // coefs for B-spline between midPoint and maxPoint (units of log luminance)
  SplineMapPoint minPoint; // {luminance, luminance} linear extension below this
  SplineMapPoint midPoint; // {luminance, luminance} 
  SplineMapPoint maxPoint; // {luminance, luminance} linear extension above this
  float slopeLow;       // log-log slope of low linear extension
  float slopeHigh;      // log-log slope of high linear extension
};

const SegmentedSplineParams_c5 RRT_PARAMS = {
  {-4.0000000000, -4.0000000000, -3.1573765773, -0.4852499958, 1.8477324706, 1.8477324706}, // coefsLow[6]
  {-0.7185482425, 2.0810307172, 3.6681241237, 4.0000000000, 4.0000000000, 4.0000000000}, // coefsHigh[6]
  { 0.18 * exp2(-15.0), 0.0001},    // minPoint
  { 0.18, 4.8},    // midPoint  
  { 0.18 * exp2(18.0), 10000.0},    // maxPoint
  0.0,  // slopeLow
  0.0   // slopeHigh
};

const SegmentedSplineParams_c9 ODT_48nits = {
  {-1.6989700043, -1.6989700043, -1.4779000000, -1.2291000000, -0.8648000000, -0.4480000000, 0.0051800000, 0.4511080334, 0.9113744414, 0.9113744414}, // coefsLow[10]
  {0.5154386965, 0.8470437783, 1.1358000000, 1.3802000000, 1.5197000000, 1.5985000000, 1.6467000000, 1.6746091357, 1.6878733390, 1.6878733390},   // coefsHigh[10]
  {(0.18 * exp2(-6.5)), 0.02},    // minPoint
  {(0.18), 4.8}, // midPoint  
  {(0.18 * exp2(6.5)), 48.0},    // maxPoint
  0.0,  // slopeLow
  0.04  // slopeHigh
};