const bool colortex8MipmapEnabled = true;

#if defined SHADERS_VERTEX
    out vec2 vertex_coord;

    void main(){
        vertex_coord = layout_texcoord.xy;
        gl_Position = vec4(layout_position.xy * 2.0 - 1.0, 0.0, 1.0);
    }
#elif defined SHADERS_FRAGMENT
    in vec2 vertex_coord;

    /* RENDERTARGETS:2 */
    layout (location = 0) out vec4 buffers0;

    #include "/program/shaders2/common/bloom.glsl"

    void main(){
        buffers0.xyz = bloom(vertex_coord);
        buffers0.w = 1.0;
    }
#endif