#if defined SHADERS_VERTEX
    out vec2 vertex_coord;

    #include "/program/shaders1/common/indirect/skylight.glsl"

    void main(){
        vertex_skylight();

        vertex_coord = layout_texcoord.xy;
        gl_Position = vec4(layout_position.xy * 2.0 - 1.0, 0.0, 1.0);
    }
#elif defined SHADERS_FRAGMENT
    /* RENDERTARGETS:7 */
    layout (location = 0) out vec4 buffers0;

    in vec2 vertex_coord;

    in mat3 skylight0;
    in mat3 skylight1;

    in vec3[9] ray_sh;
    in vec3[9] sky_sh;

    const bool colortex3MipmapEnabled = true;
    const bool colortex4MipmapEnabled = true;
    const bool colortex5MipmapEnabled = true;

    #include "/program/shaders1/common/atmosphere/atmosphere.glsl"
    #include "/program/shaders1/common/atmosphere/object.glsl"
    #include "/program/shaders1/common/atmosphere/planet.glsl"
    #include "/program/shaders1/common/diffuse.glsl"

    //#include "/program/shaders1/common/volumetric/volumetric_shadow.glsl"
    //#include "/program/shaders1/common/volumetric/volumetric_light.glsl"
    //#include "/program/shaders1/common/volumetric/volumetric_waterfog.glsl"

    #include "/program/shaders1/common/specular/raytrace.glsl"
    #include "/program/shaders1/common/specular/reflection.glsl"
    #include "/program/shaders1/common/specular/puddle.glsl"

    vec3 atmosphere(vec2 coord, vec3 position, vec3 sun_direction, vec3 moon_direction){
        const float lod = ATMOSPHERE_LOD;

        #if defined VOLUMETRIC_CLOUD && defined CLOUDS_SHADOW
            const float rain_brightness = 1.0;
        #else
            const float rain_brightness = mix(1.0, 0.0, wetness);
        #endif

        #if defined VOLUMETRIC_CLOUD || defined PLANAR_CLOUD
            vec4 clouds = texture2(colortex12, coord * lod);
        #else
            vec4 clouds = vec4(0.0, 0.0, 0.0, 1.0);
        #endif
        
        vec3 transmittance = texture2(colortex2, project_sphere(position)).xyz * pow4(clouds.w);
        vec3 planet_transmittance = vec3(1.0);

        #if defined OVER_WORLD
            vec3 scattering = texture2(colortex0, coord * lod).xyz;  

            #ifndef VOLUMETRIC_CLOUD
                 scattering = mix(scattering, scattering + scattering.g * 2.0, wetness);
            #endif

                 scattering = scattering * clouds.w + clouds.xyz;

            #ifdef SIXSEVEN_PLANET
                 scattering += planet(position, planet_transmittance) * transmittance * rain_brightness;
            #endif

                 scattering += transmittance * planet_transmittance * sun(position, sun_direction) * rain_brightness;
                 scattering += luminance(transmittance) * planet_transmittance * moon(position, sun_direction, moon_direction) * rain_brightness;
                 scattering += luminance(transmittance) * planet_transmittance * stars(position, moon_direction) * rain_brightness;

            return scattering;
        #elif defined END_WORLD
            vec3 scattering = vec3(0.0);

            #ifdef SIXSEVEN_PLANET
                 scattering += planet(position, planet_transmittance) * transmittance;
            #endif

                 scattering += planet_transmittance * sun(position, sun_direction);
                 scattering += planet_transmittance * stars(position, moon_direction);

            return scattering;
        #else
            return vec3(0.0);
        #endif
    }

    void refraction(inout space_position sp, materials m, inout vec2 coord, vec2 depth, vec3 normal, float ior){
        vec3 normal_flat = clamp(cross(dFdx(sp.position0), dFdy(sp.position0)), -1.0, 1.0);
             normal_flat = normalize(normal_flat);

        vec3 direction = refract(sp.vector0, normal - normal_flat, 1.0 / ior);

        float increment = distance(sp.position1, sp.position0);
              increment = saturate(increment);

        vec3 position = direction * increment + sp.position0;
             position = view_to_screenspace(position);

        float depth0 = texture2(depthtex0, position.xy).x;
        float depth1 = texture2(depthtex1, position.xy).x;

        if(depth1 > depth0 && !m.textured){
            coord = position.xy;
			
			sp.view_position1 = vec3(position.xy, depth1);
			sp.position1 = screen_to_viewspace(sp.view_position1);
			sp.inverse_position1 = view_to_worldspace(sp.position1);
			sp.vector1 = normalize(sp.position1);
			sp.inverse_vector1 = normalize(sp.inverse_position1);
        }
    }

    const vec2[4] vl_offset = vec2[4](vec2(-2.0, -2.0), vec2(0.0, -2.0), vec2(0.0, 0.0), vec2(-2.0, 0.0));

    void volumetric_filter(vec2 coord, float depth, out vec3 color0, out vec3 color1, out vec4 color2){
        const int steps = 4;
        const float lod = VL_LOD;

        float weight = 0.0;

        for(int i = 0; i < steps; ++i){
            vec2 o = coord + vl_offset[i] * inverse_texel;

            float s_depth = projection_depth(texture2(depthtex1, o).x);
                
            float w_depth = abs(depth - s_depth) * 64.0;
                  w_depth = exp2(-w_depth / depth);

            float s_length = length(vl_offset[i]);
            float w = filter_gaussian(s_length, 2.0) * max1(w_depth);

            color0 += w * texture2(colortex3, o * lod).xyz;
            color1 += w * texture2(colortex4, o * lod).xyz;
            color2 += w * texture2(colortex5, o * lod);
            weight += w;
        }

        color0 /= weight;
        color1 /= weight;
        color2 /= weight;

        //color0 = texture2(colortex3, coord * lod).xyz;
        //color1 = texture2(colortex4, coord * lod).xyz;
        //color2 = texture2(colortex5, coord * lod);
    }

    vec3 simple_fog(vec3 color, vec3 position0, vec3 position1){
        #if defined OVER_WORLD
            float density = 0.002;
        #elif defined NETHER_WORLD
            float density = 0.1;
        #endif

        float depth = distance(position0, position1) * density;

        #if defined OVER_WORLD
            depth *= 1.0 - eyeBrightnessSmooth.y / 240.0;
            depth *= float(eyeAltitude < 63.0);
        #endif

        vec3 transmittance = exp2(-srgb_to_linear(fogColor) * depth);
        vec3 scattering = (1.0 - transmittance) * 12.0;

        return color * transmittance + scattering;
    }

    void main(){    
        gbuffers g = gbuffers_data(vertex_coord);
        specular s = specular_data(g.spec, g.albedo, g.id);
        space_position sp = position(vertex_coord, g.depth, true);
        materials m = material(g.depth, g.id);

        if(!m.water) rain_puddles(sp.inverse_position1 + cameraPosition, g.normal, g.lightmap.y, s.porosity, s.roughness, s.f0);

        vec2 coord = vertex_coord;
        refraction(sp, m, coord, g.depth, g.view_normal, s.ior);

        vec2 offset = coord * texel + sin(frame_16);
        vec3 noise = rand3(offset);   

        vec3 water_scattering = vec3(0.0), water_transmittance = vec3(1.0);
        vec4 volumetric_light = vec4(0.0, 0.0, 0.0, 1.0);
        volumetric_filter(coord, projection_depth(g.depth.y), water_scattering, water_transmittance, volumetric_light);

        vec3 color = g.depth.y >= 1.0 ? atmosphere(coord, sp.inverse_vector1, sp.sun_vector, sp.moon_vector) : decodeRGBE8(texture2(colortex7, coord));
        color = color * water_transmittance + water_scattering;

        if(m.translucent || m.textured){
            g.albedo.xyz *= g.albedo.w;

            if(m.water) {
                color += vec3(0.0);
            } else {
                color *= g.albedo.xyz * (1.0 - g.albedo.w);
            }

            color += diffuse(g, s, sp, m, g.albedo.xyz, g.normal, sp.view_position0, mat2x3(sp.position0, sp.inverse_position0), mat2x3(sp.vector0, sp.inverse_vector0), noise);      
        }

        color = reflection(s, m, color, g.albedo.xyz, g.normal, sp.view_position0, sp.position0, sp.inverse_vector0, sp.moon_vector, noise, g.depth.x, g.lightmap.y);
        color = color * volumetric_light.w + volumetric_light.xyz;

        #if defined OVER_WORLD || defined NETHER_WORLD
            color = simple_fog(color, gbufferModelViewInverse[3].xyz, sp.inverse_position0);
        #endif

        color = sqrt(color);
        color = saturate_16(color);

        buffers0.xyz = color;
        buffers0.w = 1.0;
    }
#endif