#if defined SHADERS_VERTEX
    out vec2 vertex_coord;

    #include "/program/shaders1/common/indirect/skylight.glsl"

    void main(){
        vertex_skylight();

        vertex_coord = layout_texcoord.xy;
        gl_Position = vec4(layout_position.xy * 2.0 - 1.0, 0.0, 1.0);
    }
#elif defined SHADERS_FRAGMENT
    /* RENDERTARGETS:7 */
    layout (location = 0) out vec4 buffers0;

    in vec2 vertex_coord;

    in mat3 skylight0;
    in mat3 skylight1;

    in vec3[9] ray_sh;
    in vec3[9] sky_sh;
	
	const bool colortex11MipmapEnabled = true;

    #include "/program/shaders1/common/atmosphere/atmosphere.glsl"
    #include "/program/shaders1/common/diffuse.glsl"
    #include "/program/shaders1/common/specular/puddle.glsl"

    void main(){
        gbuffers g = gbuffers_data(vertex_coord);
        specular s = specular_data(g.spec, g.albedo, g.id);
        space_position sp = position(vertex_coord, g.depth, true);
        materials m = material(g.depth, g.id);

        rain_puddles(sp.inverse_position1 + cameraPosition, g.normal, g.lightmap.y, s.porosity, s.roughness, s.f0);

        vec2 offset = vertex_coord * texel + sin(frame_16);
        vec3 noise = rand3(offset);
        vec3 light = diffuse(g, s, sp, m, g.albedo.xyz, g.normal, sp.view_position1, mat2x3(sp.position1, sp.inverse_position1), mat2x3(sp.vector1, sp.inverse_vector1), noise);

        buffers0 = encodeRGBE8(light);
        buffers0 = saturate_16(buffers0);
    }
#endif