void rain_puddles(vec3 position, vec3 normal, float lightmap, float porosity, inout float roughness, inout float f0){
    lightmap = saturate(lightmap);
    lightmap = pow2(lightmap);

    vec2 pos = position.xz * 0.01;

    float noise = texture2(noisetex, pos).x;
          noise += 0.5 * texture2(noisetex, pos * 2.0).x;
          noise += 0.25 * texture2(noisetex, pos * 7.0).x;
    
    float puddle = saturate(noise / 1.2) * lightmap;
          puddle = wetness < 0.01 ? 0.0 : puddle;
          puddle *= saturate(dot(normal, vec3(0.0, 1.0, 0.0)));
          puddle *= 1.0 - (porosity * 255.0 / 64.5);
          puddle *= wetness;

    if(porosity < 64.5 / 255.0){
        roughness = mix(roughness, 0.0, puddle);
        f0 = mix(f0, 0.20, puddle);
    }
}