#if defined SHADERS_VERTEX
    out vec2 vertex_coord;
    out vec2 vertex_lightmap;
    out vec3 vertex_normal;
    out vec4 vertex_color;

    flat out float vertex_material;

    out vec3 position0;
    out vec3 position1;
    out vec3 position2;

    out mat3 tbn;

    #include "/program/shaders0/common/animation.glsl"

    vec3 curvature(vec3 position){
        atmosphere_constant ac = atmosphere_s();

        position.yx *= rotation(position.x / ac.planet_radius);
        position.yz *= rotation(position.z / ac.planet_radius);

        return position;
    }

    void main(){
        shadow_settings s = shadow_s();

        vertex_material = layout_material.x;
        vertex_coord = layout_texcoord.xy;
        vertex_lightmap = layout_lightmap.xy / 255.0;
        vertex_normal = gl_NormalMatrix * layout_normal.xyz;
        vertex_color = layout_color;

        tbn[0] = mat3(shadowModelViewInverse) * normalize(gl_NormalMatrix * (layout_tangent.xyz / layout_tangent.w));
        tbn[2] = mat3(shadowModelViewInverse) * normalize(vertex_normal);
        tbn[1] = cross(tbn[0], tbn[2]);

        position0 = trans_mad(gl_ModelViewMatrix, layout_position.xyz);
        position1 = animation(curvature(trans_mad(shadowModelViewInverse, position0)));
        position2 = position1 + cameraPosition;

        gl_Position = trans_mad(shadowModelView, position1).xyzz * diagonal4(gl_ProjectionMatrix) + gl_ProjectionMatrix[3];
        gl_Position.xyz = shadow_distortion(s, gl_Position.xyz);
    }
#elif defined SHADERS_FRAGMENT   
    in vec2 vertex_coord;
    in vec2 vertex_lightmap;
    in vec3 vertex_normal;
    in vec4 vertex_color;

    flat in float vertex_material;

    in vec3 position0;
    in vec3 position1;
    in vec3 position2;

    in mat3 tbn;

    /* RENDERTARGETS:0,1 */
    layout (location = 0) out vec4 buffers0;
    layout (location = 1) out vec4 buffers1;
    
    #include "/program/shaders0/common/material.glsl"
    #include "/program/shaders0/common/water_normal.glsl"

    float caustics(vec3 position, vec3 normal){
        vec3 sample_direction = mat3(shadowModelView) * mat3(gbufferModelViewInverse) * normalize(shadowLightPosition);
        vec3 sample_position = position + refract(sample_direction, normal, 1.0 / 1.333) * 2.5;

        float old_area = length(dFdy(position) * dFdy(position));
        float new_area = length(dFdy(sample_position) * dFdy(sample_position));
    
        #ifdef WATER_CAUSTICS
            return old_area / new_area * 0.2;
        #else
            return 1.0;
        #endif
    }

    void main(){
        float id = 1.0;
        materials(id, vertex_material);

        vec4 atlas0 = texture2(tex, vertex_coord) * vertex_color;
        vec3 normal;
        float caustic;

        if(id == 2){
            atlas0 = vec4(1.0, 1.0, 1.0, 0.0);
            normal = tbn * water_normal(position1, position2);
            caustic = caustics(position1, normal);
        } else {
            if(atlas0.w < 0.128) discard;
            normal = vertex_normal;
            caustic = 1.0;
        }

        buffers0.xyz = atlas0.xyz;
        buffers0.w = id / 255.0;
        
        buffers1.x = PackSnorm2x8(encode_unit_vector(normal) * 0.5 + 0.5);
        buffers1.z = caustic * 0.5 + 0.5;
        buffers1.w = vertex_lightmap.y * 0.5 + 0.5;
    }
#endif