float hash13(vec3 x){
    x = fract(x * 443.8975);
    x += dot(x, x.yzx + 19.19);
    return fract((x.x + x.y) * x.z);
}

vec3 hash33(vec3 q){
    uvec3 p = uvec3(ivec3(q));
          p = p * uvec3(374761393U, 1103515245U, 668265263U) + p.zxy + p.yzx;
          p = p.yzx * (p.zxy ^ (p >> 3U));

    return vec3(p ^ (p >> 16U)) * (1 / vec3(0xffffffffU));
}

float rand(vec2 x){
    return fract(sin(dot(x, vec2(12.9898, 78.233))) * 43758.5453);
}

vec2 rand2(vec2 x){
    return fract(sin(dot(x, vec2(12.9898, 78.233))) * vec2(43758.5453, 28001.8384));
}

vec3 rand3(vec2 x){
    return fract(sin(dot(x, vec2(12.9898, 78.233))) * vec3(43758.5453, 28001.8384, 50849.4141));
}

vec4 blue_noise(vec2 coord){
    vec4 noise = texture2(noisetex, (coord * texel) / noiseTextureResolution);
         noise = fract(noise + frame_16 * hpi);

    return noise;
}

float voronoi_noise(vec2 position){
    return texture2(depthtex2, fract(position * rotation(golden_angle))).x;
}

float noise_3D(vec3 position){
    float p = floor(position.z);
    float f = position.z - p;

    float noise0 = texture2(noisetex, position.xy / noiseTextureResolution + (p + 0.0) * 120.7123).x;
    float noise1 = texture2(noisetex, position.xy / noiseTextureResolution + (p + 1.0) * 120.7123).x;

    return mix(noise0, noise1, curve(f));
}

float perlin_fbm(vec3 p, int octaves){
    float a = 1.0;
    float f = 3.5;
    float n = 0.0;
    float w = 0.0;

    for(int x = 0; x < octaves; ++x){
        p.xz *= rotation(golden_angle);
        
        n += a * noise_3D(p);
        p *= f;
        a *= 0.5;
        w += a;
    }

    return n / w;
}
