float srgb_to_linear(float x){
    return x > 0.04045 ? pow(x * (1 / 1.055) + 0.0521327, 2.4) : x / 12.92;
}

vec3 srgb_to_linear(vec3 x){
    return vec3(srgb_to_linear(x.x),
                srgb_to_linear(x.y),
                srgb_to_linear(x.z));
}

float linear_to_srgb(float x){
    x = max(6.10352e-5, x);
	return min(x * 12.92, pow(max(0.00313067, x), 1.0 / 2.4) * 1.055 - 0.055);
}

vec3 linear_to_srgb(vec3 x){
    return vec3(linear_to_srgb(x.x),
                linear_to_srgb(x.y),
                linear_to_srgb(x.z));
}

vec3 gamma_to_linear(vec3 x){
    return pow(x, vec3(2.2));
}

vec3 linear_to_gamma(vec3 x){
    return pow(x, vec3(1.0 / 2.2));
}

float luminance(vec3 x){
	return dot(x, vec3(0.2126, 0.7152, 0.0722));
}

vec3 RGB_YCoCg(vec3 c){
    return vec3(c.x/4.0 + c.y/2.0 + c.z/4.0,
                c.x/2.0 - c.z/2.0,
                -c.x/4.0 + c.y/2.0 - c.z/4.0);
}

vec3 YCoCg_RGB(vec3 c){
    return saturate(vec3(c.x + c.y - c.z,
                         c.x + c.z,
                         c.x - c.y - c.z));
}

vec3 temperature_to_rgb(float temperatureInKelvins){
	vec3 retColor;
	
    temperatureInKelvins = clamp(temperatureInKelvins, 1000, 50000) / 100;
    
    if (temperatureInKelvins <= 66){
        retColor.r = 1;
        retColor.g = saturate(0.39008157876901960784 * log(temperatureInKelvins) - 0.63184144378862745098);
    } else {
    	float t = temperatureInKelvins - 60;
        retColor.r = saturate(1.29293618606274509804 * pow(t, -0.1332047592));
        retColor.g = saturate(1.12989086089529411765 * pow(t, -0.0755148492));
    }
    
    if (temperatureInKelvins >= 66)
        retColor.b = 1;
    else if(temperatureInKelvins <= 19)
        retColor.b = 0;
    else
        retColor.b = saturate(0.54320678911019607843 * log(temperatureInKelvins - 10) - 1.19625408914);

    return srgb_to_linear(retColor);
}   

vec3 plancks(in float t, in vec3 lambda) {
    const float h = 6.63e-16;
    const float c = 3.0e17;
    const float k = 1.38e-5;
    vec3 p1 = (2.0*h*pow(c, 2.0)) / pow(lambda, vec3(5.0));
    vec3 p2 = exp(h*c/(lambda*k*t))-vec3(1);
    return (p1 / p2) * pow(1e9, 2.0);
}

vec3 blackbody(in float t) {
    vec3 rgb = plancks(t, vec3(680.0, 550.0, 440.0));
         rgb = rgb / max(rgb.x, max(rgb.y, rgb.z));

    return rgb;
}