#version 330 compatibility

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/

/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////











const int 		shadowMapResolution 	= 8192;
const float 	shadowDistance 			= 180.0; // Shadow distance. Set lower if you prefer nicer close shadows. Set higher if you prefer nicer distant shadows. [80.0 120.0 180.0 240.0]
const float 	shadowIntervalSize 		= 1.0f;
const bool 		shadowHardwareFiltering0 = true;

const bool 		shadowtexMipmap = true;
const bool 		shadowtex1Mipmap = false;
const bool 		shadowtex1Nearest = false;
const bool 		shadowcolor0Mipmap = false;
const bool 		shadowcolor0Nearest = false;
const bool 		shadowcolor1Mipmap = false;
const bool 		shadowcolor1Nearest = false;

const float shadowDistanceRenderMul = 1.0f;

const int 		RGB8 					= 0;
const int 		RGBA8 					= 0;
const int 		RGBA16 					= 0;
const int 		RG16F 					= 0;
const int 		RGB16F 					= 0;
const int 		RGBA16F 				= 0;
const int 		RGBA32F 				= 0;
const int 		RG16 					= 0;
const int 		RGB16 					= 0;
const int 		R11F_G11F_B10F 			= 0;
const int 		colortex0Format 			= RGBA8;
const int 		colortex1Format 			= RGBA16;
const int 		colortex2Format 			= RGBA16;
const int 		colortex3Format 			= RGBA16;
const int 		colortex4Format 			= RGBA32F;
const int 		colortex5Format 			= RGBA32F;
const int 		colortex6Format 			= RGBA32F;
const int 		colortex7Format 			= RGBA16F;

const int 		colortex8Format 			= RGB16F;
const int 		colortex9Format 			= RG16F;
const int 		colortex10Format 			= RGBA8;

const bool colortex3Clear = false;
const bool colortex4Clear = false;
const bool colortex5Clear = false;
const bool colortex6Clear = false;
const bool colortex9Clear = false;

const int 		superSamplingLevel 		= 0;

const float		sunPathRotation 		= -40.0f;

const int 		noiseTextureResolution  = 64;

const float 	ambientOcclusionLevel 	= 0.06f;



const float wetnessHalflife = 100.0;
const float drynessHalflife = 100.0;




in vec4 texcoord;

in vec3 lightVector;
in vec3 worldLightVector;
in vec3 worldSunVector;

in float timeMidnight;

in vec3 colorSunlight;
in vec3 colorSkylight;
in vec3 colorSkyUp;
in vec3 colorTorchlight;

in vec4 skySHR;
in vec4 skySHG;
in vec4 skySHB;









#include "lib/Uniforms.inc"
#include "lib/Common.inc"
#include "lib/Materials.inc"



/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


// vec4 GetViewPosition(in vec2 coord, in float depth) 
// {	
// 	vec2 tcoord = coord;
// 	TemporalJitterProjPosInv01(tcoord);

// 	vec4 fragposition = gbufferProjectionInverse * vec4(tcoord.s * 2.0f - 1.0f, tcoord.t * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);
// 		 fragposition /= fragposition.w;

	
// 	return fragposition;
// }




/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


#include "lib/GBufferData.inc"






/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////




vec2 Texcoord;



vec3 CalculateSunlightVisibility(MaterialMask GTJIHvOSbK, vec3 worldPos, vec3 worldGeoNormal, 
	float parallaxOffset) 
{
	// if (rainStrength >= 0.99f)
		// return vec3(1.0f);




		// if (isEyeInWater > 0.5)
		// {
		// 	ssp.xy *= 0.82;
		// }




		// worldPos += worldGeoNormal * 0.04;

		if (GTJIHvOSbK.grass > 0.5)
		{
			worldGeoNormal.xyz = vec3(0, 1, 0);
		}


		float dist;
		float distortFactor;
		vec3 shadowProjPos = WorldPosToShadowProjPosBias(worldPos.xyz, worldGeoNormal, 0.002, dist, distortFactor);

		// float fademult = 0.15f;
			// shadowMult = clamp((shadowDistance * 1.4f * fademult) - (distance * fademult), 0.0f, 1.0f);	//Calculate shadowMult to fade shadows out

		float shadowMult = 1.0;

		float shading = 0.0;
		vec3 result = vec3(0.0);

		if (shadowMult > 0.0) 
		{

			float diffthresh = dist * 1.0f + 0.10f;
				  diffthresh *= 2.0f / (shadowMapResolution / 2048.0f);
			// diffthresh = 0.0;
				  //diffthresh /= shadingStruct.directionect + 0.1f;


			// shadowProjPos.xyz += shadowNormal * 0.0004 * (dist + 0.5);




			float vpsSpread = 0.105 / distortFactor;

			float avgDepth = 0.0;
			float minDepth = 11.0;
			int c;

			for (int i = -1; i <= 1; i++)
			{
				for (int j = -1; j <= 1; j++)
				{
					vec2 lookupCoord = shadowProjPos.xy + (vec2(i, j) / shadowMapResolution) * 8.0 * vpsSpread;
					//avgDepth += pow(texture2DLod(shadowtex1, lookupCoord, 2).x, 4.1);
					float depthSample = texture2DLod(shadowtex1, lookupCoord, 2).x;
					minDepth = min(minDepth, depthSample);
					avgDepth += pow(min(max(0.0, shadowProjPos.z - depthSample) * 1.0, 0.025), 2.0);
					c++;
				}
			}

			avgDepth /= c;
			avgDepth = pow(avgDepth, 1.0 / 2.0);

			// float penumbraSize = min(abs(shadowProjPos.z - minDepth), 0.15);
			float penumbraSize = avgDepth;

			//if (GTJIHvOSbK.leaves > 0.5)
			//{
				//penumbraSize = 0.02;
			//}

			int count = 0;
			float spread = penumbraSize * 0.055 * vpsSpread + 0.55 / shadowMapResolution;


			vec3 noise = BlueNoiseTemporal(Texcoord.st);

			diffthresh *= 0.5 + avgDepth * 50.0;
			// diffthresh *= 20.0;



			const int latSamples = 5;
			const int lonSamples = 5;

			// shadowProjPos.xyz += shadowNormal * diffthresh * 0.001;
			// shadowProjPos.xyz += shadowNormal * diffthresh * 0.001;

			float dfs = 0.00022 * dist + (noise.z * 0.00005) + 0.00002 + avgDepth * 0.012 + 0.0002 * parallaxOffset;

			for (int i = 0; i < 25; i++)
			{
				float fi = float(i + noise.x) * 0.1;
				float r = float(i + noise.x) * 3.14159265 * 2.0 * 1.61;

				vec2 radialPos = vec2(cos(r), sin(r));
				vec2 coordOffset = radialPos * spread * sqrt(fi) * 2.0;

				
				// shading += shadow2DLod(shadowtex0, vec3(shadowProjPos.st + coordOffset, shadowProjPos.z - 0.0012f * diffthresh - (noise.z * 0.00005)), 0).x;
				shading += shadow2DLod(shadowtex0, vec3(shadowProjPos.st + coordOffset, shadowProjPos.z - dfs), 0).x;
				count += 1;
			}
			shading /= count;

			shading = saturate(shading * (1.0 + avgDepth 
					* 5.0 
					* (1.0 / (abs(dot(worldGeoNormal, worldLightVector)) + 0.001))
					));

			result = vec3(shading);


			// stained glass shadow
			{
				float stainedGlassShadow = shadow2DLod(shadowtex0, vec3(shadowProjPos.st - vec2(0.5, 0.0), shadowProjPos.z - 0.0012 * diffthresh), 2).x;
				vec3 stainedGlassColor = texture2DLod(shadowcolor, vec2(shadowProjPos.st - vec2(0.5, 0.0)), 2).rgb;
				stainedGlassColor *= stainedGlassColor;
				result = mix(result, result * stainedGlassColor, vec3(1.0 - stainedGlassShadow));

				// result = mix(result, vec3(0.0), vec3(1.0 - stainedGlassShadow));
			}

			// CAUSTICS
			// water shadow (caustics)
			{
				// float waterDepth = abs(texture2DLod(shadowcolor1, shadowProjPos.st - vec2(0.0, 0.5), 4).x * 256.0 - (worldPos.y + cameraPosition.y));
				float waterDepth = abs(texture2DLod(shadowcolor1, shadowProjPos.st - vec2(0.0, 0.5), 3).x * 256.0 - (worldPos.y + cameraPosition.y));

				// float caustics = GetCausticsDeferred(worldPos, waterDepth);
				vec3 caustics = vec3(0.0);
				caustics.r = GetCausticsDeferred(worldPos, 										worldLightVector, waterDepth);
				// caustics.g = GetCausticsDeferred(worldPos + vec3(0.003 * waterDepth, 0.0, 0.0), worldLightVector, waterDepth);
				// caustics.b = GetCausticsDeferred(worldPos + vec3(0.006 * waterDepth, 0.0, 0.0), worldLightVector, waterDepth);
				caustics.g = caustics.r;
				caustics.b = caustics.r;

				float waterShadow = shadow2DLod(shadowtex0, vec3(shadowProjPos.st - vec2(0.0, 0.5), shadowProjPos.z - 0.0012 * diffthresh - noise.z * 0.0001), 3).x;
				result = mix(result, 
					// result * caustics * exp(-GetWaterAbsorption() * waterDepth), 
					result * caustics, 
					vec3(1.0 - waterShadow));
			}
		}



		result = mix(vec3(1.0), result, shadowMult);





		return result;
	//} else {
	//	return vec3(0.0f);
	//}
}


vec3 SubsurfaceScatteringSunlight(vec3 worldNormal, vec3 worldPos, vec3 albedo)
{
	vec4 shadowProjPos = shadowModelView * vec4(worldPos.xyz, 1.0);	//Transform from world space to shadow space
	shadowProjPos = shadowProjection * shadowProjPos;
	shadowProjPos /= shadowProjPos.w;

	float dist = sqrt(shadowProjPos.x * shadowProjPos.x + shadowProjPos.y * shadowProjPos.y);
	float distortFactor = (1.0f - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
	shadowProjPos.xy *= 0.95f / distortFactor;
	shadowProjPos.z = mix(shadowProjPos.z, 0.5, 0.8);
	shadowProjPos = shadowProjPos * 0.5f + 0.5f;		//Transform from shadow space to shadow map coordinates


	shadowProjPos.xyz = FinalShadowProjectionTransformation(shadowProjPos.xyz);


	float subsurfaceDepth = 0.0;
	float depthThresh = 0.0005;
	float weights = 0.0;

	vec2 dither = BlueNoiseTemporal(Texcoord.st).xy - 0.5;

	for (int i = -1; i <= 1; i++)
	{
		for (int j = -1; j <= 1; j++)
		{
			vec2 coordOffset = vec2(i + dither.x, j + dither.y) * 0.001;
			subsurfaceDepth += max(0.0, (shadowProjPos.z - texture2DLod(shadowtex1, shadowProjPos.xy + coordOffset, 0).x) / depthThresh);
			weights += 1.0;
		}
	}

	subsurfaceDepth /= weights;

	// subsurfaceDepth = exp(-subsurfaceDepth * 10.0);

	vec3 subsurfaceColor = 1.0 - (normalize(albedo.rgb + 0.000001) * 0.3);
	// vec3 subsurfaceColor = 1.0 - (albedo.rgb * 0.5);
	// vec3 subsurfaceColor = 1.0 - (albedo.rgb * 0.8);
	// vec3 subsurfaceColor = 1.0 - vec3(0.7, 0.5, 0.1);
	vec3 sss = exp(-subsurfaceDepth * subsurfaceColor * 6.0) * (1.0 - subsurfaceColor);

	return sss * 24.0 * colorSunlight;
}


float ScreenSpaceShadow(vec3 origin, float depth, vec3 viewDir, vec3 normal, MaterialMask GTJIHvOSbK)
{
	if (GTJIHvOSbK.sky > 0.5)
	{
		return 1.0;
	}
	


	float fov = 2.0*atan( 1.0/gbufferProjection[1][1] ) * 180.0 / 3.14159265;

	vec3 rayPos = origin;
	vec3 rayDir = lightVector 
		* -origin.z
		* 0.000035 * fov
		;


	float NdotL = saturate(dot(lightVector, normal));

	if (GTJIHvOSbK.grass < 0.5 && GTJIHvOSbK.leaves < 0.5) 
	{
		rayPos += normal * 0.00001 * -origin.z * fov * 0.15;
		rayPos += rayDir * 13000.0 * min(ScreenTexel.x, ScreenTexel.y) * 0.15;
		// rayPos += rayDir * 2.0;
	}


	float randomness = rand(Texcoord.st + sin(frameTimeCounter)).x;


	float zThickness = 0.025 * -origin.z;
	float shadow = 1.0;
	float numSamplesf = 64.0;
	int numSamples = int(numSamplesf);
	float absorption = 0.0;
	if (GTJIHvOSbK.grass > 0.5)
	{
		absorption = 0.5;
	}
	if (GTJIHvOSbK.leaves > 0.5)
	{
		absorption = 0.85;
	}
	absorption = pow(absorption, sqrt(length(origin)) * 0.5);



	float ds = 1.0;
	for (int i = 0; i < 12; i++)
	{
		float fi = float(i) / float(12);
		
		rayPos += rayDir * ds;
		ds += 0.3;

		vec3 thisRayPos = rayPos + rayDir * randomness * ds;

		vec2 rayProjPos = ProjectBack(thisRayPos).xy;

		rayProjPos *= 0.5;
		TemporalJitterProjPos01(rayProjPos);
		rayProjPos *= 2.0;
		
		vec3 samplePos = GetViewPositionNoJitter(rayProjPos.xy, GetDepth(DownscaleTexcoord(rayProjPos.xy))).xyz; // half res rendering fix

		float depthDiff = samplePos.z - thisRayPos.z;

		if (depthDiff > 0.0 && depthDiff < zThickness
		)
		{
			shadow *= absorption;
		}
	}

	return shadow;




































}


float OrenNayar(vec3 normal, vec3 eyeDir, vec3 lightDir)
{
	const float PI = 3.14159;
	const float roughness = 0.55;

	// interpolating normals will change the length of the normal, so renormalize the normal.



	// normal = normalize(normal + surface.lightVector * pow(clamp(dot(eyeDir, surface.lightVector), 0.0, 1.0), 5.0) * 0.5);

	// normal = normalize(normal + eyeDir * clamp(dot(normal, eyeDir), 0.0f, 1.0f));

	// calculate intermediary values
	float NdotL = dot(normal, lightDir);
	float NdotV = dot(normal, eyeDir);

	float angleVN = acos(NdotV);
	float angleLN = acos(NdotL);

	float alpha = max(angleVN, angleLN);
	float beta = min(angleVN, angleLN);
	float gamma = dot(eyeDir - normal * dot(eyeDir, normal), lightDir - normal * dot(lightDir, normal));

	float roughnessSquared = roughness * roughness;

	// calculate A and B
	float A = 1.0 - 0.5 * (roughnessSquared / (roughnessSquared + 0.57));

	float B = 0.45 * (roughnessSquared / (roughnessSquared + 0.09));

	float C = sin(alpha) * tan(beta);

	// put it all together
	float L1 = max(0.0, NdotL) * (A + B * max(0.0, gamma) * C);

	//return max(0.0f, surface.NdotL * 0.99f + 0.01f);
	return clamp(L1, 0.0f, 1.0f);
}





float GetCoverage(in float coverage, in float density, in float clouds)
{
	clouds = clamp(clouds - (1.0f - coverage), 0.0f, 1.0f -density) / (1.0f - density);
		clouds = max(0.0f, clouds * 1.1f - 0.1f);
	 clouds = clouds = clouds * clouds * (3.0f - 2.0f * clouds);
	 // clouds = pow(clouds, 1.0f);
	return clouds;
}

float   CalculateSunglow(vec3 npos, vec3 lightVector) {

	float curve = 4.0f;

	vec3 halfVector2 = normalize(-lightVector + npos);
	float factor = 1.0f - dot(halfVector2, npos);

	return factor * factor * factor * factor;
}

float G1V(float dotNV, float k)
{
	return 1.0 / (dotNV * (1.0 - k) + k);
}

vec3 SpecularGGX(vec3 N, vec3 V, vec3 L, float roughness, float F0)
{
	float alpha = roughness * roughness;

	vec3 H = normalize(V + L);

	float dotNL = saturate(dot(N, L));
	float dotNV = saturate(dot(N, V));
	float dotNH = saturate(dot(N, H));
	float dotLH = saturate(dot(L, H));

	float F, D, vis;

	float alphaSqr = alpha * alpha;
	float pi = 3.14159265359;
	float denom = dotNH * dotNH * (alphaSqr - 1.0) + 1.0;
	D = alphaSqr / (pi * denom * denom);

	float dotLH5 = pow(1.0f - dotLH, 5.0);
	F = F0 + (1.0 - F0) * dotLH5;

	float k = alpha / 2.0;
	vis = G1V(dotNL, k) * G1V(dotNV, k);

	vec3 specular = vec3(dotNL * D * F * vis) * colorSunlight;

	//specular = vec3(0.1);
	#ifndef PHYSICALLY_BASED_MAX_ROUGHNESS
	specular *= saturate(pow(1.0 - roughness, 0.7) * 2.0);
	#endif


	return specular;
}




 const float x=1./float(8192);
 ivec2 v=ivec2(viewWidth,viewHeight),s=ivec2(6144,6144);
 int z=v.x*v.y,i=37748736;
 int f(int v)
 {
   return v-FloorToInt(mod(float(v),2.))-0;
 }
 int t(int v)
 {
   return v-FloorToInt(mod(float(v),2.))-1;
 }
 int f()
 {
   return f(FloorToInt(floor(pow(float(z),.333333))));
 }
 int t()
 {
   return t(FloorToInt(floor(pow(float(i),.333333))));
 }
 int y=f();
 float m=1./y;
 int n=t();
 float G=1./n;
 vec3 d(vec2 n)
 {
   ivec2 s=ivec2(n.x*v.x,n.y*v.y);
   float x=float(s.y/y),i=float(int(s.x+mod(v.x*x,y))/y);
   i+=floor(v.x*x/y);
   vec3 f=vec3(0.,0.,i);
   f.x=mod(s.x+mod(v.x*x,y),y);
   f.y=mod(s.y,y);
   f.xyz=floor(f.xyz);
   f/=y;
   f.xyz=f.xzy;
   return f;
 }
 vec2 r(vec3 n)
 {
   vec3 f=n.xzy*y;
   f=floor(f+1e-05);
   float x=f.z;
   vec2 i;
   i.x=mod(f.x+x*y,v.x);
   float s=f.x+x*y;
   i.y=f.y+floor(s/v.x)*y;
   i+=.5;
   i/=v;
   return i;
 }
 vec3 e(vec2 v)
 {
   vec2 i=v;
   i.xy/=.75;
   int x=s.x*s.y;
   ivec2 f=ivec2(i.x*s.x,i.y*s.y);
   float z=float(f.y/n),y=float(int(f.x+mod(s.x*z,n))/n);
   y+=floor(s.x*z/n);
   vec3 m=vec3(0.,0.,y);
   m.x=mod(f.x+mod(s.x*z,n),n);
   m.y=mod(f.y,n);
   m.xyz=floor(m.xyz);
   m/=n;
   m.xyz=m.xzy;
   return m;
 }
 vec2 p(vec3 v)
 {
   v=clamp(v,vec3(0.),vec3(1.));
   vec3 f=v.xzy*n;
   f=floor(f+1e-05);
   float x=f.z;
   vec2 i;
   i.x=mod(f.x+x*n,s.x);
   float z=f.x+x*n;
   i.y=f.y+floor(z/s.x)*n;
   i+=.5;
   i/=s;
   i.xy*=.75;
   return i;
 }
 const int c=384,w=c/2-64;
 int h=(c-n)/2;
 float F=floor(cameraPosition.y+.5),K=clamp(F,w-h,w-h),l=F-K;
 vec3 a(vec3 v)
 {
   return v.y+=l,v*=G,v=v+vec3(.5),v;
 }
 vec3 T(vec3 v)
 {
   return v=a(v),v=clamp(v,vec3(0.),vec3(1.)),v;
 }
 vec3 g(vec3 v)
 {
   return v=v-vec3(.5),v*=n,v.y-=l,v;
 }
 vec3 B(vec3 v)
 {
   return v*=m,v=v+vec3(.5),v=clamp(v,vec3(0.),vec3(1.)),v;
 }
 vec3 H(vec3 v)
 {
   return v=v-vec3(.5),v*=y,v;
 }
 vec3 B()
 {
   vec3 v=cameraPosition.xyz+.5,x=previousCameraPosition.xyz+.5,i=floor(v-.0001),y=floor(x-.0001);
   return i-y;
 }
 vec3 B(vec3 v,vec3 f,vec2 s,vec2 z,vec4 i,vec4 o,inout float x,out vec2 n)
 {
   bool y=fract(v.x*2.)>.01&&fract(v.x*2.)<.99||fract(v.y*2.)>.01&&fract(v.y*2.)<.99||fract(v.z*2.)>.01&&fract(v.z*2.)<.99;
   y=!y;
   if(o.x==8||o.x==9||o.x==79||o.x<1.||!y||o.x==20.||o.x==171.||min(abs(f.x),abs(f.z))>.2)
     x=1.;
   if(o.x==50.||o.x==48.||o.x>=44&&o.x<48||o.x==49.||o.x==52.||o.x==76.)
     {
       x=0.;
       if(f.y<.5)
         x=1.;
     }
   if(o.x==54)
     x=0.;
   if(o.x==51||o.x==53||o.x==55)
     x=0.;
   if(o.x>255)
     x=0.;
   vec3 r,c;
   if(f.x>.5)
     r=vec3(0.,0.,-1.),c=vec3(0.,-1.,0.);
   else
      if(f.x<-.5)
       r=vec3(0.,0.,1.),c=vec3(0.,-1.,0.);
     else
        if(f.y>.5)
         r=vec3(1.,0.,0.),c=vec3(0.,0.,1.);
       else
          if(f.y<-.5)
           r=vec3(1.,0.,0.),c=vec3(0.,0.,-1.);
         else
            if(f.z>.5)
             r=vec3(1.,0.,0.),c=vec3(0.,-1.,0.);
           else
              if(f.z<-.5)
               r=vec3(-1.,0.,0.),c=vec3(0.,-1.,0.);
   n=clamp((s.xy-z.xy)*100000.,vec2(0.),vec2(1.));
   float G=.15,K=.15;
   if(o.x==10.||o.x==11.)
     G=.1,K=.1,x=0.;
   if(o.x==51||o.x==55||o.x==53)
     G=.5,K=.1;
   if(o.x==76)
     G=.2,K=.2;
   if(o.x-255.+39.>=103.&&o.x-255.+39.<=113.)
     K=.025,G=.025;
   r=normalize(i.xyz);
   c=normalize(cross(r,f.xyz)*sign(i.w));
   vec3 m=v.xyz+mix(r*G,-r*G,vec3(n.x));
   m.xyz+=mix(c*G,-c*G,vec3(n.y));
   m.xyz-=f.xyz*K;
   return m;
 }struct TOuWFelenO{vec3 FjeDDzWIWi;vec3 FjeDDzWIWiOrigin;vec3 gjulCSuvVu;vec3 ihCMMEIfgL;vec3 HHiebGwFJJ;vec3 GTJIHvOSbK;};
 TOuWFelenO S(Ray v)
 {
   TOuWFelenO f;
   f.FjeDDzWIWi=floor(v.origin);
   f.FjeDDzWIWiOrigin=f.FjeDDzWIWi;
   f.gjulCSuvVu=abs(vec3(length(v.direction))/(v.direction+1e-07));
   f.ihCMMEIfgL=sign(v.direction);
   f.HHiebGwFJJ=(sign(v.direction)*(f.FjeDDzWIWi-v.origin)+sign(v.direction)*.5+.5)*f.gjulCSuvVu;
   f.GTJIHvOSbK=vec3(0.);
   return f;
 }
 void b(inout TOuWFelenO v)
 {
   v.GTJIHvOSbK=step(v.HHiebGwFJJ.xyz,v.HHiebGwFJJ.yzx)*step(v.HHiebGwFJJ.xyz,v.HHiebGwFJJ.zxy),v.HHiebGwFJJ+=v.GTJIHvOSbK*v.gjulCSuvVu,v.FjeDDzWIWi+=v.GTJIHvOSbK*v.ihCMMEIfgL;
 }
 vec3 B(const vec3 v,const vec3 z,vec3 f)
 {
   vec3 x=(z+v)*.5,y=(z-v)*.5,s=f-x,i=abs(s);
   i/=y;
   vec3 K=step(i.yzx,i.xyz)*step(i.zxy,i.xyz);
   return K*sign(s);
 }
 bool B(const vec3 v,const vec3 f,Ray i,inout float x,inout vec3 z)
 {
   vec3 y=i.inv_direction*(v-1e-05-i.origin),s=i.inv_direction*(f+1e-05-i.origin),o=min(s,y),c=max(s,y);
   vec2 r=max(o.xx,o.yz);
   float n=max(r.x,r.y);
   r=min(c.xx,c.yz);
   float m=min(r.x,r.y);
   bool K=m>max(n,0.)&&max(n,0.)<x;
   if(K)
     z=B(v,f,i.origin+i.direction*n),x=n;
   return K;
 }
 float P(vec3 v)
 {
   return 1.;
 }struct eAMCZAKEcI{float nrlJXyapkV;float vPMmNoxUfq;float QQevGhUGeB;float VSCbvpIaKi;vec3 vyHfppOAPK;};
 vec4 V(eAMCZAKEcI v)
 {
   vec4 i;
   v.vyHfppOAPK=max(vec3(0.),v.vyHfppOAPK);
   i.x=v.nrlJXyapkV;
   v.vyHfppOAPK=pow(v.vyHfppOAPK,vec3(.125));
   i.y=PackTwo16BitTo32Bit(v.vyHfppOAPK.x,v.QQevGhUGeB);
   i.z=PackTwo16BitTo32Bit(v.vyHfppOAPK.y,v.VSCbvpIaKi);
   i.w=PackTwo16BitTo32Bit(v.vyHfppOAPK.z,v.vPMmNoxUfq/255.);
   return i;
 }
 eAMCZAKEcI R(vec4 v)
 {
   eAMCZAKEcI i;
   vec2 f=UnpackTwo16BitFrom32Bit(v.y),o=UnpackTwo16BitFrom32Bit(v.z),s=UnpackTwo16BitFrom32Bit(v.w);
   i.nrlJXyapkV=v.x;
   i.QQevGhUGeB=f.y;
   i.VSCbvpIaKi=o.y;
   i.vPMmNoxUfq=s.y*255.;
   i.vyHfppOAPK=pow(vec3(f.x,o.x,s.x),vec3(8.));
   return i;
 }
 eAMCZAKEcI W(vec2 v)
 {
   return v=(floor(v*ScreenSize)+.5)*ScreenTexel,R(texture2DLod(colortex5,v,0));
 }
 vec3 B(vec3 v,vec3 z)
 {
   vec3 f=B(g(v)+z+1.+B());
   float x=P(f);
   vec2 i=r(f);
   vec3 y=W(i).vyHfppOAPK;
   return y*x;
 }
 vec3 H(vec3 v,vec3 z)
 {
   vec3 f=B(g(v)+z+1.);
   float x=P(f);
   vec2 i=r(f);
   vec3 y=W(i).vyHfppOAPK;
   return y*x;
 }
 float P(float v,float z)
 {
   float x=1.;
   #ifdef FULL_RT_REFLECTIONS
   x=clamp(pow(v,.125)+z,0.,1.);
   #else
   x=clamp(v*10.-7.,0.,1.);
   #endif
   return x;
 }
 bool B(vec3 v,float x,Ray i,bool z,inout float f,inout vec3 y)
 {
   bool m=false,r=false;
   #if RAYTRACE_GEOMETRY_QUALITY==0
   if(z)
     return false;
   if(x>=67.)
     return false;
   r=B(v,v+vec3(1.,1.,1.),i,f,y);
   m=r;
   #else
   if(x<40.)
     return r=B(v,v+vec3(1.,1.,1.),i,f,y),r;
   if(x==40.||x==41.||x>=43.&&x<=54.)
     {
       float c=.5;
       if(x==41.)
         c=.9375;
       r=B(v+vec3(0.,0.,0.),v+vec3(1.,c,1.),i,f,y);
       m=m||r;
     }
   if(x==42.||x>=55.&&x<=66.)
     r=B(v+vec3(0.,.5,0.),v+vec3(1.,1.,1.),i,f,y),m=m||r;
   if(x==43.||x==46.||x==47.||x==52.||x==53.||x==54.||x==55.||x==58.||x==59.||x==64.||x==65.||x==66.)
     {
       float c=.5;
       if(x==55.||x==58.||x==59.||x==64.||x==65.||x==66.)
         c=0.;
       r=B(v+vec3(0.,c,0.),v+vec3(.5,.5+c,.5),i,f,y);
       m=m||r;
     }
   if(x==43.||x==45.||x==48.||x==51.||x==53.||x==54.||x==55.||x==57.||x==60.||x==63.||x==65.||x==66.)
     {
       float c=.5;
       if(x==55.||x==57.||x==60.||x==63.||x==65.||x==66.)
         c=0.;
       r=B(v+vec3(.5,c,0.),v+vec3(1.,.5+c,.5),i,f,y);
       m=m||r;
     }
   if(x==44.||x==45.||x==49.||x==51.||x==52.||x==54.||x==56.||x==57.||x==61.||x==63.||x==64.||x==66.)
     {
       float c=.5;
       if(x==56.||x==57.||x==61.||x==63.||x==64.||x==66.)
         c=0.;
       r=B(v+vec3(.5,c,.5),v+vec3(1.,.5+c,1.),i,f,y);
       m=m||r;
     }
   if(x==44.||x==46.||x==50.||x==51.||x==52.||x==53.||x==56.||x==58.||x==62.||x==63.||x==64.||x==65.)
     {
       float c=.5;
       if(x==56.||x==58.||x==62.||x==63.||x==64.||x==65.)
         c=0.;
       r=B(v+vec3(0.,c,.5),v+vec3(.5,.5+c,1.),i,f,y);
       m=m||r;
     }
   if(x>=67.&&x<=82.)
     r=B(v+vec3(6.,0.,6.)/16.,v+vec3(10.,16.,10.)/16.,i,f,y),m=m||r;
   if(x==68.||x==69.||x==70.||x==72.||x==73.||x==74.||x==76.||x==77.||x==78.||x==80.||x==81.||x==82.)
     {
       float c=8.,s=8.;
       if(x==68.||x==70.||x==72.||x==74.||x==76.||x==78.||x==80.||x==82.)
         c=0.;
       if(x==69.||x==70.||x==73.||x==74.||x==77.||x==78.||x==81.||x==82.)
         s=16.;
       r=B(v+vec3(c,6.,7.)/16.,v+vec3(s,9.,9.)/16.,i,f,y);
       m=m||r;
       r=B(v+vec3(c,12.,7.)/16.,v+vec3(s,15.,9.)/16.,i,f,y);
       m=m||r;
     }
   if(x>=71.&&x<=82.)
     {
       float c=8.,n=8.;
       if(x>=71.&&x<=74.||x>=79.&&x<=82.)
         n=16.;
       if(x>=75.&&x<=82.)
         c=0.;
       r=B(v+vec3(7.,6.,c)/16.,v+vec3(9.,9.,n)/16.,i,f,y);
       m=m||r;
       r=B(v+vec3(7.,12.,c)/16.,v+vec3(9.,15.,n)/16.,i,f,y);
       m=m||r;
     }
   #if RAYTRACE_GEOMETRY_QUALITY==2
   if(x>=83.&&x<=86.)
     {
       vec3 c=vec3(0),s=vec3(0);
       if(x==83.)
         c=vec3(0,0,0),s=vec3(16,16,3);
       if(x==84.)
         c=vec3(0,0,13),s=vec3(16,16,16);
       if(x==86.)
         c=vec3(0,0,0),s=vec3(3,16,16);
       if(x==85.)
         c=vec3(13,0,0),s=vec3(16,16,16);
       r=B(v+c/16.,v+s/16.,i,f,y);
       m=m||r;
     }
   if(x>=87.&&x<=102.)
     {
       vec3 c=vec3(0.),s=vec3(1.);
       if(x>=87.&&x<=94.)
         {
           float n=0.;
           if(x>=91.&&x<=94.)
             n=13.;
           c=vec3(0.,n,0.)/16.;
           s=vec3(16.,n+3.,16.)/16.;
         }
       if(x>=95.&&x<=98.)
         {
           float n=13.;
           if(x==97.||x==98.)
             n=0.;
           c=vec3(0.,0.,n)/16.;
           s=vec3(16.,16.,n+3.)/16.;
         }
       if(x>=99.&&x<=102.)
         {
           float n=13.;
           if(x==99.||x==100.)
             n=0.;
           c=vec3(n,0.,0.)/16.;
           s=vec3(n+3.,16.,16.)/16.;
         }
       r=B(v+c,v+s,i,f,y);
       m=m||r;
     }
   if(x>=103.&&x<=113.)
     {
       vec3 c=vec3(0.),s=vec3(1.);
       if(x>=103.&&x<=110.)
         {
           float n=float(x)-float(103.)+1.;
           s.y=n*2./16.;
         }
       if(x==111.)
         s.y=.0625;
       if(x==112.)
         c=vec3(1.,0.,1.)/16.,s=vec3(15.,1.,15.)/16.;
       if(x==113.)
         c=vec3(1.,0.,1.)/16.,s=vec3(15.,.5,15.)/16.;
       r=B(v+c,v+s,i,f,y);
       m=m||r;
     }
   #endif
   #endif
   return m;
 }
 float B(vec3 v,vec3 y,int i,const int z)
 {
   Ray x=MakeRay(v,y);
   TOuWFelenO f=S(x);
   float r=1.,c=100000.;
   vec3 n=vec3(0.);
   for(int m=0;m<z;m++)
     {
       vec3 s=f.FjeDDzWIWi*G;
       vec2 K=p(s);
       vec4 o=texture2DLod(shadowcolor,K,0);
       float w=o.w*255.;
       if(abs(w-36.)<.1||abs(w-38.)<.1)
         {
           continue;
         }
       if(w<240.)
         {
           if(B(f.FjeDDzWIWi,w,x,m==0,c,n))
             {
               r=0.;
               break;
             }
         }
       b(f);
     }
   const float s=z*.33;
   r=mix(r,1.,saturate(c-s));
   return r;
 }
 vec3 L(vec3 v)
 {
   vec4 x=vec4(v,1.);
   x=shadowModelView*x;
   x=shadowProjection*x;
   x/=x.w;
   float c=sqrt(x.x*x.x+x.y*x.y),y=1.f-SHADOW_MAP_BIAS+c*SHADOW_MAP_BIAS;
   x.xy*=.95f/y;
   x.z=mix(x.z,.5,.8);
   x=x*.5f+.5f;
   x.xyz=FinalShadowProjectionTransformation(x.xyz);
   return x.xyz;
 }
 vec3 H(vec3 v,vec3 f,vec3 i,vec3 y,vec3 z,int n)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v-=Fract01(cameraPosition+.5);
   float c,x;
   vec3 s=WorldPosToShadowProjPosBias(v,y,.004,c,x),r=vec3(1.)*shadow2DLod(shadowtex0,vec3(s.xy,s.z),1).x;
   r*=saturate(dot(i,y));
   r*=B(f+y*.01,i,n,3);
   {
     vec4 o=texture2DLod(shadowcolor1,s.xy-vec2(0.,.5),3);
     float m=abs(o.x*256.-(v.y+cameraPosition.y)),G=GetCausticsComposite(v,i,m),K=shadow2DLod(shadowtex0,vec3(s.xy-vec2(0.,.5),s.z+1e-06),3).x;
     r=mix(r,r*G,1.-K);
   }
   r=TintUnderwaterDepth(r);
   return r*(1.-rainStrength);
 }
 vec3 L(vec3 v,vec3 f,vec3 i,vec3 y,vec3 z,int n)
 {
   if(rainStrength>.99)
     return vec3(0.);
   vec3 x=g(v);
   x+=1.;
   x-=Fract01(cameraPosition+.5);
   float c,s;
   vec3 o=WorldPosToShadowProjPosBias(x+y*.99,y,.004,c,s),r=vec3(1.)*shadow2DLod(shadowtex0,vec3(o.xy,o.z),1).x;
   r*=saturate(dot(i,y));
   r*=B(f+y*.99,i,n,3);
   r=TintUnderwaterDepth(r);
   #ifdef GI_SUNLIGHT_STAINED_GLASS_TINT
   float m=shadow2DLod(shadowtex0,vec3(o.xy-vec2(.5,0.),o.z),3).x;
   vec3 G=texture2DLod(shadowcolor,vec2(o.xy-vec2(.5,0.)),3).xyz;
   G*=G;
   r=mix(r,r*G,vec3(1.-m));
   #endif
   return r*(1.-rainStrength);
 }
 vec3 P(vec3 v,vec3 f,vec3 i,vec3 y,vec3 z,int n)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   float c,s;
   vec3 x=WorldPosToShadowProjPosBias(v,y,.004,c,s);
   float r=.5;
   vec3 m=vec3(1.)*shadow2DLod(shadowtex0,vec3(x.xy,x.z-.0006*r),2).x;
   m*=saturate(dot(i,y));
   m*=B(f+y*.01,i,n,3);
   m=TintUnderwaterDepth(m);
   #ifdef GI_SUNLIGHT_STAINED_GLASS_TINT
   float K=shadow2DLod(shadowtex0,vec3(x.xy-vec2(.5,0.),x.z-.0006*r),3).x;
   vec3 G=texture2DLod(shadowcolor,vec2(x.xy-vec2(.5,0.)),3).xyz;
   G*=G;
   m=mix(m,m*G,vec3(1.-K));
   #endif
   return m*(1.-rainStrength);
 }
 vec3 D(vec2 v)
 {
   vec2 x=vec2(v.xy*vec2(viewWidth,viewHeight));
   x*=1./64.;
   const vec2 f[16]=vec2[16](vec2(-1,-1),vec2(0,-.333333),vec2(-.5,.333333),vec2(.5,-.777778),vec2(-.75,-.111111),vec2(.25,.555556),vec2(-.25,-.555556),vec2(.75,.111111),vec2(-.875,.777778),vec2(.125,-.925926),vec2(-.375,-.259259),vec2(.625,.407407),vec2(-.625,-.703704),vec2(.375,-.037037),vec2(-.125,.62963),vec2(.875,-.481482));
   if(v.x<2./viewWidth||v.x>1.-2./viewWidth||v.y<2./viewHeight||v.y>1.-2./viewHeight)
     ;
   else
      x+=f[frameCounter/2%16]*.5;
   x=(floor(x*64.)+.5)/64.;
   vec3 i=texture2D(noisetex,x).xyz,c=vec3(sqrt(.2),sqrt(2.),1.61803);
   i=mod(i+float(frameCounter%2)*.5,vec3(1.));
   return i;
 }
 vec3 Q(vec3 v)
 {
   float x=fract(frameCounter*.0123456);
   vec3 c=BlueNoiseTemporal(Texcoord.xy).xyz,y=BlueNoiseTemporal(Texcoord.xy+.1).xyz,s=v,i=Fract01(cameraPosition.xyz+.5)+vec3(0.,0.,0.),r=i;
   i=T(i);
   Ray f=MakeRay(i*n-vec3(1.),s);
   vec3 m=vec3(1.),z=vec3(0.);
   float K=100000.;
   vec3 w=vec3(1.);
   for(int e=0;e<1;e++)
     {
       vec3 o=vec3(floor(f.origin)),l=abs(vec3(length(f.direction))/(f.direction+.0001)),Y=sign(f.direction),d=(sign(f.direction)*(o-f.origin)+sign(f.direction)*.5+.5)*l,t;
       vec4 F=vec4(0.);
       vec3 h=vec3(0.);
       float V=.5;
       for(int R=0;R<190;R++)
         {
           h=o*G;
           vec2 H=p(h);
           F=texture2DLod(shadowcolor,H,0);
           float g=F.w*255.;
           if(g<240.)
             {
               if(B(o,g,f,R==0,K,w))
                 {
                   break;
                 }
             }
           t=step(d.xyz,d.yzx)*step(d.xyz,d.zxy);
           d+=t*l;
           o+=t*Y;
           V=1.;
         }
     }
   z*=1.;
   return z;
 }
 vec3 D(vec3 v,vec3 y)
 {
   v+=Fract01(cameraPosition.xyz+.5)-.5;
   vec3 x=B(v+y*.1);
   float c=P(x);
   vec3 z=W(r(x)).vyHfppOAPK;
   return z*c;
 }
 vec3 D(vec2 v,vec3 i,float f,vec3 y)
 {
   vec3 x=texture2DLod(colortex7,v+vec2(0.,HalfScreen.y),0).xyz;
   return x;
 }
 void main()
 {
   Texcoord=texcoord.xy;
   GBufferData v=GetGBufferData(Texcoord);
   MaterialMask x=CalculateMasks(v.materialID,Texcoord);
   vec4 f=GetViewPosition(Texcoord.xy,v.depth),s=gbufferModelViewInverse*vec4(f.xyz,1.),i=gbufferModelViewInverse*vec4(f.xyz,0.);
   vec3 c=normalize(f.xyz),y=normalize(i.xyz),r=normalize((gbufferModelViewInverse*vec4(v.normal,0.)).xyz),z=normalize((gbufferModelViewInverse*vec4(v.geoNormal,0.)).xyz);
   float m=length(f.xyz);
   vec3 n=vec3(0.),o=r;
   if(x.grass>.5)
     r=vec3(0.,1.,0.);
   #ifdef VISUALIZE_DANGEROUS_LIGHT_LEVEL
   {
     float K=BlockLightTorchLinear(v.mcLightmap.x)*16.;
     K=K;
     float G=K<=.75?1.:0.;
     vec3 d=(s.xyz+cameraPosition.xyz)*.5+FRAME_TIME*.4;
     float w=G*step(.8,mod(dot(d,vec3(1.,1.,1.)),1.)),l=G*step(.9,mod(dot(d,vec3(1.,1.,1.)),1.));
     v.albedo.xyz*=mix(vec3(1.),vec3(0.,0.,0.),vec3(w*.8));
     v.albedo.xyz=mix(v.albedo.xyz,vec3(1.,0.,0.),vec3(l*.8));
   }
   #endif
   vec3 K=D(Texcoord.xy,v.normal,v.depth,f.xyz)*10.,G=K*v.albedo.xyz;
   n.xyz=G+v.albedo.xyz*8e-07;
   #ifdef HELD_LIGHT
   {
     float w=float(heldBlockLightValue+heldBlockLightValue2)/16.,l=OrenNayar(o,-y,-y),Y=1./(dot(i.xyz,i.xyz)+.3);
     n+=v.albedo.xyz*w*Y*l*colorTorchlight*.3;
   }
   #endif
   float w=24.*(1.-sqrt(wetness)),l=dot(r,worldLightVector),d=OrenNayar(r,-y,worldLightVector);
   if(x.leaves>.5)
     d=mix(d,.5,.5);
   if(x.grass>.5)
     v.metalness=0.;
   vec3 Y=CalculateSunlightVisibility(x,s.xyz,z,v.parallaxOffset);
   #ifdef LIGHT_LEAK_FIX
   float F=saturate(v.mcLightmap.y*100.);
   if(isEyeInWater<1)
     Y*=F;
   #endif
   {
     Y*=ScreenSpaceShadow(f.xyz,v.depth,c.xyz,v.geoNormal.xyz,x);
     float e=1.;
     {
       int h=t();
       vec3 R=s.xyz+z*(.0002*length(s.xyz))-y*(v.parallaxOffset*.2/(saturate(dot(z,-y))+1e-06)+.005);
       R+=Fract01(cameraPosition.xyz+.5);
       vec3 H=normalize(worldLightVector+BlueNoiseTemporal(texcoord.xy)*.1);
       e=B(T(R)*h-vec3(1.,1.,1.),H,h,3);
     }
     Y*=e;
   }
   n+=TintUnderwaterDepth(DoNightEyeAtNight(d*v.albedo.xyz*Y*w*colorSunlight,timeMidnight));
   vec3 e=SpecularGGX(r,-y,worldLightVector,1.-v.smoothness,v.metalness*.96+.04)*w*Y;
   e*=mix(vec3(1.),v.albedo.xyz,vec3(v.metalness));
   e*=mix(1.,.5,x.grass);
   if(isEyeInWater<.5)
     n*=1.-P(v.smoothness,v.metalness)*v.metalness,n+=DoNightEyeAtNight(e,timeMidnight);
   if(x.sky>.5||v.depth>1.)
     {
       vec3 h=y.xyz;
       if(isEyeInWater>0)
         h.xyz=refract(h.xyz,vec3(0.,-1.,0.),1.2533);
       vec3 R=SkyShading(h.xyz,worldSunVector.xyz,rainStrength);
       n=R;
       vec3 H=AtmosphereAbsorption(h.xyz,AtmosphereExtent);
       n+=v.albedo.xyz*H*.2;
       n+=RenderSunDisc(h,worldSunVector,colorSunlight)*H*2000.;
       CloudPlane(n,-h,worldLightVector,worldSunVector,colorSunlight,colorSkyUp,R,timeMidnight,true);
     }
   if(x.glowstone>.5)
     n.xyz+=v.albedo.xyz*GI_LIGHT_BLOCK_INTENSITY;
   if(x.torch>.5)
     n.xyz+=v.albedo.xyz*pow(length(v.albedo.xyz),2.)*.5*GI_LIGHT_TORCH_INTENSITY;
   if(x.candle>.5)
     n.xyz+=v.albedo.xyz*2.*GI_LIGHT_TORCH_INTENSITY*KelvinToRGB(5000);
   if(x.glowBerries>.5)
     n+=GetGlowBerryColor(s.xyz+cameraPosition.xyz)*saturate(dot(saturate(v.albedo.xyz-.1),vec3(1.,-.6,-.99)))*7.;
   if(x.endRod>.5)
     n.xyz+=v.albedo.xyz*4.*GI_LIGHT_TORCH_INTENSITY;
   if(x.glowLichen>.5)
     n.xyz+=vec3(.007,.0044,.0012)*pow(saturate(dot(v.albedo.xyz,vec3(1.,1.,-1.99))),2.)*380.;
   if(x.seaPickle>.5)
     n.xyz+=v.albedo.xyz*70.*vec3(.04,.045,.05)*GI_LIGHT_TORCH_INTENSITY;
   if(x.lava>.5)
     n+=v.albedo.xyz*.75*GI_LIGHT_BLOCK_INTENSITY;
   if(x.fire>.5)
     n+=v.albedo.xyz*3.*GI_LIGHT_TORCH_INTENSITY;
   if(x.litFurnace>.5)
     {
       float H=saturate(v.albedo.x-(v.albedo.y+v.albedo.z)*.5-.2);
       n+=v.albedo.xyz*H*2.*GI_LIGHT_TORCH_INTENSITY*vec3(1.,.175,.0125);
     }
   NetherFog(n,length(f.xyz));
   n*=.001;
   n=LinearToGamma(n);
   gl_FragData[0]=vec4(n.xyz,1.);
 };




/* DRAWBUFFERS:1 */
