## Basic Guidelines
   Important standards that must be followed when contributing to this project.

### Testing
   Do not submit your pull request without testing the shader.

### Optimization
   Optimize your code wherever possible, leave comments when necessary.

### Compatibility
   If you're making a pull request for mod compatibility, make sure your fix follow the above guidelines.

### Translation
   For translation, it should be based from the latest commit to ensure compatibility and avoid conflicts, and that another person fluent for the language you're translating to should verify the final product. Please also keep the same text format as the main language file [en_US](/lang/en_US.lang).

   If you're updating an existing translation, the same rules will apply unless someone is already working on it. If that were the case, please communicate with the user working on the translation before making a pull request.
   
## Style guidelines
* No spaces around parentheses: `if(condition){`, `this = function()`
* Use `camelCase` on everything, including constants.
* Use `SCREAMING_CASE` for defined macros only.
* When commenting, leave a space after `//` or `/*`: `// This is a comment.`, `/* Explain your code here. */`

## Miscellaneous
   You may add your name in [**CONTRIBUTORS**](CONTRIBUTORS.md) under the contributers list with your PR. If you're a translator, add your name in [**TRANSLATORS**](TRANSLATORS.md) under the translators list.

## TO DO: (for Eldeston)
   Update the descriptions of this file.
   Make a separate file for translation.
