#version 120


/*
		@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
		@##############################################################@	
		@#															  #@
		@#		[][][][][] [][][][][] [][][][][] [][][][][] []   	  #@
		@#		[]	  	       []     []      [] []	     [] []        #@
		@#		[]	 	       []     []      [] []	     [] []  	  #@
		@#		[]		       []     []      [] []	     [] []     	  #@
		@#		[][][][][]     []     []      [] [][][][][] []   	  #@
		@#				[]     []     []      [] []	        []        #@
		@#				[]     []     []      [] []	        []        #@
		@#				[]     []     []      [] []	           		  #@
		@#		[][][][][]     []     [][][][][] []	        []        #@
		@#															  #@
		@##############################################################@
		@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
		
		
		BEFORE DO ANYTHING, READ THIS AGREEMENT FIRST :
		
		
		YOU ARE ALLOWED TO :
		
		- Make videos or pictures with my shaderpack
		- Modify it only for yourself
		- Earn money with it from your YouTube Videos
		- Share my shaderpack link
		
		YOU ARE NOT ALLOWED TO :
		
		- Rename it and claim my shaderpack as your own
		- Publish your modifications
*/

#define MAX_COLOR_RANGE 48.0
/*
!! DO NOT REMOVE !!
Werrus shaders, derived from Chocapic13 V5TEST_FIX1.
This code is from Chocapic13' shaders.
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES

	//#define GODRAYS							//in this step previous godrays result is blurred
		const float exposure = 4.0;			//godrays intensity 15.0 is default
		const float density = 1.0;			
		const int NUM_SAMPLES = 7;			//increase this for better quality at the cost of performance /8 is default
		const float grnoise = 0.0;			//amount of noise /0.0 is default
		
	//#define WATER_REFLECTIONS
		#define FAKE_WATER_REFLECTIONS	//only reflect sky
	
	//#define RAIN_REFLECTIONS				//still WIP

	//#define HD_CLOUDS						//make clouds looks 3D
	#define NIGHT_STAR						//enable sparkling stars on night time sky
	//#define NIGHT_GALAXY					//enable galaxy view on night time sky (combine it with NIGHT_STAR to make it better)
	
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES


//don't touch these lines if you don't know what you do!
const int maxf = 4;				//number of refinements
const float stp = 1.2;			//size of one step for raytracing algorithm
const float ref = 0.1;			//refinement multiplier
const float inc = 2.2;			//increasement factor at each step

//ground constants (lower quality)
const int Gmaxf = 3;				//number of refinements
const float Gstp = 1.2;			//size of one step for raytracing algorithm
const float Gref = 0.11;			//refinement multiplier
const float Ginc = 3.0;			//increasement factor at each step

varying vec4 texcoord;

varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;

varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 ambient_color;

varying float eyeAdapt;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D composite;
uniform sampler2D gaux1;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D gnormal;
uniform sampler2D gdepth;
uniform sampler2D noisetex;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;
uniform vec3 skyColor;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;

uniform int isEyeInWater;
uniform int worldTime;
uniform float far;
uniform float near;
uniform float aspectRatio;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float matflag = texture2D(gaux1,texcoord.xy).g;

vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);
vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0;
vec3 aux = texture2D(gaux1, texcoord.st).rgb;

float time = float(worldTime);
float night = clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-22800.0)/200.0,0.0,1.0);

float timefract = float(worldTime);

float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0-(clamp(timefract, 0.0, 6000.0)/6000.0));	  
float TimeNoon     = ((clamp(timefract, 0.0, 6000.0)) / 6000.0) - ((clamp(timefract, 6000.0, 12000.0) - 6000.0) / 6000.0);  
float TimeSunset   = ((clamp(timefract, 6000.0, 12000.0) - 6000.0) / 6000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);		  
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);
float TimeDark = ((clamp(timefract, 13000.0, 13750.0) - 13000.0) / 750.0) - ((clamp(timefract, 22000.0, 23000.0) - 22000.0) / 1000.0);
float TimeChanging = (((clamp(timefract, 12000.0, 13000.0) - 12000.0) / 1000.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0))-TimeDark;

float sky_lightmap = texture2D(gaux1,texcoord.xy).r;

float wet_area = pow(aux.r,1.45);
float wet_ground = clamp(wetness, 0.0f, 1.0f)/1.0f;

vec4 color = texture2D(composite,texcoord.xy);


vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}

vec3 getSkyColor(vec3 fposition) {
//sky gradient
/*----------*/
vec3 sky_color = vec3(0.2, 0.5, 1.0)*TimeSunrise + vec3(0.2, 0.5, 1.0)*TimeNoon + vec3(0.2, 0.5, 1.0)*TimeSunset + vec3(0.4, 0.2, 0.1)*TimeMidnight;
vec3 nsunlight = normalize(pow(sunlight,vec3(2.2)));
vec3 sVector = normalize(fposition);

sky_color = normalize(mix(sky_color,vec3(0.25,0.3,0.4)*length(ambient_color),rainStrength)); //normalize colors in order to don't change luminance

float Lz = 1.0;
float cosT = dot(sVector,upVec); 
float absCosT = max(cosT,0.0);
float cosS = dot(sunVec,upVec);
float S = acos(cosS);				
float cosY = dot(sunVec,sVector);
float Y = acos(cosY);				
float a = -1.0;
float b = -0.2;
float c = 1.0;
float d = -0.1;
float e = 1.0;

//sun sky color
float L =  (1+a*exp(b/(absCosT+0.01)))*(1+c*eyeAdapt*exp(d*Y)+e*cosY*cosY); 
L = pow(L,1.0-rainStrength*0.8)*(1.0-rainStrength*0.2); //modulate intensity when raining
vec3 skyColorSun = mix(sky_color, nsunlight,1-exp(-0.19*L*(1-rainStrength*0.8)))*L*0.5 ; //affect color based on luminance (0% physically accurate)
skyColorSun *= sunVisibility;

//moon sky color
float McosS = MdotU;
float MS = acos(McosS);
float McosY = dot(moonVec,sVector);
float MY = acos(McosY);

float L2 =  (1+a*exp(b/(absCosT+0.01)))*(1+c*exp(d*MY)+e*McosY*McosY);
L2 = pow(L2,1.0-rainStrength*0.8)*(1.0-rainStrength*0.2); //modulate intensity when raining
vec3 skyColormoon = mix(moonlight,normalize(vec3(0.25,0.3,0.4))*length(moonlight),rainStrength)*L2*0.4 ; //affect color based on luminance (0% physically accurate)
skyColormoon *= moonVisibility;

sky_color = skyColormoon*2.0+skyColorSun;
//sky_color = vec3(Lc);
/*----------*/
return sky_color;
}


vec3 drawSun(vec3 fposition,vec3 color,int land) {
vec3 sVector = normalize(fposition);

float angle = (1-max(dot(sVector,sunVec),0.0))*200.0;
float sun = exp(-angle*angle);
sun *= land*(1-rainStrength*0.)*sunVisibility;
vec3 sunlight = mix(sunlight,vec3(0.25,0.3,0.4)*length(ambient_color)*4.,rainStrength*0.8);

return mix(color,sunlight*(100.-rainStrength*100),sun);

}

vec3 calcFog(vec3 fposition, vec3 color, vec3 fogclr) {
	const float density = 5000.0;
	const float start = 0.05;
	float fog = min(exp(-length(fposition)/density/(sunVisibility*6.7+1.3)*1.5)+start*(1-rainStrength),1.0);
	
	vec3 c = mix(color*normalize(fogclr)*(1/sqrt(3.)),color,fog);
	vec3 fc = fogclr*((100.5-rainStrength*50)-TimeMidnight*(50-rainStrength*20));
	return mix(fc,c,fog);
}

float getAirDensity (float h) {
return min((pow((max((h),58.0)-58.0)/30.,2.0)*20.0+10.0),35.0);
}

vec3 calcFog2(vec3 fposition, vec3 color, vec3 fogclr) {
	float density = (500. + max(500,0.0))*(1+rainStrength*0.1);
	vec3 worldpos = (gbufferModelViewInverse*vec4(fposition,1.0)).rgb+cameraPosition;
	
	float d = length(fposition);
	float height = getAirDensity (worldpos.y)*3;
	float fog =   clamp(24.0*exp(-getAirDensity (-cameraPosition.y)/density) * (1.0-exp( -d*height/density ))/height-0.3+rainStrength*0.25,0.0,0.6+rainStrength*.4);
	return mix(color,fogclr*mix(sunlight*vec3(0.35,0.4,0.5)*1.5,vec3(1.0),max(moonVisibility*(1-sunVisibility),rainStrength)),fog);	
}

#ifdef WATER_REFLECTIONS

vec4 raytrace(vec3 fragpos, vec3 normal,vec3 fogclr) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
	
	//far black dots fix
	vec4 wrv = (gbufferModelViewInverse*vec4(rvector,1.0));
	wrv.y *= sign(dot(upVec,rvector));
	rvector = normalize((gbufferModelView*wrv).rgb);
	
    vec3 vector = stp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
    for(int i=0;i<40;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
        if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = abs(fragpos.z-spos.z);
if(err < pow(length(vector)*1.85,1.15)){
	
                sr++;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 20.0), 0.0, 1.0);
                    color = texture2D(composite, pos.st);
					float land = texture2D(gaux1, pos.st).g;
					land = float(land < 0.03);
					spos.z = mix(fragpos.z,2000.0*(0.4+sunVisibility*0.6),land);
					color.rgb = calcFog(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE,fogclr);
					color.a = 1.0;
                    color.a *= border;
                    break;
                }
				tvector -=vector;
                vector *=ref;
				
        
}
        vector *= inc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }
    return color;
}	

#endif

float subSurfaceScattering(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos)),0.0),N)*(N+1)/6.28;

}
float subSurfaceScattering2(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos))*0.5+0.5,0.0),N)*(N+1)/6.28;

}

vec3 drawCloud(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float McosY = MdotU;
float cosY = SdotU;
//cloud generation
/*----------*/
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(1.5/(wVector.y));

	vec2 wind = vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
	
	vec3 wpos = tpos.xyz+cameraPosition;
	vec2 coord = (intersection.xz+wind*10)/512.0;
	vec2 coord1 = (intersection.xz+wind*30)/512.0;
	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;

	  float N = 8.0;
vec3 cloud_color = (ambient_color + mix(sunlight,length(sunlight)*-vec3(0.9,0.9,0.9),rainStrength)*sunVisibility + mix(moonlight,length(moonlight)*-vec3(0.5,0.5,0.5),rainStrength) * moonVisibility) * 0.12 *density + (24.*subSurfaceScattering(sunVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(sunVec,fragpos,0.1)*pow(density,3.))*mix(sunlight,length(sunlight)*vec3(0.0,0.0,0.0),rainStrength)*sunVisibility +  (24.*subSurfaceScattering(moonVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(moonVec,fragpos,0.1)*pow(density,3.))*mix(moonlight,length(moonlight)*vec3(0.0,0.0,0.0),rainStrength)*moonVisibility;	//coloring clouds

	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord1.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord1.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord1.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord1.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord1.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord1.xy*64.0)).x/128.0;

	float cl = max(noise-(1.5-rainStrength*0.2),0.0);

	float ef = 0.75;
	float density = max(1-cl*1.0,0.)*max(1-cl*1.0,0.);
	float cloud2 = (1.0 - (pow(ef,cl)))*max(cosT,0.0);
	
#ifdef HD_CLOUDS
	
	cloud2 = (1.0 - (pow(ef,cl)))*max(cosT,0.0)*density;

#endif
	
vec3 c = mix(color,cloud_color,cloud2);

return c;
}

#ifdef HD_CLOUDS

vec3 drawCloud2(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float McosY = MdotU;
float cosY = SdotU;
//cloud generation
/*----------*/
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(1.47/(wVector.y));

	vec2 wind = vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
	
	vec3 wpos = tpos.xyz+cameraPosition;
	vec2 coord = (intersection.xz+wind*10)/512.0;
	vec2 coord1 = (intersection.xz+wind*30)/512.0;
	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;

	  float N = 8.0;
vec3 cloud_color = (ambient_color + mix(sunlight,length(sunlight)*-vec3(0.9,0.9,0.9),rainStrength)*sunVisibility + mix(moonlight,length(moonlight)*-vec3(0.5,0.5,0.5),rainStrength) * moonVisibility) * 0.12 *density + (24.*subSurfaceScattering(sunVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(sunVec,fragpos,0.1)*pow(density,3.))*mix(sunlight,length(sunlight)*vec3(0.0,0.0,0.0),rainStrength)*sunVisibility +  (24.*subSurfaceScattering(moonVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(moonVec,fragpos,0.1)*pow(density,3.))*mix(moonlight,length(moonlight)*vec3(0.0,0.0,0.0),rainStrength)*moonVisibility;	//coloring clouds

	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord1.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord1.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord1.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord1.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord1.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord1.xy*64.0)).x/128.0;

	float cl = max(noise-(1.6-rainStrength*0.2),0.0);

	float ef = 0.75;
	float density = max(1-cl*1.0,0.)*max(1-cl*1.0,0.);
	float cloud2 = (1.0 - (pow(ef,cl)))*max(cosT,0.0)*density;

vec3 c = mix(color,cloud_color,cloud2);

return c;
}

vec3 drawCloud3(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float McosY = MdotU;
float cosY = SdotU;
//cloud generation
/*----------*/
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(1.44/(wVector.y));

	vec2 wind = vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
	
	vec3 wpos = tpos.xyz+cameraPosition;
	vec2 coord = (intersection.xz+wind*10)/512.0;
	vec2 coord1 = (intersection.xz+wind*30)/512.0;
	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;

	  float N = 8.0;
vec3 cloud_color = (ambient_color + mix(sunlight,length(sunlight)*-vec3(0.9,0.9,0.9),rainStrength)*sunVisibility + mix(moonlight,length(moonlight)*-vec3(0.5,0.5,0.5),rainStrength) * moonVisibility) * 0.12 *density + (24.*subSurfaceScattering(sunVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(sunVec,fragpos,0.1)*pow(density,3.))*mix(sunlight,length(sunlight)*vec3(0.0,0.0,0.0),rainStrength)*sunVisibility +  (24.*subSurfaceScattering(moonVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(moonVec,fragpos,0.1)*pow(density,3.))*mix(moonlight,length(moonlight)*vec3(0.0,0.0,0.0),rainStrength)*moonVisibility;	//coloring clouds

	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord1.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord1.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord1.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord1.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord1.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord1.xy*64.0)).x/128.0;

	float cl = max(noise-(1.7-rainStrength*0.2),0.0);

	float ef = 0.75;
	float density = max(1-cl*1.0,0.)*max(1-cl*1.0,0.);
	float cloud2 = (1.0 - (pow(ef,cl)))*max(cosT,0.0)*density;

vec3 c = mix(color,cloud_color,cloud2);

return c;
}

vec3 drawCloud4(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float McosY = MdotU;
float cosY = SdotU;
//cloud generation
/*----------*/
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(1.41/(wVector.y));

	vec2 wind = vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
	
	vec3 wpos = tpos.xyz+cameraPosition;
	vec2 coord = (intersection.xz+wind*10)/512.0;
	vec2 coord1 = (intersection.xz+wind*30)/512.0;
	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;

	  float N = 8.0;
vec3 cloud_color = (ambient_color + mix(sunlight,length(sunlight)*-vec3(0.9,0.9,0.9),rainStrength)*sunVisibility + mix(moonlight,length(moonlight)*-vec3(0.5,0.5,0.5),rainStrength) * moonVisibility) * 0.12 *density + (24.*subSurfaceScattering(sunVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(sunVec,fragpos,0.1)*pow(density,3.))*mix(sunlight,length(sunlight)*vec3(0.0,0.0,0.0),rainStrength)*sunVisibility +  (24.*subSurfaceScattering(moonVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(moonVec,fragpos,0.1)*pow(density,3.))*mix(moonlight,length(moonlight)*vec3(0.0,0.0,0.0),rainStrength)*moonVisibility;	//coloring clouds

	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord1.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord1.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord1.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord1.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord1.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord1.xy*64.0)).x/128.0;

	float cl = max(noise-(1.8-rainStrength*0.2),0.0);

	float ef = 0.75;
	float density = max(1-cl*1.0,0.)*max(1-cl*1.0,0.);
	float cloud2 = (1.0 - (pow(ef,cl)))*max(cosT,0.0)*density;

vec3 c = mix(color,cloud_color,cloud2);

return c;
}

vec3 drawCloud5(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float McosY = MdotU;
float cosY = SdotU;
//cloud generation
/*----------*/
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(1.38/(wVector.y));

	vec2 wind = vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
	
	vec3 wpos = tpos.xyz+cameraPosition;
	vec2 coord = (intersection.xz+wind*10)/512.0;
	vec2 coord1 = (intersection.xz+wind*30)/512.0;
	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;

	  float N = 8.0;
vec3 cloud_color = (ambient_color + mix(sunlight,length(sunlight)*-vec3(0.9,0.9,0.9),rainStrength)*sunVisibility + mix(moonlight,length(moonlight)*-vec3(0.5,0.5,0.5),rainStrength) * moonVisibility) * 0.12 *density + (24.*subSurfaceScattering(sunVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(sunVec,fragpos,0.1)*pow(density,3.))*mix(sunlight,length(sunlight)*vec3(0.0,0.0,0.0),rainStrength)*sunVisibility +  (24.*subSurfaceScattering(moonVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(moonVec,fragpos,0.1)*pow(density,3.))*mix(moonlight,length(moonlight)*vec3(0.0,0.0,0.0),rainStrength)*moonVisibility;	//coloring clouds

	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord1.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord1.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord1.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord1.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord1.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord1.xy*64.0)).x/128.0;

	float cl = max(noise-(1.9-rainStrength*0.2),0.0);

	float ef = 0.75;
	float density = max(1-cl*1.0,0.)*max(1-cl*1.0,0.);
	float cloud2 = (1.0 - (pow(ef,cl)))*max(cosT,0.0)*density;

vec3 c = mix(color,cloud_color,cloud2);

return c;
}

#endif

#ifdef NIGHT_STAR

vec3 nightStar(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float McosY = MdotU;
float cosY = SdotU;
//star generation
/*----------*/
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(50.0/(wVector.y));



//float canHit = length(intersection)-length(tpos);

	vec2 wind = vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
	
	
	vec3 wpos = tpos.xyz+cameraPosition;
	intersection.xz = intersection.xz + 5.0*cosT*intersection.xz;		//curve the star pattern, because sky is not 100% plane in reality
	vec2 coord = (intersection.xz+wind*10)/512.0;
	vec2 coord1 = (intersection.xz+wind*10)/512.0;
	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;

	  float N = 8.0;
vec3 star_color = vec3(1.0, 1.0, 1.0)*1.0*moonVisibility*(1-rainStrength) + moonlight*48.0*pow(max(McosY,0.0),N)*(N+1)/6.28  * (1-rainStrength)*moonVisibility ;	//coloring stars
/*----------*/

	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;

	float cl = max(noise-1.7,0.0);
	float ef = 0.01;
 
      float star2 = (1.0 - (pow((1-rainStrength*0.9)*ef,cl)))*max(cosT,0.0);
	  
	  
vec3 s = mix(color,star_color,star2);



//s = mix(s,star_color,star);  //mix up sky color and stars



return s;
}

#endif

#ifdef NIGHT_GALAXY

vec3 galaxy(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(0.2/(wVector.y));



//float canHit = length(intersection)-length(tpos);

	vec2 movement = vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
	vec2 movement2 = vec2(-abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
	vec2 movement3 = vec2(-abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5));
	vec2 movement4 = vec2(abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5));
	
	vec3 wpos = tpos.xyz+cameraPosition;
	intersection.xz = intersection.xz + 5.0*cosT*intersection.xz;		//curve the pattern, because sky is not 100% plane in reality
	vec2 coord = (intersection.xz+(movement*10))/512;
	vec2 coord1 = (intersection.xz+(movement2*10))/512;
	vec2 coord2 = (intersection.xz+(movement3*10))/512;
	vec2 coord3 = (intersection.xz+(movement4*10))/512;
	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;

	  float N = 8.0;
vec3 galaxy_color = moonlight*50.0*moonVisibility*(1-rainStrength);	//coloring galaxy
/*----------*/

	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord1.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord1.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord1.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord1.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord2.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord2.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord2.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord2.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord2.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord3.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord3.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord3.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord3.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord3.xy*16.0)).x/32.0;


	float cl = max(noise-0.9,0.0);
	float ef = 0.9;
 
      float galaxy2 = (1.0 - (pow((1-rainStrength*0.9)*ef,cl)))*max(cosT,0.0);
	  
	  
vec3 g = mix(color,galaxy_color,galaxy2);



//g = mix(g,galaxy_color,galaxy);  //mix up sky color and galaxy



return g;
}

#endif

#ifdef RAIN_REFLECTIONS

vec4 raytraceGround(vec3 fragpos, vec3 normal, vec3 fogclr) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = Gstp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
    for(int i=0;i<30;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
		if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = distance(fragpos.xyz,spos.xyz);
        if(err < length(vector)){

                sr++;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 20.0), 0.0, 1.0);
                    color = texture2D(composite, pos.st);
					float land = texture2D(gaux1, pos.st).g;
					land = float(matflag < 0.03);
					spos.z = mix(fragpos.z,2000.0*(0.25+sunVisibility*0.75),land);
					color.rgb = calcFog(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE,fogclr);
					color.a = 1.0;
                    color.a *= border;
                    break;
                }
				tvector -=vector;
                vector *=Gref;
				
        
}
        vector *= Ginc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }
    return color;
}

#endif

vec3 underwaterFog (float depth,vec3 color) {
	const float density = 100.0;
	float fog = exp(-depth/density);
	vec3 Ucolor= normalize(pow(vec3(0.0,0.1,0.1),vec3(2.2)))*(sqrt(3.0));
	
	vec3 c = mix(color*Ucolor,color,fog);
	vec3 fc = Ucolor*length(ambient_color)*0.01;
	return mix(fc,c,fog);
}

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
	color.rgb = pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE;
	int land = int(matflag < 0.03);
	int iswater = int(matflag > 0.04 && matflag < 0.07);
	int hand  = int(matflag > 0.75 && matflag < 0.85);
	
	fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));
	vec3 uPos  = nvec3(gbufferProjectionInverse * nvec4(vec3(texcoord.xy,texture2D(depthtex1,texcoord.xy).x) * 2.0 - 1.0));		//underwater position
	float cosT = dot(normalize(fragpos),upVec);
	color.rgb = drawSun(fragpos,color.rgb,land);
	vec3 fogclr = getSkyColor(fragpos.xyz);
	uPos.z = mix(uPos.z,2000.0*(0.25+sunVisibility*0.75),land);
		float normalDotEye = dot(normal, normalize(fragpos));
		float fresnel = pow(1.0 + normalDotEye, 10.0);
		fresnel = mix(1.,fresnel,0.98);
		
#ifdef WATER_REFLECTIONS
		
	if (iswater > 0.9) {

	
		vec3 lc = mix(vec3(0.0),sunlight,sunVisibility);
		vec4 reflection = vec4(0.0);
		vec3 npos = normalize(fragpos);
		vec3 reflectedVector = reflect(normalize(fragpos), normalize(normal));
		reflectedVector = fragpos + reflectedVector * (2048.0-fragpos.z);
		vec3 skyc = getSkyColor(reflectedVector);
		vec3 sky_color = calcFog(reflectedVector,drawCloud(reflectedVector,vec3(0.0))*5,skyc*(0.5-TimeMidnight*0.46))*clamp(sky_lightmap*2.0-2/16.0,0.0,1.0);
#ifdef HD_CLOUDS
		sky_color = calcFog(reflectedVector,drawCloud(reflectedVector,drawCloud2(reflectedVector,drawCloud3(reflectedVector,drawCloud4(reflectedVector,drawCloud5(reflectedVector,vec3(0.0))))))*5,skyc*(0.5-TimeMidnight*0.46))*clamp(sky_lightmap*2.0-2/16.0,0.0,1.0);
#endif
		
		reflection = raytrace(fragpos, normal,sky_color);
		reflection.rgb = mix(sky_color, reflection.rgb, reflection.a)+(color.a)*lc*(1.0-rainStrength)*64.0;			//fake sky reflection, avoid empty spaces
		reflection.a = min(reflection.a,1.0);
		reflection.rgb = reflection.rgb*1.0;
		color.rgb = fresnel*reflection.rgb + (1-fresnel)*color.rgb;
    }
	
#endif

#ifdef FAKE_WATER_REFLECTIONS

	if (iswater > 0.9 && isEyeInWater == 0) {

	
		vec3 lc = mix(vec3(0.0),sunlight,sunVisibility);
		vec4 reflection = vec4(0.0);
		vec3 npos = normalize(fragpos);
		vec3 reflectedVector = reflect(normalize(fragpos), normalize(normal));
		reflectedVector = fragpos + reflectedVector * (2048.0-fragpos.z);
		vec3 skyc = getSkyColor(reflectedVector);
		vec3 sky_color = calcFog(reflectedVector,drawCloud(reflectedVector,vec3(0.0))*5,skyc*(0.5-TimeMidnight*0.46))*clamp(sky_lightmap*2.0-2/16.0,0.0,1.0);
#ifdef HD_CLOUDS
		sky_color = calcFog(reflectedVector,drawCloud(reflectedVector,drawCloud2(reflectedVector,drawCloud3(reflectedVector,drawCloud4(reflectedVector,drawCloud5(reflectedVector,vec3(0.0))))))*5,skyc*(0.5-TimeMidnight*0.46))*clamp(sky_lightmap*2.0-2/16.0,0.0,1.0);
#endif
		
		reflection = vec4(0.0);
		reflection.rgb = mix(sky_color, reflection.rgb, reflection.a)+(color.a)*lc*(1.0-rainStrength)*64.0;			//fake sky reflection, avoid empty spaces
		reflection.a = min(reflection.a,1.0);
		reflection.rgb = reflection.rgb*1.0;
		color.rgb = fresnel*reflection.rgb + (1-fresnel)*color.rgb;
    }
	
#endif
			
#ifdef RAIN_REFLECTIONS
		
	if (iswater < 0.9 && isEyeInWater == 0 && wet_area > 0.914 && wet_ground > 0.1) {

		vec3 lc = mix(vec3(0.0),sunlight,sunVisibility);
		vec4 reflection = vec4(0.0);
		vec3 npos = normalize(fragpos);
		vec3 reflectedVector = reflect(normalize(fragpos), normalize(normal));
		reflectedVector = fragpos + reflectedVector * (2048.0-fragpos.z);
		vec3 skyc = getSkyColor(reflectedVector);
		vec3 sky_color = calcFog(reflectedVector,drawCloud(reflectedVector,vec3(0.0))*5,skyc*(0.5-TimeMidnight*0.46))*clamp(sky_lightmap*2.0-2/16.0,0.0,1.0);
#ifdef HD_CLOUDS
		sky_color = calcFog(reflectedVector,drawCloud(reflectedVector,drawCloud2(reflectedVector,drawCloud3(reflectedVector,drawCloud4(reflectedVector,drawCloud5(reflectedVector,vec3(0.0))))))*5,skyc*(0.5-TimeMidnight*0.46))*clamp(sky_lightmap*2.0-2/16.0,0.0,1.0);
#endif
		
		reflection = raytraceGround(fragpos, normal,sky_color);
		reflection.rgb = mix(sky_color, reflection.rgb, reflection.a)+(color.a)*lc*(1.0-rainStrength)*64.0;			//fake sky reflection, avoid empty spaces
		reflection.a = min(reflection.a,1.0);
		reflection.rgb = reflection.rgb*1.0;
		color.rgb = fresnel*reflection.rgb + (1-fresnel)*color.rgb;
    }
	
#endif

	if (hand < 0.1) color.rgb = calcFog(uPos.xyz,color.rgb,fogclr);
	if (hand < 0.1) {
	if (land < 0.9) {
	if ((isEyeInWater == 1 && iswater > 0.9)|| (isEyeInWater == 0 && iswater < 0.9)) color.rgb = calcFog2(uPos.xyz,color.rgb,(fogclr));
	else color.rgb = calcFog2(fragpos.xyz,color.rgb,(fogclr));
	}
	}
	if (isEyeInWater == 1) color.rgb = underwaterFog(length(fragpos),color.rgb);
	if (land > 0.9 && cosT > 0.) color.rgb = drawCloud(fragpos.xyz,color.rgb);
#ifdef HD_CLOUDS
	if (land > 0.9 && cosT > 0.) color.rgb = drawCloud2(fragpos.xyz,color.rgb);
	if (land > 0.9 && cosT > 0.) color.rgb = drawCloud3(fragpos.xyz,color.rgb);
	if (land > 0.9 && cosT > 0.) color.rgb = drawCloud4(fragpos.xyz,color.rgb);
	if (land > 0.9 && cosT > 0.) color.rgb = drawCloud5(fragpos.xyz,color.rgb);
#endif

#ifdef NIGHT_STAR
	if (land > 0.9 && moonVisibility > 0.1) color.rgb = nightStar(fragpos.xyz,color.rgb);
#endif
	
#ifdef NIGHT_GALAXY
	if (land > 0.9 && moonVisibility > 0.1) color.rgb = galaxy(fragpos.xyz,color.rgb);
#endif

	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos1 = tpos.xy/tpos.z;
	vec2 lightPos = pos1*0.5+0.5;
	float gr = 0.0;
	
#ifdef GODRAYS
	float truepos = sunPosition.z/abs(sunPosition.z);		//1 -> sun / -1 -> moon
	vec3 rainc = mix(vec3(1.),fogclr*1.5,rainStrength);
	vec3 lightColor = mix(sunlight*sunVisibility*rainc,3*moonlight*moonVisibility*rainc,(truepos+1.0)/2.);
	
	const int nSteps = NUM_SAMPLES;
	const float blurScale = 0.002/nSteps*9.0;
	const int center = (nSteps-1)/2;
	vec3 blur = vec3(0.0);
	float tw = 0.0;
	const float sigma = 0.5;
	

	vec2 deltaTextCoord = normalize(texcoord.st - lightPos.xy)*blurScale;
	vec2 textCoord = texcoord.st - deltaTextCoord*center;
		
	float distx = texcoord.x*aspectRatio-lightPos.x*aspectRatio;
	float disty = texcoord.y-lightPos.y;
	float illuminationDecay = pow(max(1.0-sqrt(distx*distx+disty*disty),0.0),5.0);
	/*-----------*/
		for(int i=0; i < nSteps ; i++) {
				textCoord += deltaTextCoord;
				
				float dist = (i-float(center))/center;
				float weight = exp(-(dist*dist)/(2.0*sigma));
				
				float sample = texture2D(gdepth, textCoord).r*weight;
				tw += weight;
				gr += sample;
		
		
		
	}
	color.rgb += mix(lightColor,fogclr,rainStrength)*exposure*(gr/tw)*(1.0 - rainStrength*0.8)*illuminationDecay * (1-isEyeInWater);
	/*-----------*/
	
#endif
	
	float visiblesun = 0.0;
	float temp;
	float nb = 0;
	
//calculate sun occlusion (only on one pixel) 
if (texcoord.x < 3.0*pw && texcoord.x < 3.0*ph) {
	for (int i = 0; i < 10;i++) {
		for (int j = 0; j < 10 ;j++) {
		temp = texture2D(gaux1,lightPos + vec2(pw*(i-5.0)*10.0,ph*(j-5.0)*10.0)).g;
		visiblesun +=  1.0-float(temp > 0.04) ;
		nb += 1;
		}
	}
	visiblesun /= nb;

}

	color.rgb = clamp(pow(color.rgb/MAX_COLOR_RANGE,vec3(1.0/2.2)),0.0,1.0);

/* DRAWBUFFERS:5 */
	gl_FragData[0] = vec4(color.rgb,visiblesun);
}