/*#############################################
#    _   ___ _____ ___    _   _    _____  __  #
#   /_\ / __|_   _| _ \  /_\ | |  | __\ \/ /  #
#  / _ \\__ \ | | |   / / _ \| |__| _| >  <   #
# /_/ \_\___/ |_| |_|_\/_/ \_\____|___/_/\_\  #
#											  #
#############################################*/

/*
For maximum speed of loading between dimensions, I have created several parameter
files which are called only when they are needed, the lines below are parameters
called several times in several different files. To unclog this, I split the
settings file into several parts.
*/

const float sunPathRotation = -40.0; //[-60.0 -55.0 -50.0 -45.0 -40.0 -35.0 -30.0 -25.0 -20.0 -15.0 -10.0 -5.0 0.0 5.0 10.0 15.0 20.0 25.0 30.0 35.0 40.0 45.0 50.0 55.0 60.0]
const int shadowMapResolution = 3072; //[512 1024 1536 2048 2560 3072 3584 4096 4608 5120 5632 6144 6656 7168 7680 8192]
const float shadowDistance = 512.0; //[32.0 64.0 96.0 128.0 160.0 192.0 224.0 256.0 288.0 320.0 352.0 384.0 416.0 448.0 480.0 512.0 544.0 576.0 608.0 640.0 672.0 704.0 736.0 768.0 800.0 832.0 864.0 896.0 928.0 960.0 992.0 1024.0]
const float shadowMapBias = 1.0-25.6/shadowDistance;

/*///////////////////////////////////////////////////////////////////////////////////////////
////LIGHT_SHAFT/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////*/

#define LIGHT_SHAFT
#define LIGHT_SHAFT_STRENGTH 1.0 //[0.25 0.50 0.75 1.0 1.25 1.5 1.75 2.0 2.25 2.5 2.75 3.0]
#define LIGHT_SHAFT_NOON_MULTIPLIER 1.00 //[0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.10 0.12 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.10 2.20 2.30 2.40 2.50 2.60 2.70 2.80 2.90 3.00 3.50 4.00 4.50 5.00]
#define LIGHT_SHAFT_NIGHT_MULTIPLIER 2.00 //[0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.10 0.12 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.10 2.20 2.30 2.40 2.50 2.60 2.70 2.80 2.90 3.00 3.50 4.00 4.50 5.00]
#define LIGHT_SHAFT_DAY_RAIN_MULTIPLIER 4.50 //[0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.10 0.12 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.10 2.20 2.30 2.40 2.50 2.60 2.70 2.80 2.90 3.00 3.50 4.00 4.50 5.00]
#define LIGHT_SHAFT_NIGHT_RAIN_MULTIPLIER 10.0 //[0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.10 0.12 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.10 2.20 2.30 2.40 2.50 2.60 2.70 2.80 2.90 3.00 3.50 4.00 4.50 5.00]
#define LIGHTSHAFT_CONTRAST_DAY 1.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0]
#define LIGHTSHAFT_CONTRAST_NIGHT 0.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define UNDERWATER_LIGHTSHAFT_CONTRAST_DAY 2.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0]
#define UNDERWATER_LIGHTSHAFT_CONTRAST_NIGHT 0.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define SUNSET_SUNRISE_LIGHTSHAFT_STRENGTH 0.25 //[0.25 0.5 0.75 1.0]

#define LIGHT_SHAFT_UNDERWATER_MULTIPLIER 0.15 //[0.10 0.12 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.10 2.20 2.30 2.40 2.50 2.60 2.70 2.80 2.90 3.00]
#define UNDERWATER_LIGHT_SHAFT_SIZE 200.0 //[50.0 100.0 150.0 200.0 250.0 300.0 350.0 400.0 450.0 500.0 550.0 600.0 650.0 700.0 750.0 800.0 850.0 900.0 950.0 1000.0]

#define SMOKER_LIGHT_SHAFT 1 //[0 1 2 3 4]
#define SMOKER_LIGHT_SHAFT_OVERWORLD_SPEED 5.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00 4.50 5.00 5.50 6.00 6.50 7.00 7.50 8.00 8.50 9.00 9.50 10.0]

#define SMOKER_LIGHT_SHAFT_UNDERWATER 1 //[0 1]
#define LIGHT_SHAFT_END
#define LOST_GLARE

#define ENDER_SMOKER_LIGHT_SHAFT
#define ENDER_SMOKER_LIGHT_SHAFT_SPEED 5.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00 5.00 6.00 7.00 8.00 9.00 10.00]
#define LIGHT_SHAFT_STRENGTH_END 1.00 //[0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.10 0.12 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]

#define BLACK_HOLE

#define CHILD_BIRD_DRAWING
#define NUMBER_OF_BIRDS 2 //[1 2 3]
#define BIRD_LINE_THICKNESS 0.0008 //[0.001 0.0009 0.0008 0.0007 0.0006]
#define BIRDS_HEIGHT 0.2 //[0.1 0.15 0.2 0.25 0.3]
#define BIRDS_AMPLITUDE 0.03 //[0.01 0.02 0.03 0.04 0.05]

#define END_BRIGHTNESS 2.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define GLOWING_ENTITY_FIX

#define DIRECTION_LIGHTSHAFT 2 //[0 1 2 3]
#define TEXTURED_DITHERING 0 //[0 1]

#define SUNGLARE
#define SUNGLARE_OUTWATER_STRENGTH 3 //[0 0.5 1 1.5 2 2.5 3 3.5 4 4.5 5 5.5 6 6.5 7 7.5 8 8.5 9 9.5 10 10.5 11 11.5 12 12.5 13 13.5 14 14.5 15 15.5 16 16.5 17 17.5 18 18.5 19 19.5 20]
#define SUNGLARE_UNDERWATER_STRENGTH 1 //[0 0.5 1 1.5 2 2.5 3 3.5 4 4.5 5 5.5 6 6.5 7 7.5 8 8.5 9 9.5 10 10.5 11 11.5 12 12.5 13 13.5 14 14.5 15 15.5 16 16.5 17 17.5 18 18.5 19 19.5 20]
#define SUNGLARE_RAIN 1 //[1 2]
#define SUN_GLARE_NIGHT 50 //[0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]
#define SUN_GLARE_DAY 25 //[0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]

#define REFLECTION
//#define REFLECTION_TRANSLUCENT
#define SUN_MOON_REFLECTION

#define HORIZON_MIRROR_REFLECTION 0 //[0 1]

#define SHADING_STRENGTH 0.85 //[0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.05 2.10 2.15 2.20 2.25 2.30 2.35 2.40 2.45 2.50]

#define SUN_I 0.25 //[0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define MOON_I 0.25 //[0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ROUND_SUN_MOON_GLOBAL_STRENGTH_COLOR 2 //[1 2 4 6 8 10 12 14 16 18 20 22 24 26 28 30]
#define REAL_SUNSIZE

/*///////////////////////////////////////////////////////////////////////////////////////////
////CEL_SHADING/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////*/

//#define OUTLINE_TRIPWIRE

#define OUTLINE 0 //[0 1 2 3 4]
#define PROMO_OUTLINE_EVERYWHERE 0 //[0 1]

#if OUTLINE > 0
    #define OUTLINE_ENABLED
#endif

#if OUTLINE == 1
    #define BLACK_OUTLINE
#endif

#if OUTLINE == 2
    #define BLACK_OUTLINE
    #define BLACK_OUTLINE_COLORED
#endif

#if OUTLINE == 3
    #define BLACK_OUTLINE
    #define PROMO_OUTLINE
#endif

#if OUTLINE == 4
#define PROMO_OUTLINE
#endif

//#define FULL_BORDER
#define BORDER_SIZE 1.2 //[1.0 1.2 1.4 1.6 1.8 2.0]
#define BORDER_RADIUS 1.0 //[1.0 0.9 0.8 0.7 0.6 0.5 0.4 0.3 0.2 0.1]

/*///////////////////////////////////////////////////////////////////////////////////////////
////ADVANCED MATERIALS//////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////*/

#define ADVANCED_MATERIALS
#define NORMALS_STRENGTH 1.0 //[1.0 1.25 1.5 1.75 2.0 2.25 2.5 2.75 3.0]
#define LESS_AO 1 //[0 1]
#define NORMAL_PLANTS 2 //[ 0 1 2]
#define NORMAL_DAMPENING
#define MATERIAL_FORMAT 1 //[0 1]
#define REFLECTION_SPECULAR
//#define SPECULAR_HIGHLIGHT_ROUGH
#define SMOOTHNESS_METAL_REFLECTION_STRENGTH 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0 5.1 5.2 5.3 5.4 5.5 5.6 5.7 5.8 5.9 6.0 6.1 6.2 6.3 6.4 6.5 6.6 6.7 6.8 6.9 7.0 7.1 7.2 7.3 7.4 7.5 7.6 7.7 7.8 7.9 8.0 8.1 8.2 8.3 8.4 8.5 8.6 8.7 8.8 8.9 9.0 9.1 9.2 9.3 9.4 9.5 9.6 9.7 9.8 9.9 10.0 10.1 10.2 10.3 10.4 10.5 10.6 10.7 10.8 10.9 11.0 11.1 11.2 11.3 11.4 11.5 11.6 11.7 11.8 11.9 12.0 12.1 12.2 12.3 12.4 12.5 12.6 12.7 12.8 12.9 13.0 13.1 13.2 13.3 13.4 13.5 13.6 13.7 13.8 13.9 14.0 14.1 14.2 14.3 14.4 14.5 14.6 14.7 14.8 14.9 15.0 15.1 15.2 15.3 15.4 15.5 15.6 15.7 15.8 15.9 16.0 16.1 16.2 16.3 16.4 16.5 16.6 16.7 16.8 16.9 17.0 17.1 17.2 17.3 17.4 17.5 17.6 17.7 17.8 17.9 18.0 18.1 18.2 18.3 18.4 18.5 18.6 18.7 18.8 18.9 19.0 19.1 19.2 19.3 19.4 19.5 19.6 19.7 19.8 19.9 20.0]
#define REFLECTION_RAIN
#define PUDDLES_ON_WATER
#define DISABLE_PUDDLES 2 //[0 1 2 3]
#define SMOOTHNESS_PUDDLE_REFLECTION 0.6 //[0.5 0.6 0.7 0.8]
//#define REFLECTION_ROUGH
//#define ROUGH_REF_BLUR
#define ROUGH_NOISE 0.1 //[1.0 0.9 0.8 0.7 0.6 0.5 0.4 0.3 0.2 0.1 0.09 0.08 0.07 0.06 0.05 0.04 0.03 0.02 0.01]
#define REFLECTION_SKY_FALLOFF 4 //[1 2 4 8 16]
#define REFLECTION_SKYBOX 0 //[0 1]

#define EMISSIVE_ORES
#define EMISSIVE_ORES_BRIGHTNESS_STRENGTH 0.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0]
#define PICKAXE_REVEAL 2 //[0 1 2]

//#define PARALLAX
#define PARALLAX_DEPTH 0.20 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50]
#define PARALLAX_ENTITY
//#define SELF_SHADOW
#define SELF_SHADOW_ANGLE 2.0 //[0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5 7.0 7.5 8.0]
#define SELF_SHADOW_QUALITY 8 //[8 16 32]
#define SELF_SHADOW_STRENGTH 16 //[4 8 16 32 64]
#define PARALLAX_QUALITY 128 //[64 128 256 512]
#define PARALLAX_DISTANCE 16 //[16 32 48 64 80 96 112 128]
//#define DIRECTIONAL_LIGHTMAP
#define DIRECTIONAL_LIGHTMAP_STRENGTH 5.0 //[7.0 6.5 6.0 5.5 5.0 4.5 4.0 3.5 3.0 2.5 2.0 1.5 1.0]

#define EMISSIVE_MULTIPLIER 1.0 //[0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0 1.05 1.1 1.15 1.2 1.25 1.3 1.35 1.4 1.45 1.5 1.55 1.6 1.65 1.7 1.75 1.8 1.85 1.9 1.95 2.0]

/*///////////////////////////////////////////////////////////////////////////////////////////
////POST PROCESS////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////*/

//#define DOF_IS_ON
//#define DOF
//#define DISTANCE_BLUR
#define CHROMATIC_ABERRATION 0 //[0 1 2]
#define CHROMA_STRENGTH 1.0 //[0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0 1.05 1.1 1.15 1.2 1.25 1.3 1.35 1.4 1.45 1.5 1.55 1.6 1.65 1.7 1.75 1.8 1.85 1.9 1.95 2.0]
#define CHROMATIC_ABERRATION_O
#define CHROMATIC_ABERRATION_N
#define CHROMATIC_ABERRATION_E

#define OVERWORLD_DOF_STRENGTH 5.0 //[0.0 0.1 0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 7.0 8.0 9.0 10.0]
#define OVERWORLD_DISTANCE_BLUR_STRENGTH 1.5 //[0.0 0.1 0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 7.0 8.0 9.0 10.0]
#define NETHER_DOF_STRENGTH 5.0 //[0.0 0.1 0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 7.0 8.0 9.0 10.0]
#define NETHER_DISTANCE_BLUR_STRENGTH 2.0 //[0.0 0.1 0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 7.0 8.0 9.0 10.0]
#define END_DOF_STRENGTH 5.0 //[0.0 0.1 0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 7.0 8.0 9.0 10.0]
#define END_DISTANCE_BLUR_STRENGTH 2.0 //[0.0 0.1 0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 7.0 8.0 9.0 10.0]

#define RAIN_BLUR_MULT 1.50 //[0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.10 1.20 1.30 1.40 1.50 1.60 1.70 1.80 1.90 2.00 2.25 2.50 2.75 3.00]

#define MOTION_BLUR
#define MOTION_BLUR_STRENGTH 1.0 //[0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define PLAYER_MOTION_BLUR 1 //[0 1]

#define BLOOM
#define BLOOM_MULTIPLIER 0.5 //[0.4 0.5 0.6 0.7 0.8]

#define OVERWORLD_BLOOM_STRENGTH 1.00 //[0.05 0.10 0.15 0.2 0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00]
#define NETHER_BLOOM_STRENGTH 1.25 //[0.05 0.10 0.15 0.2 0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00]
#define END_BLOOM_STRENGTH 1.00 //[0.05 0.10 0.15 0.20 0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00]
#define END_CRITICAL_BLUR
#define END_CRITICAL_BLUR_STRENGTH 0.15 // [0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2 0.21 0.22 0.23 0.24 0.25 0.26 0.27 0.28 0.29 0.3 0.31 0.32 0.33 0.34 0.35 0.36 0.37 0.38 0.39 0.4]

#define BLOOM_RADIUS 4 //[1 2 3 4 5 6 7]

#define ENABLE_DARKNESS_EFFECT
#define WARDEN_BLOOM_MULTIPLIER 1.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0]
#define DARKNESS_HARD_FOG 1 //[0 1]
#define DARKNESS_FOG_DISTANCE 3.0 //[1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0 5.1 5.2 5.3 5.4 5.5 5.6 5.7 5.8 5.9 6.0 6.1 6.2 6.3 6.4 6.5 6.6 6.7 6.8 6.9 7.0 7.1 7.2 7.3 7.4 7.5 7.6 7.7 7.8 7.9 8.0]

//#define COLOR_START
//#define BLOOM_START
#define ANIM_MOVE
#define BLOOM_S_STRENGTH 3 //[1 2 3 4 5]

#define HAND_BLOOM_REDUCTION
#define HAND_BLOOM_REDUCTION_STRENGTH 10.0 //[1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0 17.0 18.0 19.0 20.0]

#define LENS_FLARE
#define LENS_FLARE_STRENGTH_DAY 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.25 2.50 2.75 3.00 3.25 3.50]
#define LENS_FLARE_STRENGTH_NIGHT 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.25 2.50 2.75 3.00 3.25 3.50]

#define KEEP_AA_ON_WATER
#define AA 3 //[0 1 2 3 4 5]

#if AA == 1
    #define FXAA_VERSION_1
#elif (AA == 3 || AA == 4)
    #define FXAA_VERSION_2
#endif

#if AA == 2 || AA == 3
    #define TAA_VERSION_1
#elif (AA == 4 || AA == 5)
    #define TAA_VERSION_2
#endif

//#define ANISO_FILTER
#define AF_SAMPLES 4 //[2 4 8 16]

#define FXAA_SUBPIXEL 0.75 //[0.00 0.25 0.50 0.75 1.00]
#define FXAA_THRESHOLD 0.125 //[0.250 0.125 0.063]
#define FXAA_THRESHOLD_MIN 0.0312 //[0.0625 0.0312 0.0156]

#define AUTO_EXPOSURE
//#define CLASSIC_EXPOSURE
#define AUTO_EXPOSURE_RADIUS 0.4 //[0.1 0.15 0.2 0.25 0.3 0.4]
#define AUTO_EXPOSURE_SPEED 0.02 //[0.01 0.02 0.03 0.1 0.2]

#define DIRTY_LENS
#define DIRTY_LENS_STRENGTH 1.00 //[0.05 0.10 0.15 0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.25 2.50 2.75 3.00 3.25 3.50 3.75 4.00 4.25 4.50 4.75 5.00 5.25 5.50 5.75 6.00 6.25 6.50 6.75 7.00 7.25 7.50 7.75 8.00]

/*///////////////////////////////////////////////////////////////////////////////////////////
////SHADOWS/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////*/

#define COLORED_SHADOWS
#define RP_COLORED_SHADOW_COMPATIBILITY 1 //[0 1]
#define SHADOWS_ENTITIES
#define BLOCK_ENTITY_SHADOWS
#define SHADOW_FILTER
#define TAA_SHADOW_FILTER
#define SSS
#define SSS_ON_ENTITY
#define SSS_DAY_STRENGTH 0.5 //[0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
#define SSS_NIGHT_STRENGTH 1.0 //[0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
#define SSS_ENTITIES_STRENGTH 0.5 //[0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
#define SSS_FOLIAGE_STRENGTH 0.5 //[0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
#define SSS_LEAVES_STRENGTH 0.5 //[0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
#define SSS_QUALITY 12 //[12 24 48]
#define SSS_ON_SNOW 0 //[0 1]
#define SSS_ON_SAND 0 //[0 1]
#define SSS_ON_QUARTZ 0 //[0 1]
#define SSS_ON_CALCITE 0 //[0 1]
#define SSS_ON_GLASS 1 //[0 1 2]

#define EMISSIVE 2 //[0 1 2 3]

#define AO
#define AO_STRENGTH 1 //[0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1 1.05 1.1 1.15 1.2 1.25 1.3 1.35 1.4 1.45 1.5 1.55 1.6 1.65 1.7 1.75 1.8 1.85 1.9 1.95 2 2.05 2.1 2.15 2.2 2.25 2.3 2.35 2.4 2.45 2.5 2.55 2.6 2.65 2.7 2.75 2.8 2.85 2.9 2.95 3]
#define AO_QUALITY 2 //[1 2]
#define AO_FOVSCALE 4 //[1 2 3 4 5]

/*///////////////////////////////////////////////////////////////////////////////////////////
////COLOR///////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////*/

#define SATURATION_SUNSET_SUNRISE 1.3 //[1.0 1.1 1.2 1.3 1.4 1.5]
#define LIGHT_GROUND_DAY 1.00 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.05 2.10 2.15 2.20 2.25 2.30 2.35 2.40 2.45 2.50 2.55 2.60 2.65 2.70 2.75 2.80 2.85 2.90 2.95 3.00 3.05 3.10 3.15 3.20 3.25 3.30 3.35 3.40 3.45 3.50 3.55 3.60 3.65 3.70 3.75 3.80 3.85 3.90 3.95 4.00]
#define AMBIENT_GROUND_DAY 1.00 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.05 2.10 2.15 2.20 2.25 2.30 2.35 2.40 2.45 2.50 2.55 2.60 2.65 2.70 2.75 2.80 2.85 2.90 2.95 3.00 3.05 3.10 3.15 3.20 3.25 3.30 3.35 3.40 3.45 3.50 3.55 3.60 3.65 3.70 3.75 3.80 3.85 3.90 3.95 4.00]
#define LIGHT_MULT_NIGHT 1.00 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.05 2.10 2.15 2.20 2.25 2.30 2.35 2.40 2.45 2.50 2.55 2.60 2.65 2.70 2.75 2.80 2.85 2.90 2.95 3.00 3.05 3.10 3.15 3.20 3.25 3.30 3.35 3.40 3.45 3.50 3.55 3.60 3.65 3.70 3.75 3.80 3.85 3.90 3.95 4.00]
#define AMBIENT_MULT_NIGHT 1.00 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.05 2.10 2.15 2.20 2.25 2.30 2.35 2.40 2.45 2.50 2.55 2.60 2.65 2.70 2.75 2.80 2.85 2.90 2.95 3.00 3.05 3.10 3.15 3.20 3.25 3.30 3.35 3.40 3.45 3.50 3.55 3.60 3.65 3.70 3.75 3.80 3.85 3.90 3.95 4.00]

#define LIGHT_POWER 1.2 //[0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1 1.05 1.1 1.15 1.2 1.25 1.3 1.35 1.4 1.45 1.5]
#define BLOCKLIGHT_BY_TEMP
#define BLOCKLIGHT_TEMP 3750 //[2000 2250 2500 2750 3000 3250 3500 3750 4000 4250 4500 4750 5000 5250 5500 5750 6000 6250 6500 6750 7000]
#define BLOCKLIGHT_LUMA 0.1 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

#define LIGHT_CONCENTRATION 2.0 //[1.5 2.0 2.5 3.0 3.5]

#define NEW_NETHER_PORTAL 1 //[0 1 2]
#define PORTAL_PARALLAX_DEPTH 2 //[1 1.25 1.5 1.75 2 2.25 2.5 2.75 3 3.25 3.5 3.75 4 4.25 4.5 4.75 5]
#define NETHER_PORTAL_GLOWING_POWER_OVERWORLD 3.00 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.25 2.50 2.75 3.00 3.25 3.50 3.75 4.00 4.25 4.50 4.75 5.00]
#define NETHER_PORTAL_GLOWING_POWER_NETHER 5.00 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.25 2.50 2.75 3.00 3.25 3.50 3.75 4.00 4.25 4.50 4.75 5.00]
#define NETHER_PORTAL_GLOWING_POWER_ENDER 4.00 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.25 2.50 2.75 3.00 3.25 3.50 3.75 4.00 4.25 4.50 4.75 5.00]

#define EMISSIVE_END_PORTAL 0.03 //[0.0 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1]

#define BEACON_BEAM_LAYER 1 //[0 1]
#define EMISSIVE_BEACON_BEAM
#define BEACON_BEAM_EMISSIVE_OVERWORLD 2 //[1 1.25 1.5 1.75 2 2.25 2.5 2.75 3 3.25 3.5 3.75 4 4.25 4.5 4.75 5]
#define BEACON_BEAM_EMISSIVE_NETHER 2 //[1 1.25 1.5 1.75 2 2.25 2.5 2.75 3 3.25 3.5 3.75 4 4.25 4.5 4.75 5]
#define BEACON_BEAM_EMISSIVE_ENDER 2 //[1 1.25 1.5 1.75 2 2.25 2.5 2.75 3 3.25 3.5 3.75 4 4.25 4.5 4.75 5]

#define LIGHTSIGN_INTENSITY_OVERWORLD 0.50 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define LIGHTSIGN_INTENSITY_NETHER 0.50 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define LIGHTSIGN_INTENSITY_ENDER 0.50 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]

//#define SKY_VANILLA
#define UNDERGROUND_SKY

#define SKY_DAY 1.00 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.05 2.10 2.15 2.20 2.25 2.30 2.35 2.40 2.45 2.50 2.55 2.60 2.65 2.70 2.75 2.80 2.85 2.90 2.95 3.00 3.05 3.10 3.15 3.20 3.25 3.30 3.35 3.40 3.45 3.50 3.55 3.60 3.65 3.70 3.75 3.80 3.85 3.90 3.95 4.00 4.25 4.50 4.75 5.00 5.25 5.50 5.75 6.00 6.25 6.50 6.75 7.00 7.50 8.00 8.50 9.00 9.50 10.0 11.0 12.0 13.0 14.0 15.0 16.0 18.0 20.0 22.0 24.0 28.0 30.0 32.0]
#define SKY_NOON 1.00 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.05 2.10 2.15 2.20 2.25 2.30 2.35 2.40 2.45 2.50 2.55 2.60 2.65 2.70 2.75 2.80 2.85 2.90 2.95 3.00 3.05 3.10 3.15 3.20 3.25 3.30 3.35 3.40 3.45 3.50 3.55 3.60 3.65 3.70 3.75 3.80 3.85 3.90 3.95 4.00 4.25 4.50 4.75 5.00 5.25 5.50 5.75 6.00 6.25 6.50 6.75 7.00 7.50 8.00 8.50 9.00 9.50 10.0 11.0 12.0 13.0 14.0 15.0 16.0 18.0 20.0 22.0 24.0 28.0 30.0 32.0]
#define SKY_NIGHT 1.00 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.05 2.10 2.15 2.20 2.25 2.30 2.35 2.40 2.45 2.50 2.55 2.60 2.65 2.70 2.75 2.80 2.85 2.90 2.95 3.00 3.05 3.10 3.15 3.20 3.25 3.30 3.35 3.40 3.45 3.50 3.55 3.60 3.65 3.70 3.75 3.80 3.85 3.90 3.95 4.00 4.25 4.50 4.75 5.00 5.25 5.50 5.75 6.00 6.25 6.50 6.75 7.00 7.50 8.00 8.50 9.00 9.50 10.0 11.0 12.0 13.0 14.0 15.0 16.0 18.0 20.0 22.0 24.0 28.0 30.0 32.0]
#define SKY_RAIN_DAY 1.50 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.05 2.10 2.15 2.20 2.25 2.30 2.35 2.40 2.45 2.50 2.55 2.60 2.65 2.70 2.75 2.80 2.85 2.90 2.95 3.00 3.05 3.10 3.15 3.20 3.25 3.30 3.35 3.40 3.45 3.50 3.55 3.60 3.65 3.70 3.75 3.80 3.85 3.90 3.95 4.00 4.25 4.50 4.75 5.00 5.25 5.50 5.75 6.00 6.25 6.50 6.75 7.00 7.50 8.00 8.50 9.00 9.50 10.0 11.0 12.0 13.0 14.0 15.0 16.0 18.0 20.0 22.0 24.0 28.0 30.0 32.0]
#define SKY_RAIN_NIGHT 0.70 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.05 2.10 2.15 2.20 2.25 2.30 2.35 2.40 2.45 2.50 2.55 2.60 2.65 2.70 2.75 2.80 2.85 2.90 2.95 3.00 3.05 3.10 3.15 3.20 3.25 3.30 3.35 3.40 3.45 3.50 3.55 3.60 3.65 3.70 3.75 3.80 3.85 3.90 3.95 4.00 4.25 4.50 4.75 5.00 5.25 5.50 5.75 6.00 6.25 6.50 6.75 7.00 7.50 8.00 8.50 9.00 9.50 10.0 11.0 12.0 13.0 14.0 15.0 16.0 18.0 20.0 22.0 24.0 28.0 30.0 32.0]

#define ENDER_SKY_COLOR_CUSTOM

#define CUSTOM_RAIN_SNOW_COLORING 1 //[0 1]
#define RS_R 150 //[0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255]
#define RS_G 156 //[0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255]
#define RS_B 165 //[0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255]
#define RS_I 1.00 //[0.0 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.10 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]

/*///////////////////////////////////////////////////////////////////////////////////////////
////SKY/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////*/

#define FBM
#define END_FBM_REF
#define END_FBM_REF_STRENGTH_W 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1.2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0]

#define REALISTIC_CLOUDS 1 //[0 1 2]
#define STARS
#define SUNSET_SUNRISE_STARS
#define STARS_JITTER
#define STARS_JITTER_SPEED 0.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1.2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0]

#define END_STARS
#define NEW_ENDER_STARS 1 //[0 1]
#define END_STARS_REF
#define END_STARS_REF_STRENGTH_W 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1.2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0]

//#define STARS_REFLECTION
#define WATER_STARS_REFLECTION_STRENGTH 0.05 //[0.001 0.002 0.003 0.004 0.005 0.006 0.007 0.008 0.009 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5 5.1 5.2 5.3 5.4 5.5 5.6 5.7 5.8 5.9 6 6.1 6.2 6.3 6.4 6.5 6.6 6.7 6.8 6.9 7 7.1 7.2 7.3 7.4 7.5 7.6 7.7 7.8 7.9 8 8.1 8.2 8.3 8.4 8.5 8.6 8.7 8.8 8.9 9 9.1 9.2 9.3 9.4 9.5 9.6 9.7 9.8 9.9 10]
#define SHININGSTARS
#define NUMBER_SHININGSTARS 3 //[1 2 3 4]
#define SHININGSTARS_JITTER
#define SHININGSTARS_JITTER_SPEED 0.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1.2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0]
//#define SHININGSTARS_REFLECTION
#define SHININGSTARS_REFLECTION_STRENGTH 0.50 //[0.0 0.001 0.002 0.003 0.004 0.005 0.005 0.006 0.007 0.008 0.009 0.01 0.02 0.03 0.04 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.25 2.50 2.75 3.00 3.25 3.50 3.75 4.00]
#define CONSTELLATIONS
#define LINE_THICKNESS 1.0 //[0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5]
#define LINE_TRANSPARENCY 0.1 //[0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define SIZESTARS 1.5 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define THICKSTARS 0.6 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#define ROUND_SUN_MOON 1 //[0 1]
#define SUN_MOON_FADING 1.5 //[1.0 1.25 1.5]
#define SUNSIZE 7500 //[2500 2750 3000 3250 3500 3750 4000 4250 4500 4750 5000 5250 5500 5750 6000 6250 6500 6750 7000 7250 7500 7750 8000 8250 8500 8750 9000 9250 9500 9750 10000]
#define SUN_REF 1.0 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define MOON_REF 0.5 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#define SUN_RAYS
#define SUN_RAYS_DISTANCE 0.8 //[0.7 0.8 0.9 1.0]
#define SUN_RAYS_I 0.2 //[0.1 0.15 0.2]
#define NUM_RAYS 12 //[12 16 24 28 32]
#define RAY_DIST_AMPLITUDE1 0.05 //[0.0 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2]
#define RAY_DIST_AMPLITUDE2 0.1 //[0.0 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2]
#define RAY_ROTATION_SPEED 0.2 //[0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5]
#define RAY_MOVE_SPEED 2.0 //[0.0 0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0 2.25 2.5 2.75 3.0]
#define SUNRAYS_COLOR 1 //[0 1]

#define SKY_BLUR 2 //[0 1 2 3]
#define SKYBOX_BRIGHTNESS 0.25 //[0.0 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 2.25 2.50 2.75 3.00 3.25 3.50 3.75 4.00 4.25 4.50 4.75 5.00 5.25 5.50 5.75 6.00]
#define VANILLA_SKYBOX 0 //[0 1]
#define HORIZON_SUN_MOON
#define NEWMOON_DISABLER_STUFF
#define NEWMOON_SHADOWS_LIGHTMAP_CONTROL 0.5 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

#define DOUBLE_LAYER_STARS 1 //[0 1]
#define STARS_COVERAGE 1 //[1 2 3]
#define DISTANCE_STARS 0.6 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define STARS_LIGHT_INTENSITY 5 //[1 2 3 4 5 6 7 8 9 10]
#define MOON_STARS_HIDE_SIZE 0.06 //[0.0 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
#define MOON_STARS_FADE 5.0 //[0.5 0.6 0.7 0.8 0.9 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0]

#define AURORA
#define OLD_AURORA_NOISE
#define AURORA_REFLECTION
#define AURORA_REFLECTION_STRENGTH 1.0 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define METAL_AURORA_REFLECTION
//#define AURORA_WEATHER_PERBIOME
#define AURORA_DISTANCE 1 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define AURORA_SIZE 1 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1]
#define AURORA_COLOR 6 //[1 2 3 4 5 6]
#define AURORA_VISIBILITY 1.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1.2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0]
#define AURORA_SPEED 2 //[0.25 0.5 1 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5 ]
#define COLOR_GRADIENT 0.5 //[0.5 0.75 1.0 1.25 1.5]
#define RAINBOW_COLOR_AURORA_1_SPEED -0.025 //[-1.00 -0.10 -0.095 -0.090 -0.085 -0.080 -0.075 -0.070 -0.065 -0.060 -0.055 -0.050 -0.045 -0.040 -0.035 -0.030 -0.025 -0.020 -0.015 -0.010 -0.005 0.0 0.005 0.010 0.015 0.020 0.025 0.030 0.035 0.040 0.045 0.050 0.055 0.060 0.065 0.070 0.075 0.080 0.085 0.090 0.095 0.10 1.00]
#define RAINBOW_COLOR_AURORA_2_SPEED 0.025 //[-1.00 -0.10 -0.095 -0.090 -0.085 -0.080 -0.075 -0.070 -0.065 -0.060 -0.055 -0.050 -0.045 -0.040 -0.035 -0.030 -0.025 -0.020 -0.015 -0.010 -0.005 0.0 0.005 0.010 0.015 0.020 0.025 0.030 0.035 0.040 0.045 0.050 0.055 0.060 0.065 0.070 0.075 0.080 0.085 0.090 0.095 0.10 1.00]
#define RAINBOW_COLOR_AURORA_1_START 0.2 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define RAINBOW_COLOR_AURORA_2_START 0.7 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

#define AURORA_END
#define AURORA_END_DISTANCE 1 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define AURORA_END_SIZE 1 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1]
#define AURORA_END_VISIBILITY 1.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1.2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0]
#define AURORA_END_SPEED 3 //[0.25 0.5 1 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5]
#define COLOR_END_GRADIENT 0.5 //[0.5 0.75 1.0 1.25 1.5]
#define END_AURORA_REF
#define END_AURORA_REF_STRENGTH_W 3.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1.2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0]

#define SHOOTING_STARS
#define SHOOTING_STARS_END
#define SPEED_SHOOTING 4.0 //[5.0 4.0 3.0 2.0 1.0]
#define STAR_THICKNESS 0.1 //[1.0 0.9 0.8 0.7 0.6 0.5 0.4 0.3 0.2 0.1]
#define SHOW_DELAY 0.9 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define SHOOTING_STARS_FADE 40.0 //[1.0 2.0 3.0 4.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0 17.0 18.0 19.0 20.0 21.0 22.0 23.0 24.0 25.0 26.0 27.0 28.0 29.0 30.0 31.0 32.0 33.0 34.0 35.0 36.0 37.0 38.0 39.0 40.0]
#define NUM_SHOOTING_STARS 3 //[1 2 3 4]
//#define SHOOTING_STARS_REFLECTION
#define SHOOTING_INTENSITY 5.0 //[1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0 17.0 18.0 19.0 20.0 30.0 40.0 50.0 60.0 70.0 80.0 90.0 100.0 110.0 120.0 130.0 140.0 150.0 160.0 170.0 180.0 190.0 200.0]
#define END_SHOOTING_STARS_REF
#define END_SHOOTING_STARS_REF_STRENGTH_W 3.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1.2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0]

#define CLOUD_THICKNESS 20 //[5 10 15 20 30 50]
#define CLOUD_AMOUNT 16 //[16 15 14 13 12 12 11]
#define CLOUD_HEIGHT 20 //[5 10 15 20 30 40 50]
#define CLOUD_SPEED 1.0 //[0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0]
#define CLOUD_COVERAGE 0.6 //[0.2 0.4 0.6 0.8 0.9]
#define CLOUD_OPACITY 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define CLOUD_BRIGHTNESS_DAY 2.0 //[0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0 2.25 2.5 2.75 3.0 3.25 3.5 3.75 4.0]
#define CLOUD_BRIGHTNESS_NIGHT 2.0 //[0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0 2.25 2.5 2.75 3.0 3.25 3.5 3.75 4.0]
#define CLOUD_RAIN_COVERING 0.8 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define VANILLA_CLOUD_OPACITY 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define DAY_CLOUD_COLOR 0 //[0 1]
#define NIGHT_CLOUD_COLOR 1 //[0 1]

#define CLOUDS_REFLECTION
#define METAL_CLOUDS_REFLECTION
#define CLOUD_VISIBILITY_WATER_REFLECTION 1.0 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define END_CLOUDS

#define WATER_MODE 0 //[0 1 2]
#define REFRACTION 1 //[0 1 2 3 4]

#define WATER_FOG 1 //[0 1]
#define WATER_FOG_DENSITY 1.0 //[1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define WATER_PARALLAX

//#define UNDERWATER_BLUR
#define UNDERWATER_BLUR_FACTOR 1.5 //[1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define UNDERWATER_NO_BLUR_HAND
#define UNDERWATER_BLUR_BASED_BLOOM
#define UNDERWATER_BLUR_BASED_B_BLOOM_STRENGTH 1.5 //[1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define UNDERWATER_BLUR_BASED_B_BLUR_STRENGTH 0.3 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

#define WATER_BUMP 1.00 //[0.05 0.10 0.15 0.20 0.25 0.50 0.75 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.75 2.00]
#define WATER_DETAIL 0.25 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50]
#define WATER_SHARPNESS 0.2 //[0.8 0.7 0.6 0.5 0.4 0.3 0.2 0.1]
#define WATER_SPEED 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]

#define SKY_REFLECT_DARK_AREA 5 //[1 2 3 4 5 6]
#define WATER_CAUSTICS
#define WATER_CAUSTICS_END
#define CAUSTICS_VISIBILITY_DAY 3.0 //[1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0]
#define CAUSTICS_VISIBILITY_NIGHT 3.0 //[1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0]
#define PROJECTED_CAUSTICS
#define PROJECTED_VISIBILITY_DAY 5.0 //[1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0]
#define PROJECTED_VISIBILITY_NIGHT 5.0 //[1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0]

#define WATER_REVERB

#define ABSORPTION
//#define VANILLA_WATER_ABSORPTION
#define WATER_ABS_COLOR 0.95 //[0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 0.96 0.97 0.98 0.99]
#define ALBEDO_ABS_POWER 4.0 //[1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5 7.0 7.5 8.0 8.5 9.0 9.5 10.0]

#define WAVING_SPEED 1.0 //[0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0 1.05 1.1 1.15 1.2 1.25 1.3 1.35 1.4 1.45 1.5 1.55 1.6 1.65 1.7 1.75 1.8 1.85 1.9 1.95 2.0]
#define WAVING_GRASS
#define WAVING_MUSHROOM
#define WAVING_COBWEB
#define WAVING_CROPS
#define WAVING_PLANT
#define WAVING_TALL_PLANT
#define WAVING_LEAVES
#define WAVING_VINES
#define WAVING_LILYPAD
#define WAVING_FIRE
//#define WAVING_WATER
#define WAVING_LAVA
#define WAVING_LANTERN
//#define WAVING_CHAIN

#define EMISSIVE_FLOWERS 0 //[0 1]
#define FLOWERS_EMISSIVE_STRENGTH 1.0 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define WEATHER_EMISSIVE_FLOWERS 1 //[0 1]
/*///////////////////////////////////////////////////////////////////////////////////////////
////WORLD///////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////*/

//#define WORLD_CURVATURE
#define OVERWORLD_CURVATURE_SIZE 2048 //[-256 -512 -1024 -2048 -4096 -8192 -16384 -32768 999999 32768 16384 8192 4096 2048 1024 512 256 128 64 32 16]
#define NETHER_CURVATURE_SIZE 2048 //[-256 -512 -1024 -2048 -4096 -8192 -16384 -32768 999999 32768 16384 8192 4096 2048 1024 512 256 128 64 32 16]
#define END_CURVATURE_SIZE 2048 //[-256 -512 -1024 -2048 -4096 -8192 -16384 -32768 999999 32768 16384 8192 4096 2048 1024 512 256 128 64 32 16]

#define WEATHER
#define WEATHER_OPACITY 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.25 2.50 2.75 3.00 3.25 3.50 3.75 4.00]
#define WEATHER_DYNAMIC_HAND_LIGHT

#define FOG
#define UNDERGROUND_FOG
#define OVERWORLD_FOG_DENSITY 0.50 //[0.25 0.50 0.75 1.00 1.50 2.00 2.50 3.00 3.50 4.00 4.50 5.00 5.50 6.00 6.50 7.00]
#define RAIN_FOG_DENSITY 0.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5 5.1 5.2 5.3 5.4 5.5 5.6 5.7 5.8 5.9 6 6.1 6.2 6.3 6.4 6.5 6.6 6.7 6.8 6.9 7 7.1 7.2 7.3 7.4 7.5 7.6 7.7 7.8 7.9 8 8.1 8.2 8.3 8.4 8.5 8.6 8.7 8.8 8.9 9 9.1 9.2 9.3 9.4 9.5 9.6 9.7 9.8 9.9 10]
#define NETHER_FOG_DENSITY 0.50 //[0.25 0.50 0.75 1.00 1.50 2.00 2.50 3.00 3.50 4.00 4.50 5.00 5.50 6.00 6.50 7.00]
#define NETHER_FOG_COLOR_M 0.12 //[0.04 0.12]
#define END_FOG_DENSITY 0.50 //[0.0 0.05 0.10 0.15 0.20 0.25 0.50 0.75 1.00 1.50 2.00 2.50 3.00 3.50 4.00 4.50 5.00 5.50 6.00 6.50 7.00]
#define LAVA_FOG_STRENGTH 0.2 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define POWDER_SNOW_FOG_STRENGTH 0.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

#define WEATHER_PERBIOME
#define USE_DESERT 1 //[0 1]
#define USE_MESA 1 //[0 1]
#define USE_COLD 1 //[0 1]
#define USE_SWAMP 1 //[0 1]
#define USE_MUSHROOM 1 //[0 1]
#define USE_SAVANNA 1 //[0 1]

#define DISTANT_FADE 3 //[0 1 2 3]
#define DISTANT_FADE_STYLE 0 //[0 1]

//#define NETHER_VANILLA
#define SKY_GROUND 2 //[0 1 2]
#define SKY_DENSITY_D 0.35 //[0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define SKY_EXPOSURE_D 0.00 //[-1.00 -0.75 -0.50 -0.25 0.00 0.25 0.50 0.75 1.00]
#define SKY_DENSITY_N 0.65 //[0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define SKY_EXPOSURE_N 0.00 //[-1.00 -0.75 -0.50 -0.25 0.00 0.25 0.50 0.75 1.00]
#define SKY_DENSITY_W 1.50 //[1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]
#define SKY_EXPOSURE_W 0.00 //[-1.00 -0.75 -0.50 -0.25 0.00 0.25 0.50 0.75 1.00]
#define SKY_HORIZON_N 1.00 //[0.75 1.00 1.25 1.50 1.75 2.00 2.25 2.50]
#define SKY_HORIZON_F 1.50 //[0.75 1.00 1.25 1.50 1.75 2.00 2.25 2.50]

#define NOUVELLE_PLUIE 2 //[0 1 2]

#define UNDERWATER_SKY_OPACITY
#define UNDERWATER_SKY_BRIGHTNESS 1.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0]
#define FROSTED_LENS
#define FROSTED_LENS_ONLY_RAIN
#define FROSTED_LENS_DYNAMIC_HAND_LIGHT
#define FROSTYNESS 10.0 //[1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0 17.0 18.0 19.0 20.0 21.0 22.0 23.0 24.0 25.0 26.0 27.0 28.0 29.0 30.0 31.0 32.0 33.0 34.0 35.0 36.0 37.0 38.0 39.0 40.0]
#define COLORIZE 10.0 //[1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0 17.0 18.0 19.0 20.0 21.0 22.0 23.0 24.0 25.0 26.0 27.0 28.0 29.0 30.0 31.0 32.0 33.0 34.0 35.0 36.0 37.0 38.0 39.0 40.0]

#define LAVA_NOISE

#define NIGHT_DESATURATION
#define DESATURATION_FACTOR 1.5 //[0.0 0.5 1.0 1.5 2.0]

/*///////////////////////////////////////////////////////////////////////////////////////////
////OTHERS//////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////*/

#define PLANET
//#define PLANET2
#define PLANET_SIZE_X 2.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0]
#define PLANET_SIZE_Y 2.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0]
#define PLANET_OPACITY 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define PLANET_ROTX 90 //[0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100 105 110 115 120 125 130 135 140 145 150 155 160 165 170 175 180]
#define PLANET_ROTY 30 //[0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100 105 110 115 120 125 130 135 140 145 150 155 160 165 170 175 180 185 190 195 200 205 210 215 220 225 230 235 240 245 250 255 260 265 270 275 280 285 290 295 300 305 310 315 320 325 330 335 340 345 350 355 360]
#define PLANET_ROTZ 0 //[0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100 105 110 115 120 125 130 135 140 145 150 155 160 165 170 175 180 185 190 195 200 205 210 215 220 225 230 235 240 245 250 255 260 265 270 275 280 285 290 295 300 305 310 315 320 325 330 335 340 345 350 355 360]
//#define PLANET_REFLECTION
#define PLANET_REFLECTION_STRENGTH_NIGHT 0.20 //[0.0 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define PLANET_REFLECTION_STRENGTH_DAY 0.30 //[0.0 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]

#define NEBULA
#define NEBULA_SIZE_X 2.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0]
#define NEBULA_SIZE_Y 2.7 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0]
#define NEBULA_OPACITY 0.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define NEBULA_ROTX 25 //[0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100 105 110 115 120 125 130 135 140 145 150 155 160 165 170 175 180]
#define NEBULA_ROTY 295 //[0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100 105 110 115 120 125 130 135 140 145 150 155 160 165 170 175 180 185 190 195 200 205 210 215 220 225 230 235 240 245 250 255 260 265 270 275 280 285 290 295 300 305 310 315 320 325 330 335 340 345 350 355 360]
#define NEBULA_ROTZ 255 //[0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100 105 110 115 120 125 130 135 140 145 150 155 160 165 170 175 180 185 190 195 200 205 210 215 220 225 230 235 240 245 250 255 260 265 270 275 280 285 290 295 300 305 310 315 320 325 330 335 340 345 350 355 360]
//#define NEBULA_REFLECTION
#define NEBULA_REFLECTION_STRENGTH_NIGHT 0.25 //[0.0 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]

#define GALAXY
#define GALAXY_SIZE_X 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0]
#define GALAXY_SIZE_Y 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0]
#define GALAXY_OPACITY 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define GALAXY_ROTX 65 //[0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100 105 110 115 120 125 130 135 140 145 150 155 160 165 170 175 180]
#define GALAXY_ROTY 100 //[0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100 105 110 115 120 125 130 135 140 145 150 155 160 165 170 175 180 185 190 195 200 205 210 215 220 225 230 235 240 245 250 255 260 265 270 275 280 285 290 295 300 305 310 315 320 325 330 335 340 345 350 355 360]
#define GALAXY_ROTZ 300 //[0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100 105 110 115 120 125 130 135 140 145 150 155 160 165 170 175 180 185 190 195 200 205 210 215 220 225 230 235 240 245 250 255 260 265 270 275 280 285 290 295 300 305 310 315 320 325 330 335 340 345 350 355 360]
//#define GALAXY_REFLECTION
#define GALAXY_REFLECTION_STRENGTH_NIGHT 0.10 //[0.0 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]

#define TECHNO_XP
#define XP_ORB_INTENSITY 2.0 //[0.5 1.0 1.5 2.0 2.5 3.0 4.0]

//#define LAPISLAZUL_BLOCK_EMISSIVE
#define REDSTONE_BLOCK_EMISSIVE

//#define SHOW_DARK_ZONES

#define NEW_END_PORTAL
#define COLOR_END_PORTAL 1 //[0 1]

//#define DETECTEUR_CAVE
//#define INVISIBLE_TRIPWIRE

//#define HYPER_SPEED
#define HYPERSPEED_MULTIPLIER 2.0 //[0.5 1.0 1.25 1.50 1.75 2.0 2.25 2.50 2.75 3.0 3.25 3.50 3.75 4.0 4.25 4.50 4.75 5.0]
//#define ONLY_SPRINT

#define CORRUPTION

#define FLASH_VICTIME
#define FLASH_SWORD
#define FLASH_AXE
#define FLASH_BOW
#define FLASH_TRIDENT
#define FLASH_SNOWBALL
#define FLASH_FISHING
#define FLASH_EGG
#define INTENSITE_FLASH_VICTIME_O 0.25 //[0.01 0.02 0.03 0.04 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.0 1.1 1.2 1.3 1.4 1.5]
#define INTENSITE_FLASH_VICTIME_N 0.50 //[0.01 0.02 0.03 0.04 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.0 1.1 1.2 1.3 1.4 1.5]
#define INTENSITE_FLASH_VICTIME_E 0.50 //[0.01 0.02 0.03 0.04 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.0 1.1 1.2 1.3 1.4 1.5]

#define OSCILLATION
#define OSCILLATION_SPEED 5.00 //[0.50 1.00 1.50 2.00 2.50 3.00 3.50 4.00 4.50 5.00 5.50 6.00 6.50 7.00 7.50 8.00 8.50 9.00 9.50 10.00]

#define ENTITY_FLASH 1 //[0 1 2]
#define RED_PARTICLES_EMISSIVE 1 //[0 1 2]
#define PURPLE_PARTICLES_EMISSIVE

#define MOUVEMENT_CAM 0 //[0 1]
//#define MOUVEMENTS_MAINS
#define MOUVEMENTS_MAINS_2
#define ADVANCE_HAND_POS 0.0 //[0.0 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60]
#define ADVANCE_HAND_POS2 0.0 //[0.0 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60]
#define DECALLAGE_MAINS 0.0 //[0.0 0.05 0.10 0.15 0.20 0.25 0.30]
#define SPEED_MOOVE 0.8 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#define FRESNEL_DAY 1 //[0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1 1.1 1.15 1.2 1.25 1.3 1.35 1.4 1.45 1.5 1.55 1.6 1.65 1.7 1.75 1.8 1.85 1.9 1.95 2]
#define FRESNEL_NIGHT 1 //[0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1 1.1 1.15 1.2 1.25 1.3 1.35 1.4 1.45 1.5 1.55 1.6 1.65 1.7 1.75 1.8 1.85 1.9 1.95 2]
#define FRESNEL_CAVE 1 //[0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1 1.1 1.15 1.2 1.25 1.3 1.35 1.4 1.45 1.5 1.55 1.6 1.65 1.7 1.75 1.8 1.85 1.9 1.95 2]
#define ICE_REFLECTION_STRENGTH 1 //[0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1 1.1 1.15 1.2 1.25 1.3 1.35 1.4 1.45 1.5 1.55 1.6 1.65 1.7 1.75 1.8 1.85 1.9 1.95 2]

#define COLOR_BLOC_SELECTOR 3 //[0 1 2 3]
#define RAINBOW_COLOR_BLOC_SELECTOR_SPEED 1.00 //[0.05 0.10 0.15 0.20 0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00]
#define HARLEQUIN_COLOR_BLOC_SELECTOR_SPEED 0.50 //[0.05 0.10 0.15 0.20 0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00]
#define CBSA_OBSTRUCTION 0.1 //[0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2 0.21 0.22 0.23 0.24 0.25 0.26 0.27 0.28 0.29 0.3 0.31 0.32 0.33 0.34 0.35 0.36 0.37 0.38 0.39 0.4 0.41 0.42 0.43 0.44 0.45 0.46 0.47 0.48 0.49 0.5 0.51 0.52 0.53 0.54 0.55 0.56 0.57 0.58 0.59 0.6 0.61 0.62 0.63 0.64 0.65 0.66 0.67 0.68 0.69 0.7 0.71 0.72 0.73 0.74 0.75 0.76 0.77 0.78 0.79 0.8 0.81 0.82 0.83 0.84 0.85 0.86 0.87 0.88 0.89 0.9 0.91 0.92 0.93 0.94 0.95 0.96 0.97 0.98 0.99 1.00]
#define THIRD_DIMENSION_SELECTION_BLOCK 0 //[0 1 2]

//#define COLORED_EYES
#define SPIDER_EYES 1 //[1 2 3 4 5]

#define BSL_VIGNETTE
#define FORCE_BSL_VIGNETTE 0.5 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0]

#define RETIRE_TEXTURE_CASSE

//#define BLOOM_JITTER
//#define BLOCK_LIGHT_JITTER
//#define HAND_BLOCK_LIGHT_JITTER
#define JITTER_SPEED 2.0 //[0.25 0.5 0.75 1.0 1.25 1.50 1.75 2.0 2.25 2.50 2.75 3.0 3.25 3.50 3.75 4.0]
#define JITTER_STRENGTH1 0.031 //[0.0 0.011 0.021 0.031 0.041 0.051 0.061 0.071 0.081 0.091 0.11 0.21 0.31 0.41 0.51 0.61 0.71 0.81 0.91]
#define JITTER_STRENGTH2 0.0123 //[0.0 0.0123 0.0223 0.0323 0.0423 0.0523 0.0623 0.0723 0.0823 0.0923 0.123 0.223 0.323 0.423 0.523 0.623 0.723 0.823 0.923]
#define JITTER_STRENGTH3 0.0234 //[0.0 0.0134 0.0234 0.0334 0.0434 0.0534 0.0634 0.0734 0.0834 0.0934 0.134 0.234 0.334 0.434 0.534 0.634 0.734 0.834 0.934]

//#define MAGICAL_GLINT
#define RP_COMPATIBILITY

#if MC_VERSION <= 11903
#undef RP_COMPATIBILITY
#endif

#define GLINT_SPEED 0.50 //[0.10 0.15 0.20 0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00]
#define GLINT_INTENSITY 1.0 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define GLINT_DIRECTION 270.0 //[0.0 10.0 20.0 30.0 40.0 50.0 60.0 70.0 80.0 90.0 100.0 110.0 120.0 130.0 140.0 150.0 160.0 170.0 180.0 190.0 200.0 210.0 220.0 230.0 240.0 250.0 260.0 270.0 280.0 290.0 300.0 310.0 320.0 330.0 340.0 350.0 360.0]

#define DIST_MAX_LIGHT 1.0 //[1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5 7.0 7.5 8.0]
#define DIST_DECLINE 13 //[4 4.5 5 5.5 6 6.5 7 7.5 8 8.5 9 9.5 10 10.5 11 11.5 12 12.5 13 13.5 14 14.5 15 15.5 16 16.5 17 17.5 18 18.5 19 19.5 20 20.5 21 21.5 22 22.5 23 23.5 24 24.5 25]
#define MAX_LIGHT 1.5 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5]
#define DYNAMIC_HAND_LIGHT
#define COLORED_DYNAMIC_HAND_LIGHT
//#define COLORED_LIGHTING

#define SUNVISIBILITY_FOG 1 //[0 1 2 3 4]

//#define KUWAHARA_FILTER
#define KUWAHARA_RADIUS 2 //[1 2 3 4]

#define FILM_GRAINS
#define FORCE_DU_GRAIN 0.01 //[0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1]

#ifdef KUWAHARA_FILTER
    #undef FILM_GRAINS
#endif

//#define WHITE_WORLD
//#define BLACK_WORLD
#define TEXTURESW
#define TERRAINW
#define SPIDER_EYESW
#define DAMAGED_BLOCKW
#define BEACONW
#define ENTITIESW
#define HANDSW
#define WATERW
#define SKYW

//#define SHARPEN_AA

#define HAND_ENTITIES_SPECULAR_TRICK 1 //[0 1]

#define GLOWING_ENTITY_RGB

#define CHORUS_EMISSIVE_O
#define CHORUS_EMISSIVE_N
#define CHORUS_EMISSIVE_E

#define STAINED_SAT 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0]
#define STAINED_TRANS 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

/*
COMMON VARIABLES
*/

uniform int worldTime;

float timeAngle = worldTime / 24000.0;

float shadowFadeOut1=clamp01((worldTime - 12330.0) / 230);
float shadowFadeIn1=clamp01((worldTime - 13010.0) / 220);
float shadowFadeOut2=clamp01((worldTime - 22770.0) / 220);
float shadowFadeIn2=clamp01((worldTime - 23440.0) / 230);
float shadowFade=1.0 - (shadowFadeOut1 - shadowFadeIn1 + shadowFadeOut2 - shadowFadeIn2);

float timeAngleSin = sin(timeAngle * 6.28318530718);
float dayFactor = sqrt(max(0.0, timeAngleSin));
float nightFactor = max(0.0, -timeAngleSin);

#if (defined ENABLE_DARKNESS_EFFECT && MC_VERSION >= 11900)
    vec3 darknessColor = vec3(0.0001, 0.0003, 0.0005);
#endif

#ifdef FRAGMENT
    ivec2 texelCoord = ivec2(gl_FragCoord.xy);
#endif

#ifdef VERTEX

    uniform mat4 gbufferModelView;

    vec2 GetLightMapCoordinates() {
        vec2 lmCoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
        return clamp01((lmCoord - 0.03125) * 1.06667);
    }

    vec3 GetuSunVec() {
        const vec2 sunRotationData = vec2(cos(sunPathRotation * 0.01745329251994), -sin(sunPathRotation * 0.01745329251994));
        float ang = fract(timeAngle - 0.25);
        ang = (ang + (cos(ang * PI) * - 0.5 + 0.5 - ang) * 0.333) * TAU;
        return vec3(- sin(ang), cos(ang) * sunRotationData);
    }

    #if (defined LIGHT_SHAFT && SMOKER_LIGHT_SHAFT_UNDERWATER == 1 && defined OVERWORLD)
    vec3 GetuSunVecSmoker() {
        const vec2 sunRotationData = vec2(cos(sunPathRotation * 0.01745329251994), -sin(sunPathRotation * 0.01745329251994));
        float ang =  fract(0.0 - 0.25);
        ang = (ang + (cos(ang * PI) * - 0.5 + 0.5 - ang) * 0.333) * TAU;
        return vec3(- sin(ang), cos(ang) * sunRotationData);
    }
    #endif

    vec3 GetSunVec(vec3 uSunVec) {
        const vec2 sunRotationData = vec2(cos(sunPathRotation * 0.01745329251994), -sin(sunPathRotation * 0.01745329251994));
        #if defined (OVERWORLD)
        float ang = fract(timeAngle - 0.25);
        ang = (ang + (cos(ang * PI) * - 0.5 + 0.5 - ang) * 0.333) * TAU;
        return normalize((gbufferModelView * vec4(uSunVec * 2000.0, 1.0)).xyz);
        #elif defined (END)
        float ang = 0.0;
        return normalize((gbufferModelView * vec4(vec3(0.0, sunRotationData * 2000.0), 1.0)).xyz);
        #else
        return vec3(0.0);
        #endif
    }
#endif


/*
UNDEFINED/DEFINED
*/

    #ifdef OVERWORLD
        #ifdef PLANET
            #undef PLANET2
        #endif
        #ifdef PLANET2
            #undef PLANET
        #endif
    #endif

    #ifdef NETHER
        #undef LIGHT_SHAFT
        #undef LENS_FLARE
    #endif

    #ifdef END
        #undef LENS_FLARE
        #ifndef LIGHT_SHAFT_END
            #undef BLACK_HOLE
            #undef LOST_GLARE
        #endif
        #ifndef LOST_GLARE
            #undef BLACK_HOLE
        #endif
    #endif

    #ifndef BLOOM
        #undef DIRTY_LENS
        #undef END_CRITICAL_BLUR
        #undef BLOOM_START
    #endif

    #if (defined OVERWORLD && !defined LIGHT_SHAFT)
        #undef WATER_CAUSTICS
        #undef PROJECTED_CAUSTICS
    #endif

    #ifndef DYNAMIC_HAND_LIGHT
        #undef COLORED_DYNAMIC_HAND_LIGHT
    #endif
