vec4 GetWaterFog(vec3 viewPos) {
    float viewLength = length(viewPos);
    float fogFactor;
    vec3 waterFogColor;

    vec4 worldPos = gbufferModelViewInverse * vec4(viewPos, 1.0);
    worldPos.xyz /= worldPos.w;
    fogFactor = length(worldPos.xz);

    float fog = viewLength / WATER_FOG_DENSITY;

    fog = 1.0 - exp(-3.0 * fog);

    #if WATER_MODE == 0
        waterFogColor = Max0(waterColor.rgb);
    #elif (WATER_MODE == 1 || WATER_MODE == 2)
        waterFogColor = pow2(fogColor) * 0.5;
    #endif

    #ifdef ENABLE_DARKNESS_EFFECT
        float darknessFactor = (MC_VERSION >= 11900) ? darknessFactor : 0.0;
        waterFogColor *= 0.125 * (1.0 - max(blindFactor, darknessFactor));
    #endif

    vec3 waterFogTint;
    #if defined(OVERWORLD)
        waterFogTint = lightCol * eBS * shadowFade * 0.9 + 0.1;
    #elif defined(NETHER)
        waterFogTint = netherCol.rgb;
    #elif defined(END)
        waterFogTint = endCol.rgb;
    #endif

    waterFogTint = sqrt(waterFogTint * dot(waterFogTint, waterFogTint));

    fog = 4.0 * pow(fogFactor * WATER_FOG_DENSITY / far, 4.0);

    return vec4(waterFogColor * waterFogTint, clamp01(fog));
}