#version 330 compatibility

#include "lib/Uniforms.inc"
#include "lib/Common.inc"

in vec4 color;
in vec4 preDownscaleProjPos;
in vec3 viewPos;


void main() {
	if (PixelOutOfScreenBounds(preDownscaleProjPos)) {
		discard;
		return;
	}
	vec3 skyColor = color.rgb;

	

	skyColor.rgb *= 0.0;
	//skyColor.rgb = vec3(1.0, 0.0, 0.0);

	//if (color.a < 0.6f)
	//{
	//	skyColor.rgb = vec3(0.75f);
	//}

	// float saturation = abs(color.r - color.g) + abs(color.r - color.b) + abs(color.g - color.b);
	// bool isStars = saturation <= 0.01 && length(color.rgb) > 0.5;


	bool isStars = renderStage == MC_RENDER_STAGE_STARS;
	if (isStars)
	{
		skyColor.rgb = vec3(0.4);
	}


	

	

	vec3 worldPos = (gbufferModelViewInverse * vec4(viewPos.xyz, 1.0)).xyz;
	vec4 projPos = gbufferProjection * vec4(viewPos.xyz, 1.0);
	projPos /= projPos.w;
	projPos = projPos * 0.5 + 0.5;

	vec3 motion;
	{
		vec3 worldPosPrev = worldPos + cameraPosition - previousCameraPosition;
		vec4 viewPosPrev = gbufferPreviousModelView * vec4(worldPosPrev, 1.0);
		vec4 projPosPrev = gbufferPreviousProjection * vec4(viewPosPrev.xyz, 1.0);
		projPosPrev.xyz /= projPosPrev.w;
		projPosPrev = projPosPrev * 0.5 + 0.5;

		motion = (projPos.xyz - projPosPrev.xyz);
	}

	

	gl_FragData[0] = vec4(skyColor.rgb, 1.0);
	gl_FragData[1] = vec4(0.0f, 0.0f, 0.0f, 1.0f);
	gl_FragData[2] = vec4(motion, isStars ? 0.0 : 1.0);
	
	
	//gl_FragData[2] = vec4(0.0f, 0.0f, 0.0f, 1.0f);
	//gl_FragData[3] = vec4(0.0f, 0.0f, 0.0f, 1.0f);
}

/* DRAWBUFFERS:018 */
