#version 330 compatibility




/*
 _______ _________ _______  _______  _ 
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _ 
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/





in vec4 texcoord;

in vec3 colorSunlight;
in vec3 colorSkylight;
in vec3 colorTorchlight;
in vec3 colorSkyUp;

in vec4 skySHR;
in vec4 skySHG;
in vec4 skySHB;

in vec3 worldLightVector;
in vec3 worldSunVector;

in float timeMidnight;

#include "lib/Uniforms.inc"
#include "lib/Common.inc"


vec2 Texcoord;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////








vec2 GetNearFragment(vec2 coord, float depth, out float minDepth)
{
	
	
	vec2 texel = 1.0 / vec2(viewWidth, viewHeight);
	vec4 depthSamples;
	depthSamples.x = texture2D(depthtex1, coord + texel * vec2(1.0, 1.0)).x;
	depthSamples.y = texture2D(depthtex1, coord + texel * vec2(1.0, -1.0)).x;
	depthSamples.z = texture2D(depthtex1, coord + texel * vec2(-1.0, 1.0)).x;
	depthSamples.w = texture2D(depthtex1, coord + texel * vec2(-1.0, -1.0)).x;

	vec2 targetFragment = vec2(0.0, 0.0);

	if (depthSamples.x < depth)
		targetFragment = vec2(1.0, 1.0);
	if (depthSamples.y < depth)
		targetFragment = vec2(1.0, -1.0);
	if (depthSamples.z < depth)
		targetFragment = vec2(-1.0, 1.0);
	if (depthSamples.w < depth)
		targetFragment = vec2(-1.0, -1.0);


	minDepth = min(min(min(depthSamples.x, depthSamples.y), depthSamples.z), depthSamples.w);

	return coord + texel * targetFragment;
}






#include "lib/Materials.inc"
#include "lib/GBufferData.inc"




 const float x=1./float(8192);
 ivec2 v=ivec2(viewWidth,viewHeight),f=ivec2(6144,6144);
 int y=v.x*v.y,z=37748736;
 int t(int v)
 {
   return v-FloorToInt(mod(float(v),2.))-0;
 }
 int d(int v)
 {
   return v-FloorToInt(mod(float(v),2.))-1;
 }
 int d()
 {
   return t(FloorToInt(floor(pow(float(y),.333333))));
 }
 int t()
 {
   return d(FloorToInt(floor(pow(float(z),.333333))));
 }
 int s=d();
 float m=1./s;
 int i=t();
 float n=1./i;
 vec3 e(vec2 f)
 {
   ivec2 d=ivec2(f.x*v.x,f.y*v.y);
   float x=float(d.y/s),i=float(int(d.x+mod(v.x*x,s))/s);
   i+=floor(v.x*x/s);
   vec3 c=vec3(0.,0.,i);
   c.x=mod(d.x+mod(v.x*x,s),s);
   c.y=mod(d.y,s);
   c.xyz=floor(c.xyz);
   c/=s;
   c.xyz=c.xzy;
   return c;
 }
 vec2 p(vec3 f)
 {
   vec3 i=f.xzy*s;
   i=floor(i+1e-05);
   float x=i.z;
   vec2 r;
   r.x=mod(i.x+x*s,v.x);
   float c=i.x+x*s;
   r.y=i.y+floor(c/v.x)*s;
   r+=.5;
   r/=v;
   return r;
 }
 vec3 r(vec2 v)
 {
   vec2 c=v;
   c.xy/=.75;
   int x=f.x*f.y;
   ivec2 d=ivec2(c.x*f.x,c.y*f.y);
   float y=float(d.y/i),z=float(int(d.x+mod(f.x*y,i))/i);
   z+=floor(f.x*y/i);
   vec3 s=vec3(0.,0.,z);
   s.x=mod(d.x+mod(f.x*y,i),i);
   s.y=mod(d.y,i);
   s.xyz=floor(s.xyz);
   s/=i;
   s.xyz=s.xzy;
   return s;
 }
 vec2 h(vec3 v)
 {
   v=clamp(v,vec3(0.),vec3(1.));
   vec3 c=v.xzy*i;
   c=floor(c+1e-05);
   float x=c.z;
   vec2 r;
   r.x=mod(c.x+x*i,f.x);
   float d=c.x+x*i;
   r.y=c.y+floor(d/f.x)*i;
   r+=.5;
   r/=f;
   r.xy*=.75;
   return r;
 }
 const int c=384,w=c/2-64;
 int l=(c-i)/2;
 float T=floor(cameraPosition.y+.5),K=clamp(T,w-l,w-l),G=T-K;
 vec3 g(vec3 v)
 {
   return v.y+=G,v*=n,v=v+vec3(.5),v;
 }
 vec3 a(vec3 v)
 {
   return v=g(v),v=clamp(v,vec3(0.),vec3(1.)),v;
 }
 vec3 F(vec3 v)
 {
   return v=v-vec3(.5),v*=i,v.y-=G,v;
 }
 vec3 P(vec3 v)
 {
   return v*=m,v=v+vec3(.5),v=clamp(v,vec3(0.),vec3(1.)),v;
 }
 vec3 R(vec3 v)
 {
   return v=v-vec3(.5),v*=s,v;
 }
 vec3 F()
 {
   vec3 v=cameraPosition.xyz+.5,i=previousCameraPosition.xyz+.5,x=floor(v-.0001),z=floor(i-.0001);
   return x-z;
 }
 vec3 F(vec3 v,vec3 f,vec2 d,vec2 y,vec4 c,vec4 i,inout float x,out vec2 r)
 {
   bool z=fract(v.x*2.)>.01&&fract(v.x*2.)<.99||fract(v.y*2.)>.01&&fract(v.y*2.)<.99||fract(v.z*2.)>.01&&fract(v.z*2.)<.99;
   z=!z;
   if(i.x==8||i.x==9||i.x==79||i.x<1.||!z||i.x==20.||i.x==171.||min(abs(f.x),abs(f.z))>.2)
     x=1.;
   if(i.x==50.||i.x==48.||i.x>=44&&i.x<48||i.x==49.||i.x==52.||i.x==76.)
     {
       x=0.;
       if(f.y<.5)
         x=1.;
     }
   if(i.x==54)
     x=0.;
   if(i.x==51||i.x==53||i.x==55)
     x=0.;
   if(i.x>255)
     x=0.;
   vec3 s,e;
   if(f.x>.5)
     s=vec3(0.,0.,-1.),e=vec3(0.,-1.,0.);
   else
      if(f.x<-.5)
       s=vec3(0.,0.,1.),e=vec3(0.,-1.,0.);
     else
        if(f.y>.5)
         s=vec3(1.,0.,0.),e=vec3(0.,0.,1.);
       else
          if(f.y<-.5)
           s=vec3(1.,0.,0.),e=vec3(0.,0.,-1.);
         else
            if(f.z>.5)
             s=vec3(1.,0.,0.),e=vec3(0.,-1.,0.);
           else
              if(f.z<-.5)
               s=vec3(-1.,0.,0.),e=vec3(0.,-1.,0.);
   r=clamp((d.xy-y.xy)*100000.,vec2(0.),vec2(1.));
   float n=.15,w=.15;
   if(i.x==10.||i.x==11.)
     n=.1,w=.1,x=0.;
   if(i.x==51||i.x==55||i.x==53)
     n=.5,w=.1;
   if(i.x==76)
     n=.2,w=.2;
   if(i.x-255.+39.>=103.&&i.x-255.+39.<=113.)
     w=.025,n=.025;
   s=normalize(c.xyz);
   e=normalize(cross(s,f.xyz)*sign(c.w));
   vec3 K=v.xyz+mix(s*n,-s*n,vec3(r.x));
   K.xyz+=mix(e*n,-e*n,vec3(r.y));
   K.xyz-=f.xyz*w;
   return K;
 }struct TOuWFelenO{vec3 FjeDDzWIWi;vec3 FjeDDzWIWiOrigin;vec3 gjulCSuvVu;vec3 ihCMMEIfgL;vec3 HHiebGwFJJ;vec3 GTJIHvOSbK;};
 TOuWFelenO D(Ray v)
 {
   TOuWFelenO i;
   i.FjeDDzWIWi=floor(v.origin);
   i.FjeDDzWIWiOrigin=i.FjeDDzWIWi;
   i.gjulCSuvVu=abs(vec3(length(v.direction))/(v.direction+1e-07));
   i.ihCMMEIfgL=sign(v.direction);
   i.HHiebGwFJJ=(sign(v.direction)*(i.FjeDDzWIWi-v.origin)+sign(v.direction)*.5+.5)*i.gjulCSuvVu;
   i.GTJIHvOSbK=vec3(0.);
   return i;
 }
 void b(inout TOuWFelenO v)
 {
   v.GTJIHvOSbK=step(v.HHiebGwFJJ.xyz,v.HHiebGwFJJ.yzx)*step(v.HHiebGwFJJ.xyz,v.HHiebGwFJJ.zxy),v.HHiebGwFJJ+=v.GTJIHvOSbK*v.gjulCSuvVu,v.FjeDDzWIWi+=v.GTJIHvOSbK*v.ihCMMEIfgL;
 }
 vec3 D(const vec3 v,const vec3 f,vec3 y)
 {
   vec3 x=(f+v)*.5,s=(f-v)*.5,i=y-x,c=abs(i);
   c/=s;
   vec3 z=step(c.yzx,c.xyz)*step(c.zxy,c.xyz);
   return z*sign(i);
 }
 bool D(const vec3 v,const vec3 i,Ray f,inout float x,inout vec3 y)
 {
   vec3 z=f.inv_direction*(v-1e-05-f.origin),c=f.inv_direction*(i+1e-05-f.origin),d=min(c,z),s=max(c,z);
   vec2 r=max(d.xx,d.yz);
   float n=max(r.x,r.y);
   r=min(s.xx,s.yz);
   float m=min(r.x,r.y);
   bool t=m>max(n,0.)&&max(n,0.)<x;
   if(t)
     y=D(v,i,f.origin+f.direction*n),x=n;
   return t;
 }
 float W(vec3 v)
 {
   return 1.;
 }struct eAMCZAKEcI{float nrlJXyapkV;float vPMmNoxUfq;float QQevGhUGeB;float VSCbvpIaKi;vec3 vyHfppOAPK;};
 vec4 k(eAMCZAKEcI v)
 {
   vec4 i;
   v.vyHfppOAPK=max(vec3(0.),v.vyHfppOAPK);
   i.x=v.nrlJXyapkV;
   v.vyHfppOAPK=pow(v.vyHfppOAPK,vec3(.125));
   i.y=PackTwo16BitTo32Bit(v.vyHfppOAPK.x,v.QQevGhUGeB);
   i.z=PackTwo16BitTo32Bit(v.vyHfppOAPK.y,v.VSCbvpIaKi);
   i.w=PackTwo16BitTo32Bit(v.vyHfppOAPK.z,v.vPMmNoxUfq/255.);
   return i;
 }
 eAMCZAKEcI H(vec4 v)
 {
   eAMCZAKEcI i;
   vec2 f=UnpackTwo16BitFrom32Bit(v.y),s=UnpackTwo16BitFrom32Bit(v.z),c=UnpackTwo16BitFrom32Bit(v.w);
   i.nrlJXyapkV=v.x;
   i.QQevGhUGeB=f.y;
   i.VSCbvpIaKi=s.y;
   i.vPMmNoxUfq=c.y*255.;
   i.vyHfppOAPK=pow(vec3(f.x,s.x,c.x),vec3(8.));
   return i;
 }
 eAMCZAKEcI C(vec2 v)
 {
   return v=(floor(v*ScreenSize)+.5)*ScreenTexel,H(texture2DLod(colortex5,v,0));
 }
 vec3 C(vec3 v,vec3 y)
 {
   vec3 i=P(F(v)+y+1.+F());
   float x=W(i);
   vec2 f=p(i);
   vec3 z=C(f).vyHfppOAPK;
   return z*x;
 }
 vec3 D(vec3 v,vec3 y)
 {
   vec3 i=P(F(v)+y+1.);
   float x=W(i);
   vec2 f=p(i);
   vec3 t=C(f).vyHfppOAPK;
   return t*x;
 }
 float F(float v,float y)
 {
   float x=1.;
   #ifdef FULL_RT_REFLECTIONS
   x=clamp(pow(v,.125)+y,0.,1.);
   #else
   x=clamp(v*10.-7.,0.,1.);
   #endif
   return x;
 }
 bool C(vec3 v,float x,Ray i,bool y,inout float f,inout vec3 z)
 {
   bool s=false,r=false;
   #if RAYTRACE_GEOMETRY_QUALITY==0
   if(y)
     return false;
   if(x>=67.)
     return false;
   r=D(v,v+vec3(1.,1.,1.),i,f,z);
   s=r;
   #else
   if(x<40.)
     return r=D(v,v+vec3(1.,1.,1.),i,f,z),r;
   if(x==40.||x==41.||x>=43.&&x<=54.)
     {
       float c=.5;
       if(x==41.)
         c=.9375;
       r=D(v+vec3(0.,0.,0.),v+vec3(1.,c,1.),i,f,z);
       s=s||r;
     }
   if(x==42.||x>=55.&&x<=66.)
     r=D(v+vec3(0.,.5,0.),v+vec3(1.,1.,1.),i,f,z),s=s||r;
   if(x==43.||x==46.||x==47.||x==52.||x==53.||x==54.||x==55.||x==58.||x==59.||x==64.||x==65.||x==66.)
     {
       float c=.5;
       if(x==55.||x==58.||x==59.||x==64.||x==65.||x==66.)
         c=0.;
       r=D(v+vec3(0.,c,0.),v+vec3(.5,.5+c,.5),i,f,z);
       s=s||r;
     }
   if(x==43.||x==45.||x==48.||x==51.||x==53.||x==54.||x==55.||x==57.||x==60.||x==63.||x==65.||x==66.)
     {
       float c=.5;
       if(x==55.||x==57.||x==60.||x==63.||x==65.||x==66.)
         c=0.;
       r=D(v+vec3(.5,c,0.),v+vec3(1.,.5+c,.5),i,f,z);
       s=s||r;
     }
   if(x==44.||x==45.||x==49.||x==51.||x==52.||x==54.||x==56.||x==57.||x==61.||x==63.||x==64.||x==66.)
     {
       float c=.5;
       if(x==56.||x==57.||x==61.||x==63.||x==64.||x==66.)
         c=0.;
       r=D(v+vec3(.5,c,.5),v+vec3(1.,.5+c,1.),i,f,z);
       s=s||r;
     }
   if(x==44.||x==46.||x==50.||x==51.||x==52.||x==53.||x==56.||x==58.||x==62.||x==63.||x==64.||x==65.)
     {
       float c=.5;
       if(x==56.||x==58.||x==62.||x==63.||x==64.||x==65.)
         c=0.;
       r=D(v+vec3(0.,c,.5),v+vec3(.5,.5+c,1.),i,f,z);
       s=s||r;
     }
   if(x>=67.&&x<=82.)
     r=D(v+vec3(6.,0.,6.)/16.,v+vec3(10.,16.,10.)/16.,i,f,z),s=s||r;
   if(x==68.||x==69.||x==70.||x==72.||x==73.||x==74.||x==76.||x==77.||x==78.||x==80.||x==81.||x==82.)
     {
       float c=8.,d=8.;
       if(x==68.||x==70.||x==72.||x==74.||x==76.||x==78.||x==80.||x==82.)
         c=0.;
       if(x==69.||x==70.||x==73.||x==74.||x==77.||x==78.||x==81.||x==82.)
         d=16.;
       r=D(v+vec3(c,6.,7.)/16.,v+vec3(d,9.,9.)/16.,i,f,z);
       s=s||r;
       r=D(v+vec3(c,12.,7.)/16.,v+vec3(d,15.,9.)/16.,i,f,z);
       s=s||r;
     }
   if(x>=71.&&x<=82.)
     {
       float c=8.,w=8.;
       if(x>=71.&&x<=74.||x>=79.&&x<=82.)
         w=16.;
       if(x>=75.&&x<=82.)
         c=0.;
       r=D(v+vec3(7.,6.,c)/16.,v+vec3(9.,9.,w)/16.,i,f,z);
       s=s||r;
       r=D(v+vec3(7.,12.,c)/16.,v+vec3(9.,15.,w)/16.,i,f,z);
       s=s||r;
     }
   #if RAYTRACE_GEOMETRY_QUALITY==2
   if(x>=83.&&x<=86.)
     {
       vec3 c=vec3(0),w=vec3(0);
       if(x==83.)
         c=vec3(0,0,0),w=vec3(16,16,3);
       if(x==84.)
         c=vec3(0,0,13),w=vec3(16,16,16);
       if(x==86.)
         c=vec3(0,0,0),w=vec3(3,16,16);
       if(x==85.)
         c=vec3(13,0,0),w=vec3(16,16,16);
       r=D(v+c/16.,v+w/16.,i,f,z);
       s=s||r;
     }
   if(x>=87.&&x<=102.)
     {
       vec3 c=vec3(0.),w=vec3(1.);
       if(x>=87.&&x<=94.)
         {
           float n=0.;
           if(x>=91.&&x<=94.)
             n=13.;
           c=vec3(0.,n,0.)/16.;
           w=vec3(16.,n+3.,16.)/16.;
         }
       if(x>=95.&&x<=98.)
         {
           float n=13.;
           if(x==97.||x==98.)
             n=0.;
           c=vec3(0.,0.,n)/16.;
           w=vec3(16.,16.,n+3.)/16.;
         }
       if(x>=99.&&x<=102.)
         {
           float n=13.;
           if(x==99.||x==100.)
             n=0.;
           c=vec3(n,0.,0.)/16.;
           w=vec3(n+3.,16.,16.)/16.;
         }
       r=D(v+c,v+w,i,f,z);
       s=s||r;
     }
   if(x>=103.&&x<=113.)
     {
       vec3 c=vec3(0.),w=vec3(1.);
       if(x>=103.&&x<=110.)
         {
           float n=float(x)-float(103.)+1.;
           w.y=n*2./16.;
         }
       if(x==111.)
         w.y=.0625;
       if(x==112.)
         c=vec3(1.,0.,1.)/16.,w=vec3(15.,1.,15.)/16.;
       if(x==113.)
         c=vec3(1.,0.,1.)/16.,w=vec3(15.,.5,15.)/16.;
       r=D(v+c,v+w,i,f,z);
       s=s||r;
     }
   #endif
   #endif
   return s;
 }
 float C(vec3 v,vec3 z,int f,const int y)
 {
   Ray x=MakeRay(v,z);
   TOuWFelenO i=D(x);
   float r=1.,c=100000.;
   vec3 s=vec3(0.);
   for(int w=0;w<y;w++)
     {
       vec3 d=i.FjeDDzWIWi*n;
       vec2 e=h(d);
       vec4 m=texture2DLod(shadowcolor,e,0);
       float t=m.w*255.;
       if(abs(t-36.)<.1||abs(t-38.)<.1)
         {
           continue;
         }
       if(t<240.)
         {
           if(C(i.FjeDDzWIWi,t,x,w==0,c,s))
             {
               r=0.;
               break;
             }
         }
       b(i);
     }
   const float w=y*.33;
   r=mix(r,1.,saturate(c-w));
   return r;
 }
 vec3 L(vec3 v)
 {
   vec4 x=vec4(v,1.);
   x=shadowModelView*x;
   x=shadowProjection*x;
   x/=x.w;
   float c=sqrt(x.x*x.x+x.y*x.y),i=1.f-SHADOW_MAP_BIAS+c*SHADOW_MAP_BIAS;
   x.xy*=.95f/i;
   x.z=mix(x.z,.5,.8);
   x=x*.5f+.5f;
   x.xyz=FinalShadowProjectionTransformation(x.xyz);
   return x.xyz;
 }
 vec3 D(vec3 v,vec3 x,vec3 i,vec3 z,vec3 f,int y)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v-=Fract01(cameraPosition+.5);
   float c,w;
   vec3 s=WorldPosToShadowProjPosBias(v,z,.004,c,w),r=vec3(1.)*shadow2DLod(shadowtex0,vec3(s.xy,s.z),1).x;
   r*=saturate(dot(i,z));
   r*=C(x+z*.01,i,y,3);
   {
     vec4 d=texture2DLod(shadowcolor1,s.xy-vec2(0.,.5),3);
     float n=abs(d.x*256.-(v.y+cameraPosition.y)),e=GetCausticsComposite(v,i,n),t=shadow2DLod(shadowtex0,vec3(s.xy-vec2(0.,.5),s.z+1e-06),3).x;
     r=mix(r,r*e,1.-t);
   }
   r=TintUnderwaterDepth(r);
   return r*(1.-rainStrength);
 }
 vec3 F(vec3 v,vec3 x,vec3 i,vec3 z,vec3 f,int y)
 {
   if(rainStrength>.99)
     return vec3(0.);
   vec3 c=F(v);
   c+=1.;
   c-=Fract01(cameraPosition+.5);
   float s,w;
   vec3 d=WorldPosToShadowProjPosBias(c+z*.99,z,.004,s,w),r=vec3(1.)*shadow2DLod(shadowtex0,vec3(d.xy,d.z),1).x;
   r*=saturate(dot(i,z));
   r*=C(x+z*.99,i,y,3);
   r=TintUnderwaterDepth(r);
   #ifdef GI_SUNLIGHT_STAINED_GLASS_TINT
   float n=shadow2DLod(shadowtex0,vec3(d.xy-vec2(.5,0.),d.z),3).x;
   vec3 m=texture2DLod(shadowcolor,vec2(d.xy-vec2(.5,0.)),3).xyz;
   m*=m;
   r=mix(r,r*m,vec3(1.-n));
   #endif
   return r*(1.-rainStrength);
 }
 vec3 H(vec3 v,vec3 x,vec3 i,vec3 z,vec3 f,int y)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   float c,w;
   vec3 s=WorldPosToShadowProjPosBias(v,z,.004,c,w);
   float n=.5;
   vec3 r=vec3(1.)*shadow2DLod(shadowtex0,vec3(s.xy,s.z-.0006*n),2).x;
   r*=saturate(dot(i,z));
   r*=C(x+z*.01,i,y,3);
   r=TintUnderwaterDepth(r);
   #ifdef GI_SUNLIGHT_STAINED_GLASS_TINT
   float t=shadow2DLod(shadowtex0,vec3(s.xy-vec2(.5,0.),s.z-.0006*n),3).x;
   vec3 m=texture2DLod(shadowcolor,vec2(s.xy-vec2(.5,0.)),3).xyz;
   m*=m;
   r=mix(r,r*m,vec3(1.-t));
   #endif
   return r*(1.-rainStrength);
 }
 vec3 V(vec2 v)
 {
   vec2 x=vec2(v.xy*vec2(viewWidth,viewHeight));
   x*=1./64.;
   const vec2 f[16]=vec2[16](vec2(-1,-1),vec2(0,-.333333),vec2(-.5,.333333),vec2(.5,-.777778),vec2(-.75,-.111111),vec2(.25,.555556),vec2(-.25,-.555556),vec2(.75,.111111),vec2(-.875,.777778),vec2(.125,-.925926),vec2(-.375,-.259259),vec2(.625,.407407),vec2(-.625,-.703704),vec2(.375,-.037037),vec2(-.125,.62963),vec2(.875,-.481482));
   if(v.x<2./viewWidth||v.x>1.-2./viewWidth||v.y<2./viewHeight||v.y>1.-2./viewHeight)
     ;
   else
      x+=f[frameCounter/2%16]*.5;
   x=(floor(x*64.)+.5)/64.;
   vec3 i=texture2D(noisetex,x).xyz,c=vec3(sqrt(.2),sqrt(2.),1.61803);
   i=mod(i+float(frameCounter%2)*.5,vec3(1.));
   return i;
 }
 vec2 S(inout float v)
 {
   return fract(sin(vec2(v+=.1,v+=.1))*vec2(43758.5,22578.1));
 }
 vec3 U(vec2 v)
 {
   vec2 x=vec2(v.xy*vec2(viewWidth,viewHeight))/64.;
   const vec2 f[16]=vec2[16](vec2(-1,-1),vec2(0,-.333333),vec2(-.5,.333333),vec2(.5,-.777778),vec2(-.75,-.111111),vec2(.25,.555556),vec2(-.25,-.555556),vec2(.75,.111111),vec2(-.875,.777778),vec2(.125,-.925926),vec2(-.375,-.259259),vec2(.625,.407407),vec2(-.625,-.703704),vec2(.375,-.037037),vec2(-.125,.62963),vec2(.875,-.481482));
   x+=f[int(mod(float(frameCounter),8.))]*.5;
   x=(floor(x*64.)+.5)/64.;
   vec3 r=texture2D(noisetex,x).xyz;
   return r;
 }
 vec3 C(vec3 v,inout float i,int z)
 {
   vec2 x=U(Texcoord.xy+vec2(i+=.1,i+=.1)).xy;
   x=fract(x+S(i)*.1);
   float c=6.28319*x.x,s=sqrt(x.y);
   vec3 f=normalize(cross(v,vec3(0.,1.,1.))),w=cross(v,f),r=f*cos(c)*s+w*sin(c)*s+v.xyz*sqrt(1.-x.y);
   return r;
 }
 vec3 D(float v,float f,float x,vec3 i)
 {
   vec3 r;
   r.x=x*cos(v);
   r.y=x*sin(v);
   r.z=f;
   vec3 c=abs(i.y)<.999?vec3(0,0,1):vec3(1,0,0),z=normalize(cross(i,vec3(0.,1.,1.))),w=cross(z,i);
   return z*r.x+w*r.y+i*r.z;
 }
 vec3 F(vec2 v,float x,vec3 z)
 {
   float c=2*3.14159*v.x,y=sqrt((1-v.y)/(1+(x*x-1)*v.y)),i=sqrt(1-y*y);
   return D(c,y,i,z);
 }
 float E(float v)
 {
   return 2./(v*v+1e-07)-2.;
 }
 vec3 E(in vec2 v,in float i,in vec3 z)
 {
   float x=E(i),c=2*3.14159*v.x,y=pow(v.y,1.f/(x+1.f)),f=sqrt(1-y*y);
   return D(c,y,f,z);
 }
 float E(float v,float z)
 {
   return 1./(v*(1.-z)+z);
 }
 void H(inout vec3 v,in vec3 i)
 {
   vec3 x=normalize(i.xyz),f=v;
   float c=dot(f,x);
   f=normalize(v-x*saturate(c)*.5);
   v=f;
 }
 vec4 Q(in vec2 v)
 {
   float x=GetDepth(v);
   vec4 i=gbufferProjectionInverse*vec4(v.x*2.f-1.f,v.y*2.f-1.f,2.f*x-1.f,1.f);
   i/=i.w;
   return i;
 }
 vec4 L(in vec2 v,in float y)
 {
   vec4 x=gbufferProjectionInverse*vec4(v.x*2.f-1.f,v.y*2.f-1.f,2.f*y-1.f,1.f);
   x/=x.w;
   return x;
 }
 void C(inout vec3 v,in vec3 i,in vec3 x,vec3 f,float z)
 {
   float r=length(i);
   r*=pow(eyeBrightnessSmooth.y/240.f,6.f);
   r*=rainStrength;
   float c=pow(exp(-r*1e-05),4.);
   c=max(c,.5);
   vec3 s=vec3(dot(colorSkyUp,vec3(1.)))*.05;
   v=mix(s,v,vec3(c));
 }
 vec4 C(float v,float x,vec3 f,vec3 c,vec3 z,vec3 y,vec3 s,float r,float d,float t,float e,bool w)
 {
   float m=1.;
   #ifdef LIGHT_LEAK_FIX
   if(isEyeInWater<1)
     m=saturate(d*100.);
   #endif
   v=max(v-.05,0.);
   x=0.;
   float T=v*v;
   int K=0;
   float G=fract(frameCounter*.0123456);
   vec3 R=U(Texcoord.xy).xyz*.99+.005,l=U(Texcoord.xy+.1).xyz,p=reflect(s,F(U(Texcoord.xy).xy*vec2(1.,.8),T,z)),g=normalize((gbufferModelView*vec4(p.xyz,0.)).xyz);
   if(dot(p,z)<0.)
     p=reflect(p,z);
   #ifdef REFLECTION_SCREEN_SPACE_TRACING
   bool L=false;
   {
     const int k=16;
     vec2 P=Texcoord.xy;
     vec3 H=c.xyz;
     float V=0.;
     vec3 o=c.xyz;
     float W=.1/saturate(dot(-s,z)+.001),E=W*2.,S=1.,J=0.;
     for(int N=0;N<k;N++)
       {
         float Q=float(N),Y=(Q+.5)/float(k);
         vec3 M=g.xyz*W*(.1+length(o)*.1)*S;
         float u=E*(length(o)*.1);
         o+=M;
         vec2 B=ProjectBack(o).xy;
         vec3 q=GetViewPositionNoJitter(B.xy,GetDepth(DownscaleTexcoord(B.xy))).xyz;
         float I=length(o)-length(q)-.02;
         if(o.z>0.)
           {
             break;
           }
         if(I>0.&&I<u&&B.x>0.&&B.x<1.&&B.y>0.&&B.y<1.)
           {
             o-=M;
             S*=.5;
             J+=1.;
             if(J>2.)
               {
                 L=true;
                 P=B.xy;
                 H=q.xyz;
                 V=distance(o,c.xyz)*.4;
                 break;
               }
           }
       }
     vec3 N=(gbufferModelViewInverse*vec4(H,0.)).xyz;
     if(length(N)>far)
       L=false;
     if(L)
       {
         P.xy=floor(P.xy*vec2(viewWidth,viewHeight)+.5)/vec2(viewWidth,viewHeight);
         TemporalJitterProjPos01(P);
         vec2 Q=P.xy*.5;
         Q=clamp(Q,vec2(0.)+ScreenTexel,HalfScreen)+HalfScreen;
         vec3 M=pow(texture2DLod(colortex1,Q,0).xyz,vec3(2.2)),B=M*100.;
         LandAtmosphericScattering(B,H-c,g,p,worldSunVector,1.);
         C(B,H,normalize(c.xyz),normalize(f.xyz),1.);
         if(isEyeInWater>0)
           B*=1.2,UnderwaterFog(B,length(H),s,colorSkyUp,colorSunlight),B/=1.2;
         return vec4(B,saturate(V/4.));
       }
   }
   #endif
   const float M=2.4,H=M;
   vec3 o=f+z*(.01+r*.1)-s*(e*.2/(saturate(dot(y,-s))+1e-06)+.005)*(w?0.:1.);
   o+=Fract01(cameraPosition.xyz+.5);
   Ray B=MakeRay(a(o)*i-vec3(1.),p);
   vec3 S=vec3(1.),J=vec3(0.);
   float Q=0.;
   TOuWFelenO P=D(B);
   float N=far;
   vec3 V=vec3(1.);
   for(int W=0;W<1;W++)
     {
       vec4 E=vec4(0.);
       vec3 k=vec3(0.);
       float u=.5;
       for(int Y=0;Y<REFLECTION_TRACE_LENGTH;Y++)
         {
           k=P.FjeDDzWIWi*n;
           vec2 q=h(k);
           E=texture2DLod(shadowcolor,q,0);
           Q=E.w*255.;
           vec3 I=P.FjeDDzWIWi+.5,O=I-B.origin;
           float A=1.-step(.5,abs(Q-241.));
           vec3 j=E.xyz;
           float X=dot(O,O),Z=saturate(pow(saturate(dot(B.direction,normalize(O))),56.*X)*5.-1.)*5.;
           J+=j*A*u*.25*Z;
           if(Q<240.)
             {
               if(C(P.FjeDDzWIWi,Q,B,Y==0,N,V))
                 {
                   break;
                 }
             }
           b(P);
           u=1.;
         }
       if(E.w*255.<1.f||E.w*255.>254.f)
         {
           vec3 Y=SkyShading(B.direction,worldSunVector,rainStrength);
           Y=DoNightEyeAtNight(Y*12.,timeMidnight)*.083333;
           vec3 q=Y*S,O=q;
           #ifdef CLOUDS_IN_GI
           CloudPlane(O,-B.direction,worldLightVector,worldSunVector,colorSunlight,colorSkyUp,q,timeMidnight,false);
           q=mix(q,O,vec3(m));
           #endif
           q=TintUnderwaterDepth(q);
           J+=q*.1*m;
           N=1000.;
           break;
         }
       vec3 q=vec3(0.);
       {
         vec3 Y=mod(B.origin+B.direction*N,vec3(1.))-.5;
         float O=log2(N*.4*v*TEXTURE_RESOLUTION);
         vec2 I=vec2(0.);
         I+=vec2(Y.z*-V.x,-Y.y)*abs(V.x);
         I+=vec2(Y.x,Y.z*V.y)*abs(V.y);
         I+=vec2(Y.x*V.z,-Y.y)*abs(V.z);
         vec3 A=(B.origin+B.direction*N)*n;
         vec2 X=textureSize(colortex0,0);
         vec4 j=texture2DLod(shadowcolor1,h(k),0);
         vec2 Z=j.xy;
         Z=(floor(Z*X/TEXTURE_RESOLUTION)+.5)/(X/TEXTURE_RESOLUTION);
         vec2 ab=Z+I.xy*(TEXTURE_RESOLUTION/X);
         q=pow(texture2DLod(colortex0,ab,O).xyz,vec3(2.2));
         float ac=step(1.,j.w);
         q*=mix(E.xyz/(j.w+1e-05),vec3(1.),ac);
       }
       if(Q<240.)
         {
           vec3 Y=saturate(E.xyz);
           S*=q;
         }
       if(abs(Q-31.)<.1||abs(Q-38.)<.1)
         J+=.09*S*GI_LIGHT_BLOCK_INTENSITY;
       {
         vec3 Y=vec3(0.),O=vec3(0.);
         if(abs(V.x)>.5)
           Y=vec3(0.,1.,0.),O=vec3(0.,0.,1.);
         if(abs(V.y)>.5)
           Y=vec3(1.,0.,0.),O=vec3(0.,0.,1.);
         if(abs(V.z)>.5)
           Y=vec3(1.,0.,0.),O=vec3(0.,1.,0.);
         vec3 I=Y*n,Z=O*n,j=D(k,V),X=j,A=saturate(j*1e+06),ad=D(k+I,V);
         X+=ad;
         A+=saturate(ad*1e+06);
         vec3 ae=D(k-I,V);
         X+=ae;
         A+=saturate(ae*1e+06);
         vec3 af=D(k+Z,V);
         X+=af;
         A+=saturate(af*1e+06);
         vec3 ag=D(k-Z,V);
         X+=ag;
         A+=saturate(ag*1e+06);
         X/=A+vec3(1e-06);
         J+=X*H*S;
       }
       vec3 Y=B.direction*N,O=D(o+Y,B.origin+Y,worldLightVector,V,p,i)*S*M*colorSunlight*m;
       if(isEyeInWater>0)
         ;
       J+=O;
     }
   vec3 Y=c.xyz+g*N,O=(gbufferModelViewInverse*vec4(Y.xyz,0.)).xyz;
   {
     vec3 E=ProjectBack(Y);
     if(E.x>ScreenTexel.x&&E.x<1.-ScreenTexel.x&&E.y>ScreenTexel.y&&E.y<1.-ScreenTexel.y&&Y.z<0.)
       {
         vec2 q=E.xy*2.-1.;
         float k=1.-max(smoothstep(.5,1.,abs(q.x)),smoothstep(.5,1.,abs(q.y)));
         vec2 I=E.xy*.5+HalfScreen.xy;
         vec3 X=GetViewPositionNoJitter(E.xy,GetDepth(DownscaleTexcoord(E.xy))).xyz;
         if(length(X-Y)<.03*length(X))
           J=mix(J.xyz,pow(texture2DLod(colortex1,I,0).xyz,vec3(2.2))*100.,vec3(k));
       }
   }
   if(N<1000.)
     LandAtmosphericScattering(J,Y-c,g,p,worldSunVector,1.);
   if(isEyeInWater>0)
     J*=1.2,UnderwaterFog(J,length(O),s,colorSkyUp,colorSunlight),J/=1.2;
   N*=saturate(dot(-s,z))*2.;
   return vec4(J,saturate(N/4.));
 }
 vec4 M(float v)
 {
   float x=v*v,s=x*v;
   vec4 i;
   i.x=-s+3*x-3*v+1;
   i.y=3*s-6*x+4;
   i.z=-3*s+3*x+3*v+1;
   i.w=s;
   return i/6.f;
 }
 vec4 M(in sampler2D v,in vec2 i)
 {
   vec2 x=vec2(viewWidth,viewHeight);
   i*=x;
   i-=.5;
   float c=fract(i.x),s=fract(i.y);
   i.x-=c;
   i.y-=s;
   vec4 f=M(c),w=M(s),z=vec4(i.x-.5,i.x+1.5,i.y-.5,i.y+1.5),d=vec4(f.x+f.y,f.z+f.w,w.x+w.y,w.z+w.w),r=z+vec4(f.y,f.w,w.y,w.w)/d,y=texture2DLod(v,vec2(r.x,r.z)/x,0),n=texture2DLod(v,vec2(r.y,r.z)/x,0),O=texture2DLod(v,vec2(r.x,r.w)/x,0),t=texture2DLod(v,vec2(r.y,r.w)/x,0);
   float Y=d.x/(d.x+d.y),e=d.z/(d.z+d.w);
   return mix(mix(t,O,Y),mix(n,y,Y),e);
 }
 bool P(vec3 v,vec3 i)
 {
   vec3 x=normalize(cross(dFdx(v),dFdy(v))),c=normalize(i-v),w=normalize(c);
   return distance(v,i)<.05;
 }
 vec3 o(vec2 v)
 {
   vec2 x=vec2(viewWidth,viewHeight),s=1./x,c=v*x,i=floor(c-.5)+.5,f=c-i,z=f*f,w=f*z;
   float y=.5;
   vec2 d=-y*w+2.*y*z-y*f,n=(2.-y)*w-(3.-y)*z+1.,r=-(2.-y)*w+(3.-2.*y)*z+y*f,B=y*w-y*z,t=n+r,Y=s*(i+r/t);
   vec3 m=texture2DLod(colortex4,vec2(Y.x,Y.y),0).xyz;
   vec2 V=s*(i-1.),O=s*(i+2.);
   vec4 e=vec4(texture2DLod(colortex4,vec2(Y.x,V.y),0).xyz,1.)*(t.x*d.y)+vec4(texture2DLod(colortex4,vec2(V.x,Y.y),0).xyz,1.)*(d.x*t.y)+vec4(m,1.)*(t.x*t.y)+vec4(texture2DLod(colortex4,vec2(O.x,Y.y),0).xyz,1.)*(B.x*t.y)+vec4(texture2DLod(colortex4,vec2(Y.x,O.y),0).xyz,1.)*(t.x*B.y);
   return max(vec3(0.),e.xyz*(1./e.w));
 }
 void main()
 {
   Texcoord=texcoord.xy;
   if(texcoord.x<HalfScreen.x||texcoord.y<HalfScreen.y)
     gl_FragData[0]=texture2DLod(colortex0,Texcoord.xy,0),gl_FragData[1]=texture2DLod(colortex1,Texcoord.xy,0),gl_FragData[2]=texture2DLod(colortex7,Texcoord.xy,0);
   else
     {
       Texcoord=texcoord.xy-HalfScreen;
       GBufferData v=GetGBufferData(Texcoord.xy);
       GBufferDataTransparent x=GetGBufferDataTransparent(Texcoord.xy);
       MaterialMask i=CalculateMasks(v.materialID,Texcoord.xy),c=CalculateMasks(x.materialID,Texcoord.xy);
       bool z=x.depth<v.depth;
       if(z)
         v.depth=x.depth,v.normal=x.normal,v.smoothness=x.smoothness,v.metalness=0.,v.mcLightmap=x.mcLightmap,c.sky=0.;
       bool y=abs(111.-x.materialID*255.)<.4&&z;
       vec4 f=GetViewPosition(Texcoord.xy,v.depth),s=gbufferModelViewInverse*vec4(f.xyz,1.),d=gbufferModelViewInverse*vec4(f.xyz,0.);
       vec3 r=normalize(f.xyz),w=normalize(d.xyz),Y=normalize((gbufferModelViewInverse*vec4(v.normal,0.)).xyz),n=normalize((gbufferModelViewInverse*vec4(v.geoNormal,0.)).xyz);
       float e=length(f.xyz);
       vec4 O=vec4(0.);
       float t=F(v.smoothness,v.metalness);
       if(t>.0001&&c.sky<.5)
         O=C(1.-v.smoothness,v.metalness,s.xyz,f.xyz,Y.xyz,n,w.xyz,i.leaves,v.mcLightmap.y,ExpToLinearDepth(v.depth),v.parallaxOffset,z);
       vec4 m=texture2DLod(colortex1,Texcoord.xy+HalfScreen,0);
       vec3 B=m.xyz;
       B.xyz=pow(B.xyz,vec3(2.2));
       if(y)
         B.xyz*=pow(x.albedo.xyz,vec3(1.))*10.;
       if(z&&!y)
         {
           vec3 V=GetViewPosition(Texcoord.xy,texture2DLod(depthtex1,Texcoord.xy,0).x).xyz;
           float a=length(V.xyz),p=a-e;
           vec3 E=x.normal-x.geoNormal*1.05;
           float K=saturate(p*.5)*.5;
           vec2 T=Texcoord.xy+E.xy/(e+1.5)*K;
           T=clamp(T,vec2(ScreenTexel),HalfScreen-ScreenTexel*2.);
           {
             float q=ExpToLinearDepth(texture2DLod(depthtex1,T,0).x),Q=ExpToLinearDepth(texture2DLod(depthtex0,T,0).x);
             if(Q>=q)
               T=Texcoord.xy;
           }
           B.xyz=pow(texture2DLod(colortex1,T.xy+HalfScreen,0).xyz,vec3(2.2));
           V=GetViewPosition(T.xy,texture2DLod(depthtex1,T.xy,0).x).xyz;
           f=GetViewPosition(T.xy,texture2DLod(depthtex0,T.xy,0).x);
           a=length(V.xyz);
           e=length(f.xyz);
           p=a-e;
           if(c.water>.5&&isEyeInWater<1)
             B.xyz*=100.,UnderwaterFog(B.xyz,p,w,colorSkyUp,colorSunlight),B.xyz*=.01;
           if(c.stainedGlass>.5)
             {
               vec3 q=normalize(x.albedo.xyz+.0001)*pow(length(x.albedo.xyz),.5);
               B.xyz*=mix(vec3(1.),q,vec3(pow(x.albedo.w,.2)));
               B.xyz*=mix(vec3(1.),q,vec3(pow(x.albedo.w,.2)));
             }
         }
       B.xyz=pow(B.xyz,vec3(1./2.2));
       gl_FragData[0]=texture2DLod(colortex0,Texcoord.xy,0);
       gl_FragData[1]=vec4(B.xyz,v.smoothness);
       gl_FragData[2]=max(vec4(0.),O*vec4(vec3(.1),1.));
     }
 };




/* DRAWBUFFERS:017 */
