struct temporal_settings{
    int steps;

    float weight;
    float reprojection;
    float sharpen;

    float strength;
    float velocity_full;
    float velocity_none;
    float velocity_span;
    vec2 velocity_max;
};

temporal_settings temporal_s(){
    temporal_settings ts;

    ts.weight = 0.95;
    ts.reprojection = 0.25;
    ts.sharpen = 0.5 + ADAPTIVE_SHARPEN_STRENGTH;

    #if POST_PROCESS_PRESET == 3
        ts.sharpen = 12.0 + ADAPTIVE_SHARPEN_STRENGTH;
    #endif

    //Motion Blur part
    ts.steps = 1;

    ts.strength = 0.02 + MOTION_BLUR_STRENGTH;
    ts.velocity_max = vec2(0.3);
    ts.velocity_full = 2;
    ts.velocity_none = 15;
    ts.velocity_span = ts.velocity_none - ts.velocity_full;
    
    return ts;
}

struct exposure_settings{
    float speed_min;
    float speed_max;

    float bias;
    float offset;
    float calibration;

    float iso;
    float aperture;
    float shutter_speed;
};

exposure_settings exposure_s(){
    exposure_settings e;

    e.speed_min = 0.5;
    e.speed_max = 2.5;

    e.calibration = 12.5;
    e.offset = 0.1 + EXPOSURE_BIAS;

    #if POST_PROCESS_PRESET == 3
        e.offset = -1.0;
    #endif

    #if defined END_WORLD
        e.offset -= 2.0;
    #endif

    e.iso = ISO;
    e.aperture = 1.0 / APERTURE;
    e.shutter_speed = SHUTTER_SPEED;

    return e;
}

struct bloomSettings{
    int steps0;
    int steps1;
    
    float strength;
    float underwater_strength;
};

bloomSettings s_bloom(){
    bloomSettings b;

    b.steps0 = 7;
    b.steps1 = 5;

    b.strength = -1.3 + BLOOM_STRENGTH;
    b.underwater_strength = UNDERWATER_BLOOM_STRENGTH;
    
    return b;
}

struct dof_settings{
    int steps;

    float maxBlur;
	float mipmap;
	float focal;
    float aperture;
	float strength;
    float ca_strength;
};

dof_settings sdof(){
    dof_settings d;

    d.steps = 40;

    d.maxBlur = 0.25;
	d.mipmap = 3.0;

    d.strength = 1.0 + DOF_STRENGTH;
    d.focal = 2.4 / DOF_FOCAL;
    d.aperture = 0.6 * DOF_APERTURE;
    d.ca_strength = 4.0 + CHROMATIC_ABERRATION_STRENGTH;

    return d;
}

struct aces_settings{
    float rrt_glow_gain;
    float rrt_glow_mid;

    float rrt_red_scale;
    float rrt_red_pivot;
    float rrt_red_hue;
    float rrt_red_width;

    float rrt_sat_factor;

    float odt_cinema_white;
    float odt_cinema_black;

    float odt_dim_surround_gamma;
    float odt_sat_factor;

    float odt_dispgamma;
    float odt_l_w;
    float odt_l_b;
    
    vec3 half_max;
};

aces_settings aces_s(){
    aces_settings aces;

    aces.rrt_glow_gain = 0.05;
    aces.rrt_glow_mid = 0.08;

    aces.rrt_red_scale = 0.82;
    aces.rrt_red_pivot = 0.03;
    aces.rrt_red_hue = 0.0;
    aces.rrt_red_width = 135.0;

    aces.rrt_sat_factor = 0.96;

    aces.odt_cinema_white = 48.0;
    aces.odt_cinema_black = aces.odt_cinema_white / 2400.0;

    aces.odt_dim_surround_gamma = 0.9811;
    aces.odt_sat_factor = 0.93;

    aces.odt_dispgamma = 2.4;
    aces.odt_l_w = 1.0;
    aces.odt_l_b = 0.0;
    
    aces.half_max = vec3(65535.0);

    return aces;
}

struct filmic_settings{
	float a;	//Shoulder strength
	float b;	//Linear strength
	float c;	//Linear angle
	float d;	//Toe strength
	float e;	//Toe numerator
	float f;	//Toe denominator
	float w;	//Linera white
};


filmic_settings sfilmic(){
	filmic_settings f;

    //Hable filmic value
	//f.a = 0.15;
	//f.b = 0.50;
	//f.c = 0.10;
	//f.d = 0.20;
	//f.e = 0.02;
	//f.f = 0.30;
	//f.w = 11.2;

    //GTA 5 filmic value
	f.a = 0.22;
	f.b = 0.30;
	f.c = 0.10;
	f.d = 0.20;
	f.e = 0.01;
	f.f = 0.30;
	f.w = 4.0;

	return f;
}

struct color_correction{
	float saturation;
	float vibrance;
	float contrast;
	float contrastMidpoint;

	vec3 gain;
	vec3 lift;
	vec3 gamma;
};

color_correction scolor_correction(){
    color_correction c;

    #if POST_PROCESS_PRESET == 0
        c.saturation = 1.0 + SATURATION;
        c.vibrance = 0.1 + VIBRANCE;
        c.contrast = 0.96 + CONTRAST;
        c.contrastMidpoint = 0.5;
        c.lift = vec3(0.0) + LIFT * 0.01;
        c.gain = vec3(1.02) + GAIN;
        c.gamma = vec3(0.93) + GAMMA;
    #elif POST_PROCESS_PRESET == 1
        c.saturation = 1.1 + SATURATION;
        c.vibrance = 1.0 + VIBRANCE;
        c.contrast = 1.05 + CONTRAST;
        c.contrastMidpoint = 0.5;
        c.lift = vec3(0.0) + LIFT * 0.01;
        c.gain = vec3(1.0) + GAIN;
        c.gamma = vec3(1.0) + GAMMA;
    #elif POST_PROCESS_PRESET == 2
        c.saturation = SATURATION;
        c.vibrance = VIBRANCE;
        c.contrast = 1.1 + CONTRAST;
        c.contrastMidpoint = 0.5;
        c.lift = vec3(0.0) + LIFT * 0.01;
        c.gain = vec3(1.0) + GAIN;
        c.gamma = vec3(1.0) + GAMMA;
    #elif POST_PROCESS_PRESET == 3
        c.saturation = 1.0 + SATURATION;
        c.vibrance = 1.0 + VIBRANCE;
        c.contrast = 4.0 + CONTRAST;
        c.contrastMidpoint = 0.5;
        c.lift = vec3(0.0) + LIFT * 0.01;
        c.gain = vec3(1.0) + GAIN;
        c.gamma = vec3(1.0) + GAMMA;
    #endif

    return c;
}