#if defined SHADERS_VERTEX
    out vec2 vertex_coord;

    void main(){
        vertex_coord = layout_texcoord.xy;
        gl_Position = vec4(layout_position.xy * 2.0 - 1.0, 0.0, 1.0);
    }
#elif defined SHADERS_FRAGMENT
    in vec2 vertex_coord;

    /* RENDERTARGETS:11 */
    layout (location = 0) out vec4 buffers0;

    #include "/program/shaders1/common/indirect/filter.glsl"

    void main(){
        gbuffers g = gbuffers_data(vertex_coord);
        specular s = specular_data(g.spec, g.albedo, g.id);
        space_position sp = position(vertex_coord, g.depth, false);
        materials m = material(g.depth, g.id);

        g.depth.y = projection_depth(g.depth.y);

        #if defined DEFERRED4
            buffers0 = indirect_filter(vertex_coord, g.normal, g.depth.y, 1.0);
        #elif defined DEFERRED5
            buffers0 = indirect_filter(vertex_coord, g.normal, g.depth.y, 2.0);
        #elif defined DEFERRED6
            buffers0 = indirect_filter(vertex_coord, g.normal, g.depth.y, 3.0);
        #endif

        buffers0 = saturate_16(buffers0);
    }
#endif