/*
float volumetric_clouds_shadow(vec3 position){
     vec3 shadow_position = mat3(shadowModelView) * position;
          shadow_position /= 200.0;
          shadow_position *= 0.5 + 0.5;

     return texture2(colortex15, shadow_position.xy / 1024.0).y;
}
*/

vec3 volumetric_shadow(vec3 shadow_position, vec3 position, bool water){
    shadow_settings s = shadow_s();
    water_settings ws = water_s();

    shadow_position = shadow_distortion(s, shadow_position) * 0.5 + 0.5;
    
    if(any(greaterThanEqual(abs(shadow_position), vec3(1.0)))) return vec3(0.0);

    vec3 shadow = vec3(0.0);

    vec4 color0 = texture2(shadowcolor0, shadow_position.xy);
    vec4 color1 = texture2(shadowcolor1, shadow_position.xy);

    float depth0 = texture2(shadowtex0, shadow_position.xy).x;
    float depth1 = texture2(shadowtex1, shadow_position.xy).x;

    float shadow_depth0 = depth0 > shadow_position.z ? 1.0 : 0.0;
    float shadow_depth1 = depth1 > shadow_position.z ? 1.0 : 0.0;

    if(water){
        float translucent_depth = (depth1 * 8.0 - 4.0);
              translucent_depth = translucent_depth * shadowProjectionInverse[2].z + shadowProjectionInverse[3].z;
              translucent_depth = (translucent_depth - trans_mad(shadowModelView, position).z);

        //if(translucent_depth > 0.0) return vec3(1.0);

        vec3 transmittance = exp2(ws.attenuation_coefficient * ws.density * translucent_depth);

        #ifdef WATER_CAUSTICS
            float caustics_depth = saturate(translucent_depth * 2.0);

            float caustics = color1.z * 2.0 - 1.0;
                  caustics = pow(caustics , WATER_CAUSTICS_STRENGTH);
                  caustics = caustics + caustics_depth * (1.0 - caustics_depth);
        #else
            float caustics = 1.0;
        #endif
		
		shadow += vec3(shadow_depth1);
        //shadow *= transmittance;
        //shadow *= caustics;
    } else {
		#ifdef COLORED_SHADOW
			shadow += mix(vec3(shadow_depth0), color0.xyz * (1.0 - color0.w), saturate(shadow_depth1 - shadow_depth0));
        #else
            shadow += vec3(shadow_depth1);
        #endif
	}

    return shadow * volumetric_clouds_shadow(position - cameraPosition);
}