float[9] evaluate_sh(vec3 direction){
    direction = norm(direction);
    //direction = saturate(direction);

    float x = direction.x;
    float y = direction.y;
    float z = direction.z;

    const float c1 = 0.42904276540489171563379376569857;
    const float c2 = 0.51166335397324424423977581244463;
    const float c3 = 0.24770795610037568833406429782001;
    const float c4 = 0.88622692545275801364908374167057;

    return float[9](1.0 * c4,
                    y * 2.0 * c2,
                    z * 2.0 * c2,
                    x * 2.0 * c2,
                    (y - z) * 2.0 * c1,
                    (y * x) * 2.0 * c1,
                    (3.0 * z * z - 1.0) * c3,
                    (x * z) * 2.0 * c1,
                    (x * x - y * y) * c1);
}

#if defined SHADERS_VERTEX
    out mat3 skylight0;
    out mat3 skylight1;

    out vec3[9] ray_sh;
    out vec3[9] sky_sh;
 
    #include "/program/shaders1/common/atmosphere/projection.glsl"

    float phase_rayleigh(float x){
        return (3.0 / (16.0 * pi)) * (1.0 + x * x);
    }

    void vertex_skylight(){
        atmosphere_constant ac = atmosphere_s();

        const int coeff_count = 9;
        const int steps = 12;

        float radius = sunAngle < 0.5 ? ac.sun_angular_radius : ac.moon_angular_radius;

        vec3 light_direction = norm(shadowLightPosition);
             light_direction = mat3(gbufferModelViewInverse) * light_direction;

        for(int i = 0; i < coeff_count; ++i){
            ray_sh[i] = vec3(0.0);
            sky_sh[i] = vec3(0.0);
        }

        for(int a = 0; a < steps; ++a){
            vec2 offset = vec2(a + 0.5) / steps;

            vec3 ray_dir = generate_cone_vector(light_direction, offset, radius);
            vec3 sky_dir = generate_unit_vector(offset);

            #if ATMOSPHERE_TYPE == 0
                vec3 sunlight = texture2(colortex2, project_sphere(ray_dir)).xyz * (sunAngle < 0.5 ? ac.sun_luminance : ac.moon_luminance);
                     sunlight *= saturate(dot(vec3(0.0, 1.0, 0.0), light_direction) * 20.0) * phase_rayleigh(2.7);

                vec3 skylight = texture2(colortex1, project_sphere(sky_dir)).xyz * 0.75 * (1.0 + SHADOW_BRIGHTNESS);
                     skylight = skylight + skylight.g * mix(0.4, 2.0, wetness);
            #elif ATMOSPHERE_TYPE == 1
                vec3 sunlight = sunAngle < 0.5 ? ac.sun_luminance : vec3(0.0);
                vec3 skylight = vec3(0.0);
            #endif

            float ray_coeff[9] = evaluate_sh(ray_dir);
            float sky_coeff[9] = evaluate_sh(sky_dir);

            for(int i = 0; i < coeff_count; ++i){
                ray_sh[i] += sunlight * ray_coeff[i];
                sky_sh[i] += skylight * sky_coeff[i];
            }
        }

        for(int i = 0; i < coeff_count; ++i){
            ray_sh[i] *= 1.0 / float(steps);
            sky_sh[i] *= 4.0 * pi / float(steps);
        }
    }
#elif defined SHADERS_FRAGMENT
    vec3 spherical_hamonics(vec3[9] sh, vec3 normal){
        vec3 color = vec3(0.0);
        float coeff[9] = evaluate_sh(normal);

        for(int i = 0; i < 9; ++i){
            color += sh[i] * coeff[i];
        }

        return color;
    }
#endif